/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.system.util;

import com.aimluck.eip.cayenne.om.account.EipMCompany;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.services.config.ALConfigHandler;
import com.aimluck.eip.services.config.ALConfigService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.security.UnknownUserException;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class SystemUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)SystemUtils.class.getName());
    public static final String COMPANY_PORTLET_NAME = "Company";
    private static final int WEBAPPSERVER_PORT = JetspeedResources.getInt((String)"aipo.webappserver.port", (int)80);
    public static final String SYSTEM_PORTLET_NAME = "System";

    public static ALBaseUser getBaseUser(RunData rundata, Context context) {
        String userid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (userid == null) {
                logger.debug((Object)"Empty ID...");
                return null;
            }
            ALBaseUser user = (ALBaseUser)JetspeedSecurity.getUser((String)userid);
            if ("T".equals(user.getDisabled())) {
                return null;
            }
            return (ALBaseUser)JetspeedSecurity.getUser((String)userid);
        }
        catch (UnknownUserException uex) {
            logger.error((Object)("UnknownUserException : UserID = " + userid));
            return null;
        }
        catch (Exception ex) {
            logger.error((Object)"system", (Throwable)ex);
            return null;
        }
    }

    public static EipMCompany getEipMCompany(RunData rundata, Context context) {
        EipMCompany result = null;
        String id = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (id == null || Integer.valueOf(id) == null) {
                logger.debug((Object)"Empty ID...");
                return result;
            }
            Expression exp = ExpressionFactory.matchDbExp((String)"COMPANY_ID", (Object)Integer.valueOf(id));
            List list = Database.query(EipMCompany.class, (Expression)exp).fetchList();
            if (list == null || list.size() == 0) {
                logger.debug((Object)"Not found ID...");
                return result;
            }
            result = (EipMCompany)list.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"system", (Throwable)ex);
        }
        return result;
    }

    public static int getServerPort() {
        return WEBAPPSERVER_PORT;
    }

    @Deprecated
    public static String getUrl(String ip, int port, String servername, boolean isGlobal) {
        if (ip == null || ip.length() == 0 || port == -1) {
            return "";
        }
        String protocol = isGlobal ? ALConfigService.get((ALConfigHandler.Property)ALConfigHandler.Property.ACCESS_GLOBAL_URL_PROTOCOL) : ALConfigService.get((ALConfigHandler.Property)ALConfigHandler.Property.ACCESS_LOCAL_URL_PROTOCOL);
        StringBuffer url = new StringBuffer();
        if (port == 80 || port == 443) {
            url.append(protocol).append("://").append(ip).append("/").append(servername).append("/");
        } else {
            url.append(protocol).append("://").append(ip).append(":").append(port).append("/").append(servername).append("/");
        }
        return url.toString();
    }
}

