/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.category;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.category.util.CommonCategoryUtils;
import com.aimluck.eip.cayenne.om.portlet.EipTCommonCategory;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.Calendar;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class CommonCategoryFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CommonCategoryFormData.class.getName());
    private Integer category_id;
    private ALStringField name;
    private ALStringField note;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        try {
            this.category_id = Integer.valueOf(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid"));
        }
        catch (Exception e) {
            this.category_id = null;
        }
    }

    public void initField() {
        this.name = new ALStringField();
        this.name.setFieldName("\u5171\u6709\u30ab\u30c6\u30b4\u30ea\u540d");
        this.name.setTrim(true);
        this.note = new ALStringField();
        this.note.setFieldName("\u30e1\u30e2");
        this.note.setTrim(true);
    }

    protected void setValidator() {
        this.name.setNotNull(true);
        this.name.limitMaxLength(50);
        this.note.limitMaxLength(1000);
    }

    protected boolean validate(List<String> msgList) {
        try {
            SelectQuery query = Database.query(EipTCommonCategory.class);
            Expression exp = ExpressionFactory.matchExp((String)"name", (Object)this.name.getValue());
            query.setQualifier(exp);
            if ("update".equals(this.getMode())) {
                Expression exp3 = ExpressionFactory.noMatchDbExp((String)"COMMON_CATEGORY_ID", (Object)this.category_id);
                query.andQualifier(exp3);
            }
            if (query.fetchList().size() != 0) {
                msgList.add("\u5171\u6709\u30ab\u30c6\u30b4\u30ea\u540d\u300e <span class='em'>" + this.name.toString() + "</span> \u300f\u306f\u65e2\u306b\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
            }
        }
        catch (Exception ex) {
            logger.error((Object)"CommonCategoryFormData.validate", (Throwable)ex);
            return false;
        }
        this.name.validate(msgList);
        this.note.validate(msgList);
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTCommonCategory category = CommonCategoryUtils.getEipTCommonCategory(rundata, context);
            if (category == null) {
                return false;
            }
            this.name.setValue(category.getName());
            this.note.setValue(category.getNote());
        }
        catch (Exception ex) {
            logger.error((Object)"CommonCategoryFormData.loadFormData", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTCommonCategory category = (EipTCommonCategory)Database.create(EipTCommonCategory.class);
            category.setName(this.name.getValue());
            category.setNote(this.note.getValue());
            category.setCreateUserId(Integer.valueOf(ALEipUtils.getUserId((RunData)rundata)));
            category.setUpdateUserId(Integer.valueOf(ALEipUtils.getUserId((RunData)rundata)));
            category.setCreateDate(Calendar.getInstance().getTime());
            category.setUpdateDate(Calendar.getInstance().getTime());
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(category.getCommonCategoryId().intValue(), 300, this.name.getValue());
        }
        catch (Throwable t) {
            Database.rollback();
            logger.error((Object)"CommonCategoryFormData.insertFormData", t);
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTCommonCategory category = CommonCategoryUtils.getEipTCommonCategory(rundata, context);
            if (category == null) {
                return false;
            }
            boolean authority_edit = CommonCategoryUtils.checkPermission(rundata, context, 8, "manhour_common_category_other");
            ALEipUser eipUser = ALEipUtils.getALEipUser((RunData)rundata);
            if ((long)category.getCreateUserId().intValue() != eipUser.getUserId().getValue() && !authority_edit) {
                return false;
            }
            category.setName(this.name.getValue());
            category.setNote(this.note.getValue());
            category.setUpdateUserId(Integer.valueOf(ALEipUtils.getUserId((RunData)rundata)));
            category.setUpdateDate(Calendar.getInstance().getTime());
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(category.getCommonCategoryId().intValue(), 300, this.name.getValue());
        }
        catch (Throwable t) {
            Database.rollback();
            logger.error((Object)"CommonCategoryFormData.updateFormData", t);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTCommonCategory category = CommonCategoryUtils.getEipTCommonCategory(rundata, context);
            if (category == null) {
                return false;
            }
            boolean authority_delete = CommonCategoryUtils.checkPermission(rundata, context, 16, "manhour_common_category_other");
            ALEipUser eipUser = ALEipUtils.getALEipUser((RunData)rundata);
            if ((long)category.getCreateUserId().intValue() != eipUser.getUserId().getValue() && !authority_delete) {
                return false;
            }
            CommonCategoryUtils.setDefaultCommonCategoryToSchedule(category);
            int entityId = category.getCommonCategoryId();
            String categoryName = category.getName();
            Database.delete((Persistent)category);
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(entityId, 300, categoryName);
        }
        catch (Throwable t) {
            Database.rollback();
            logger.error((Object)"CommonCategoryFormData.deleteFormData", t);
            return false;
        }
        return true;
    }

    public Integer getCategoryId() {
        return this.category_id;
    }

    public ALStringField getName() {
        return this.name;
    }

    public ALStringField getNote() {
        return this.note;
    }

    public String getAclPortletFeature() {
        return "manhour_common_category";
    }
}

