/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.webmail;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipMMailAccount;
import com.aimluck.eip.cayenne.om.portlet.EipTMail;
import com.aimluck.eip.cayenne.om.portlet.EipTMailFilter;
import com.aimluck.eip.cayenne.om.portlet.EipTMailFolder;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.mail.ALFolder;
import com.aimluck.eip.mail.ALMailFactoryService;
import com.aimluck.eip.mail.ALMailHandler;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import com.aimluck.eip.webmail.util.WebMailUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class WebMailFolderFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WebMailFolderFormData.class.getName());
    private ALStringField folder_name;
    private ALNumberField access_flag;
    private ALEipUser login_user;
    private EipMMailAccount mailAccount;
    private String folderId = null;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        EipTMailFolder folder;
        super.init(action, rundata, context);
        int mailAccountId = 0;
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context)) {
            String entityId;
            try {
                mailAccountId = Integer.parseInt(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"accountid"));
            }
            catch (Exception e) {
                logger.error((Object)"[WebMailFolderFormData]", (Throwable)e);
                return;
            }
            if (rundata.getParameters().containsKey((Object)"entityid") && !"new".equals(entityId = rundata.getParameters().getString("entityid"))) {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"entityid", (String)entityId);
                this.folderId = entityId;
            }
        }
        this.login_user = ALEipUtils.getALEipUser((RunData)rundata);
        this.mailAccount = ALMailUtils.getMailAccount((int)((int)this.login_user.getUserId().getValue()), (int)mailAccountId);
        if (this.mailAccount == null) {
            return;
        }
        if (this.folderId != null && (folder = WebMailUtils.getEipTMailFolder(this.mailAccount, this.folderId)) == null) {
            logger.error((Object)"[WebMail Folder] mail folder was not found.");
            return;
        }
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        if (res && "update".equals(this.getMode())) {
            this.folderId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"folderid");
        }
        return res;
    }

    public void initField() {
        this.folder_name = new ALStringField();
        this.folder_name.setFieldName(ALLocalizationUtils.getl10n((String)"WEBMAIL_FOLDER_NAME"));
        this.folder_name.setTrim(true);
    }

    protected void setValidator() {
        this.folder_name.setNotNull(true);
        this.folder_name.limitMaxLength(128);
    }

    protected boolean validate(List<String> msgList) {
        this.folder_name.validate(msgList);
        if (this.existsFolderName(this.folder_name.getValue(), "update".equals(this.getMode()))) {
            msgList.add("\u3053\u306e\u30d5\u30a9\u30eb\u30c0\u540d\u3068\u540c\u3058\u30d5\u30a9\u30eb\u30c0\u304c\u3059\u3067\u306b\u5b58\u5728\u3059\u308b\u305f\u3081\u3001\u767b\u9332\u3067\u304d\u307e\u305b\u3093\u3002\u30d5\u30a9\u30eb\u30c0\u540d\u3092\u5909\u66f4\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        return msgList.size() == 0;
    }

    private boolean existsFolderName(String fname, boolean is_update) {
        if (fname == null || "".equals(fname)) {
            return false;
        }
        try {
            Expression exp2;
            List list;
            SelectQuery query = Database.query(EipTMailFolder.class);
            Expression exp = ExpressionFactory.matchExp((String)"folderName", (Object)fname);
            if (is_update) {
                exp = exp.andExp(ExpressionFactory.noMatchDbExp((String)"FOLDER_ID", (Object)this.folderId));
            }
            if ((list = query.setQualifier(exp.andExp(exp2 = ExpressionFactory.matchExp((String)"eipMMailAccount", (Object)this.mailAccount))).fetchList()) != null && list.size() > 0) {
                return true;
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTMailFolder folder = WebMailUtils.getEipTMailFolder(this.mailAccount, this.folderId);
            if (folder == null) {
                return false;
            }
            this.folder_name.setValue(folder.getFolderName());
        }
        catch (Exception ex) {
            logger.error((Object)"webmail", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            Expression exp;
            String folderId = ALEipUtils.getParameter((RunData)rundata, (Context)context, (String)"entityid");
            if (StringUtils.isEmpty((String)folderId) || this.mailAccount.getDefaultFolderId() == Integer.parseInt(folderId)) {
                return false;
            }
            EipTMailFolder folder = WebMailUtils.getEipTMailFolder(this.mailAccount, folderId);
            List folderMails = ALMailUtils.getEipTMails((EipTMailFolder)folder);
            SelectQuery query = Database.query(EipTMailFilter.class);
            List filters = query.setQualifier(exp = ExpressionFactory.matchDbExp((String)"eipTMailFolder", (Object)folder)).fetchList();
            if (filters != null && filters.size() != 0) {
                EipTMailFolder defaultFolder = WebMailUtils.getEipTMailFolder(this.mailAccount, this.mailAccount.getDefaultFolderId().toString());
                for (EipTMailFilter filter : filters) {
                    filter.setEipTMailFolder(defaultFolder);
                }
            }
            ArrayList<String> mailPaths = new ArrayList<String>();
            if (folderMails != null && folderMails.size() > 0) {
                for (EipTMail mail : folderMails) {
                    mailPaths.add(mail.getFilePath());
                }
            }
            String sql = "DELETE FROM eip_t_mail WHERE FOLDER_ID = #bind($folderId)";
            Database.sql(EipTMail.class, (String)sql).param("folderId", (Object)folder.getFolderId()).execute();
            Database.delete((Persistent)folder);
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(folder.getFolderId().intValue(), 232, folder.getFolderName());
            String currentTab = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"tab");
            int type_mail = "receive".equals(currentTab) ? 1 : 2;
            int userId = ALEipUtils.getUserId((RunData)rundata);
            String orgId = Database.getDomainName();
            int accountId = -1;
            accountId = Integer.parseInt(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"accountid"));
            ALMailHandler handler = ALMailFactoryService.getInstance().getMailHandler();
            ALFolder alFolder = handler.getALFolder(type_mail, orgId, userId, Integer.valueOf(accountId).intValue());
            if (mailPaths.size() > 0) {
                int size = mailPaths.size();
                for (int k = 0; k < size; ++k) {
                    ALStorageService.deleteFile((String)(alFolder.getFullName() + ALStorageService.separator() + (String)mailPaths.get(k)));
                }
            }
            return true;
        }
        catch (Throwable t) {
            Database.rollback();
            logger.error((Object)"[WebMailFolderFormData.deleteFormData]", t);
            return false;
        }
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTMailFolder folder = (EipTMailFolder)Database.create(EipTMailFolder.class);
            folder.setFolderName(this.folder_name.getValue());
            folder.setCreateDate(Calendar.getInstance().getTime());
            folder.setUpdateDate(Calendar.getInstance().getTime());
            folder.setEipMMailAccount(this.mailAccount);
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(folder.getFolderId().intValue(), 232, this.folder_name.getValue());
            return true;
        }
        catch (Throwable t) {
            Database.rollback();
            logger.error((Object)"[WebMailFolderFormData]", t);
            return false;
        }
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTMailFolder folder = WebMailUtils.getEipTMailFolder(this.mailAccount, this.folderId);
            if (folder == null) {
                return false;
            }
            folder.setFolderName(this.folder_name.getValue());
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(folder.getFolderId().intValue(), 232, this.folder_name.getValue());
            return true;
        }
        catch (Throwable t) {
            Database.rollback();
            logger.error((Object)"[WebMailFolderFormData]", t);
            return false;
        }
    }

    public EipMMailAccount getMailAccount() {
        return this.mailAccount;
    }

    public ALStringField getFolderName() {
        return this.folder_name;
    }

    public ALNumberField getAccessFlag() {
        return this.access_flag;
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }
}

