/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.commons.validator.routines;

import info.bliki.commons.validator.routines.DomainValidator;
import info.bliki.commons.validator.routines.InetAddressValidator;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EmailValidator
implements Serializable {
    private static final String SPECIAL_CHARS = "\\p{Cntrl}\\(\\)<>@,;:'\\\\\\\"\\.\\[\\]";
    private static final String VALID_CHARS = "[^\\s\\p{Cntrl}\\(\\)<>@,;:'\\\\\\\"\\.\\[\\]]";
    private static final String QUOTED_USER = "(\"[^\"]*\")";
    private static final String WORD = "(([^\\s\\p{Cntrl}\\(\\)<>@,;:'\\\\\\\"\\.\\[\\]]|')+|(\"[^\"]*\"))";
    private static final String LEGAL_ASCII_REGEX = "^\\p{ASCII}+$";
    private static final String EMAIL_REGEX = "^\\s*?(.+)@(.+?)\\s*$";
    private static final String IP_DOMAIN_REGEX = "^\\[(.*)\\]$";
    private static final String USER_REGEX = "^\\s*(([^\\s\\p{Cntrl}\\(\\)<>@,;:'\\\\\\\"\\.\\[\\]]|')+|(\"[^\"]*\"))(\\.(([^\\s\\p{Cntrl}\\(\\)<>@,;:'\\\\\\\"\\.\\[\\]]|')+|(\"[^\"]*\")))*$";
    private static final Pattern MATCH_ASCII_PATTERN = Pattern.compile("^\\p{ASCII}+$");
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^\\s*?(.+)@(.+?)\\s*$");
    private static final Pattern IP_DOMAIN_PATTERN = Pattern.compile("^\\[(.*)\\]$");
    private static final Pattern USER_PATTERN = Pattern.compile("^\\s*(([^\\s\\p{Cntrl}\\(\\)<>@,;:'\\\\\\\"\\.\\[\\]]|')+|(\"[^\"]*\"))(\\.(([^\\s\\p{Cntrl}\\(\\)<>@,;:'\\\\\\\"\\.\\[\\]]|')+|(\"[^\"]*\")))*$");
    private static final EmailValidator EMAIL_VALIDATOR = new EmailValidator();

    public static EmailValidator getInstance() {
        return EMAIL_VALIDATOR;
    }

    protected EmailValidator() {
    }

    public boolean isValid(String email) {
        if (email == null) {
            return false;
        }
        Matcher asciiMatcher = MATCH_ASCII_PATTERN.matcher(email);
        if (!asciiMatcher.matches()) {
            return false;
        }
        Matcher emailMatcher = EMAIL_PATTERN.matcher(email);
        if (!emailMatcher.matches()) {
            return false;
        }
        if (email.endsWith(".")) {
            return false;
        }
        if (!this.isValidUser(emailMatcher.group(1))) {
            return false;
        }
        return this.isValidDomain(emailMatcher.group(2));
    }

    protected boolean isValidDomain(String domain) {
        Matcher ipDomainMatcher = IP_DOMAIN_PATTERN.matcher(domain);
        if (ipDomainMatcher.matches()) {
            InetAddressValidator inetAddressValidator = InetAddressValidator.getInstance();
            return inetAddressValidator.isValid(ipDomainMatcher.group(1));
        }
        DomainValidator domainValidator = DomainValidator.getInstance();
        return domainValidator.isValid(domain);
    }

    protected boolean isValidUser(String user) {
        return USER_PATTERN.matcher(user).matches();
    }
}

