/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.template;

import info.bliki.htmlcleaner.Utils;
import info.bliki.wiki.filter.TemplateParser;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.template.AbstractTemplateFunction;
import info.bliki.wiki.template.ITemplateFunction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Safesubst
extends AbstractTemplateFunction {
    public static final ITemplateFunction CONST = new Safesubst();

    @Override
    public String parseFunction(List<String> parts1, IWikiModel model, char[] src, int beginIndex, int endIndex, boolean isSubst) {
        String function;
        String substArg = new String(src, beginIndex, endIndex - beginIndex);
        String substituted = Safesubst.parsePreprocess(substArg, model, null);
        char[] src2 = substituted.toCharArray();
        Object[] objs = TemplateParser.createParameterMap(src2, 0, src2.length);
        List parts = (List)objs[0];
        String templateName = (String)objs[1];
        int currOffset = TemplateParser.checkParserFunction(substituted);
        if (currOffset > 0 && (function = substituted.substring(0, currOffset - 1).trim()) != null) {
            ITemplateFunction templateFunction = model.getTemplateFunction(function);
            if (templateFunction != null) {
                parts.set(0, templateName.substring(currOffset));
                try {
                    String plainContent = templateFunction.parseFunction(parts, model, src2, currOffset, src2.length, true);
                    if (plainContent != null) {
                        return plainContent;
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            return "";
        }
        LinkedHashMap<String, String> parameterMap = new LinkedHashMap<String, String>();
        ArrayList<String> unnamedParameters = new ArrayList<String>();
        for (int i = 1; i < parts.size(); ++i) {
            if (i == parts.size() - 1) {
                TemplateParser.createSingleParameter((String)parts.get(i), parameterMap, unnamedParameters);
                continue;
            }
            TemplateParser.createSingleParameter((String)parts.get(i), parameterMap, unnamedParameters);
        }
        TemplateParser.mergeParameters(parameterMap, unnamedParameters);
        String plainContent = templateName.length() > 0 && templateName.charAt(0) == ':' ? model.getRawWikiContent("", templateName.substring(1), parameterMap) : model.getRawWikiContent(model.getTemplateNamespace(), templateName, parameterMap);
        if (plainContent != null) {
            return Safesubst.parsePreprocess(plainContent, model, parameterMap);
        }
        return "";
    }

    public static String parsePreprocess(String content, IWikiModel model, Map<String, String> templateParameterMap) {
        if (content == null || content.length() == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder(content.length());
        try {
            TemplateParser.parsePreprocessRecursive(content, model, buf, false, false, false, templateParameterMap);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Utils.trimNewlineLeft(buf.toString());
    }
}

