/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.workflow;

import com.aimluck.commons.utils.ALDateUtil;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowCategory;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import com.aimluck.eip.workflow.WorkflowCategoryDetailResultData;
import com.aimluck.eip.workflow.WorkflowCategoryResultData;
import com.aimluck.eip.workflow.WorkflowRouteResultData;
import com.aimluck.eip.workflow.util.WorkflowUtils;
import java.util.Date;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class WorkflowCategorySelectData
extends ALAbstractSelectData<EipTWorkflowCategory, EipTWorkflowCategory>
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WorkflowCategorySelectData.class.getName());
    private int categorySum;
    private List<WorkflowRouteResultData> routeList;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        String sorttype = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_TYPE_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p2a-sort"));
        }
        if ("create_date".equals(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR)) && (sorttype == null || "".equals(sorttype))) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_TYPE_STR, (String)"desc");
        }
        super.init(action, rundata, context);
    }

    protected ResultList<EipTWorkflowCategory> selectList(RunData rundata, Context context) {
        try {
            SelectQuery<EipTWorkflowCategory> query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            ResultList list = query.getResultList();
            this.categorySum = list.getTotalCount();
            return list;
        }
        catch (Exception ex) {
            logger.error((Object)"workflow", (Throwable)ex);
            return null;
        }
    }

    private SelectQuery<EipTWorkflowCategory> getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = Database.query(EipTWorkflowCategory.class);
        return query;
    }

    protected EipTWorkflowCategory selectDetail(RunData rundata, Context context) {
        return WorkflowUtils.getEipTWorkflowCategory(rundata, context);
    }

    protected Object getResultData(EipTWorkflowCategory record) {
        WorkflowCategoryResultData rd = new WorkflowCategoryResultData();
        rd.initField();
        rd.setCategoryId(record.getCategoryId().longValue());
        rd.setCategoryName(ALCommonUtils.compressString((String)record.getCategoryName(), (int)this.getStrLength()));
        if (record.getEipTWorkflowRoute() != null) {
            rd.setRoute(record.getEipTWorkflowRoute().getRoute());
            rd.setRouteName(record.getEipTWorkflowRoute().getRouteName());
        }
        return rd;
    }

    protected Object getResultDataDetail(EipTWorkflowCategory record) {
        WorkflowCategoryDetailResultData rd = new WorkflowCategoryDetailResultData();
        rd.initField();
        rd.setCategoryId(record.getCategoryId().longValue());
        rd.setCategoryName(record.getCategoryName());
        rd.setNote(record.getNote());
        rd.setTemplate(record.getTemplate());
        rd.setCreateDate(ALDateUtil.format((Date)record.getCreateDate(), (String)ALLocalizationUtils.getl10n((String)"WORKFLOW_YEAR_MONTH_DAY")));
        rd.setUpdateDate(ALDateUtil.format((Date)record.getUpdateDate(), (String)ALLocalizationUtils.getl10n((String)"WORKFLOW_YEAR_MONTH_DAY")));
        if (record.getEipTWorkflowRoute() != null) {
            rd.setRoute(record.getEipTWorkflowRoute().getRoute());
            rd.setRouteName(record.getEipTWorkflowRoute().getRouteName());
        }
        return rd;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("category_name", "categoryName");
        map.putValue("route_name", "eipTWorkflowRoute");
        return map;
    }

    public int getCategorySum() {
        return this.categorySum;
    }

    public String getViewtype() {
        return "category";
    }

    public void loadRouteList(RunData rundata, Context context) {
        this.routeList = WorkflowUtils.loadRouteList(rundata, context);
    }

    public List<WorkflowRouteResultData> getRouteList() {
        return this.routeList;
    }
}

