/*
 * Decompiled with CFR 0.152.
 */
package com.develop.jcfe.attribute;

import com.develop.jcfe.attribute.Attribute;
import com.develop.jcfe.cpool.ConstantPool;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class AttributeSet {
    private final ConstantPool cpool;
    private final ArrayList atts = new ArrayList();

    public AttributeSet(ConstantPool cpool) {
        if (cpool == null) {
            throw new IllegalStateException("Cpool cannot be null");
        }
        this.cpool = cpool;
    }

    public int size() {
        return this.atts.size();
    }

    public void add(Attribute att) {
        if (att.getNameIndex() != -1) {
            short addedIdx;
            short idx = att.getNameIndex();
            if (idx != (addedIdx = this.cpool.addUtf8(att.getName()))) {
                throw new IllegalStateException("Invalid cpool idx " + idx + " " + att.getName() + " added again as " + addedIdx);
            }
        } else {
            att.setNameIndex(this.cpool.addUtf8(att.getName()));
        }
        this.atts.add(att);
    }

    public Attribute get(int index) {
        return (Attribute)this.atts.get(index);
    }

    public Attribute[] getAttributes() {
        Attribute[] ret = new Attribute[this.size()];
        return this.atts.toArray(ret);
    }

    public Attribute getAttribute(String name) {
        Iterator it = ((AbstractList)this.atts).iterator();
        while (it.hasNext()) {
            Attribute att = (Attribute)it.next();
            if (!att.getName().equals(name)) continue;
            return att;
        }
        return null;
    }

    public Iterator iterator() {
        return ((AbstractList)this.atts).iterator();
    }
}

