/*
 * Decompiled with CFR 0.152.
 */
package com.develop.jcfe.cpool;

import com.develop.jcfe.JavaType;
import com.develop.jcfe.cpool.CONSTANT_Class_info;
import com.develop.jcfe.cpool.CONSTANT_Fieldref_info;
import com.develop.jcfe.cpool.CONSTANT_InterfaceMethodRef_info;
import com.develop.jcfe.cpool.CONSTANT_Methodref_info;
import com.develop.jcfe.cpool.CONSTANT_NameAndType;
import com.develop.jcfe.cpool.CONSTANT_String_info;
import com.develop.jcfe.cpool.CONSTANT_Utf8_info;
import com.develop.jcfe.cpool.PoolEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConstantPool {
    private List pool = new ArrayList();
    private Map typeToPositions = new HashMap();

    public ConstantPool() {
        this.pool.add(null);
    }

    public int size() {
        return this.pool.size();
    }

    public short addConstant(PoolEntry info) {
        Short preExisting;
        if (info == null) {
            return 0;
        }
        HashMap<PoolEntry, Short> entryToIdx = (HashMap<PoolEntry, Short>)this.typeToPositions.get(info.getClass());
        if (entryToIdx == null) {
            entryToIdx = new HashMap<PoolEntry, Short>();
            this.typeToPositions.put(info.getClass(), entryToIdx);
        }
        if ((preExisting = (Short)entryToIdx.get(info)) != null) {
            return preExisting;
        }
        short sResult = (short)this.pool.size();
        this.pool.add(info);
        if (info != null && info.isEightByteType()) {
            this.pool.add(null);
        }
        entryToIdx.put(info, new Short(sResult));
        return sResult;
    }

    public short addClass(JavaType jt) {
        short nameIndex = this.addUtf8(jt.getClassfileInternalForm());
        short classIndex = this.addConstant(new CONSTANT_Class_info(nameIndex));
        return classIndex;
    }

    public short addNameAndType(String name, String desc) {
        short sNameIndex = this.addUtf8(name);
        short sDesc = this.addUtf8(desc);
        short sIndex = this.addConstant(new CONSTANT_NameAndType(sNameIndex, sDesc));
        return sIndex;
    }

    public short addMethodref(JavaType jt, String memberName, String desc) {
        String className = jt.getClassfileInternalForm();
        short sNameAndTypeIndex = this.addNameAndType(memberName, desc);
        short sClassIndex = this.addClass(jt);
        short sIndex = this.addConstant(new CONSTANT_Methodref_info(sClassIndex, sNameAndTypeIndex));
        return sIndex;
    }

    public short addFieldref(String className, String memberName, String desc) {
        return this.addFieldref(new JavaType(className), memberName, desc);
    }

    public short addFieldref(JavaType jt, String memberName, String desc) {
        String className = jt.getClassfileInternalForm();
        short sNameAndTypeIndex = this.addNameAndType(memberName, desc);
        short sClassIndex = this.addClass(jt);
        short sIndex = this.addConstant(new CONSTANT_Fieldref_info(sClassIndex, sNameAndTypeIndex));
        return sIndex;
    }

    public short addInterfaceMethodref(JavaType jt, String memberName, String desc) {
        String className = jt.getClassfileInternalForm();
        short sNameAndTypeIndex = this.addNameAndType(memberName, desc);
        short sClassIndex = this.addClass(jt);
        short sIndex = this.addConstant(new CONSTANT_InterfaceMethodRef_info(sClassIndex, sNameAndTypeIndex));
        return sIndex;
    }

    public CONSTANT_InterfaceMethodRef_info getInterfaceMethodRef(short s) {
        return (CONSTANT_InterfaceMethodRef_info)this.pool.get(s);
    }

    public short addUtf8(String name) {
        short sIndex = this.addConstant(new CONSTANT_Utf8_info(name));
        return sIndex;
    }

    public short addString(String name) {
        short utf8Index = this.addUtf8(name);
        short index = this.addConstant(new CONSTANT_String_info(utf8Index));
        return index;
    }

    public short getFieldSize(short s) {
        CONSTANT_Fieldref_info fri = this.getFieldref(s);
        CONSTANT_NameAndType nti = this.getNameAndType(fri.getNameAndTypeIndex());
        String desc = this.getUtf8String(nti.descriptor_index);
        return JavaType.getSize(desc);
    }

    public PoolEntry getConstant(int n) {
        return (PoolEntry)this.pool.get(n);
    }

    public String getUtf8String(short sIndex) {
        CONSTANT_Utf8_info ci = this.getUtf8(sIndex);
        return ci.utf;
    }

    public CONSTANT_Class_info getClass(short poolOffset) {
        return (CONSTANT_Class_info)this.pool.get(poolOffset);
    }

    public CONSTANT_Fieldref_info getFieldref(short poolOffset) {
        return (CONSTANT_Fieldref_info)this.pool.get(poolOffset);
    }

    public CONSTANT_NameAndType getNameAndType(short poolOffset) {
        return (CONSTANT_NameAndType)this.pool.get(poolOffset);
    }

    public CONSTANT_Utf8_info getUtf8(short poolOffset) {
        return (CONSTANT_Utf8_info)this.pool.get(poolOffset);
    }

    public String getClassString(short offset) throws IllegalArgumentException {
        CONSTANT_Class_info ci = (CONSTANT_Class_info)this.pool.get(offset);
        if (ci == null) {
            throw new IllegalArgumentException("No class info at constant pool offset " + offset);
        }
        return this.getUtf8String(ci.name_index);
    }
}

