/*
 * Decompiled with CFR 0.152.
 */
package com.develop.jcfe.cpool;

import com.develop.jcfe.ClassFile;
import com.develop.jcfe.ClassfileConstants;
import com.develop.jcfe.cpool.CONSTANT_Class_info;
import com.develop.jcfe.cpool.CONSTANT_Double_info;
import com.develop.jcfe.cpool.CONSTANT_Fieldref_info;
import com.develop.jcfe.cpool.CONSTANT_Float_info;
import com.develop.jcfe.cpool.CONSTANT_Integer_info;
import com.develop.jcfe.cpool.CONSTANT_InterfaceMethodRef_info;
import com.develop.jcfe.cpool.CONSTANT_Long_info;
import com.develop.jcfe.cpool.CONSTANT_Methodref_info;
import com.develop.jcfe.cpool.CONSTANT_NameAndType;
import com.develop.jcfe.cpool.CONSTANT_String_info;
import com.develop.jcfe.cpool.CONSTANT_Utf8_info;
import com.develop.jcfe.cpool.ConstantPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class PoolEntry
implements ClassfileConstants {
    private short poolOffset = (short)-1;

    public abstract int getType();

    public abstract void writeToStream(DataOutputStream var1) throws IOException;

    public short getPoolOffset() {
        return this.poolOffset;
    }

    PoolEntry() {
    }

    public boolean isEightByteType() {
        return this.getType() == 6 || this.getType() == 5;
    }

    PoolEntry(short poolOffset) {
        this.poolOffset = poolOffset;
    }

    String getTypeName() {
        switch (this.getType()) {
            case 7: {
                return "CONSTANT_Class";
            }
            case 9: {
                return "CONSTANT_Fieldref";
            }
            case 10: {
                return "CONSTANT_Methodref";
            }
            case 11: {
                return "CONSTANT_InterfaceMethodRef";
            }
            case 8: {
                return "CONSTANT_String";
            }
            case 3: {
                return "CONSTANT_Integer";
            }
            case 4: {
                return "CONSTANT_Float";
            }
            case 5: {
                return "CONSTANT_Long";
            }
            case 6: {
                return "CONSTANT_Double";
            }
            case 12: {
                return "CONSTANT_NameAndType";
            }
            case 1: {
                return "CONSTANT_Utf8";
            }
        }
        return "Unknown Type";
    }

    void completeString(ConstantPool cp, StringBuffer sb) {
    }

    public String toString(ClassFile cf) {
        StringBuffer sb = new StringBuffer(this.getTypeName());
        sb.append(": ");
        this.completeString(cf.getConstantPool(), sb);
        return sb.toString();
    }

    public static PoolEntry readCPInfo(DataInputStream dis, short poolOffset) throws IOException {
        byte tag = dis.readByte();
        switch (tag) {
            case 1: {
                return new CONSTANT_Utf8_info(dis, poolOffset);
            }
            case 7: {
                return new CONSTANT_Class_info(dis, poolOffset);
            }
            case 8: {
                return new CONSTANT_String_info(dis, poolOffset);
            }
            case 9: {
                return new CONSTANT_Fieldref_info(dis, poolOffset);
            }
            case 10: {
                return new CONSTANT_Methodref_info(dis, poolOffset);
            }
            case 12: {
                return new CONSTANT_NameAndType(dis, poolOffset);
            }
            case 11: {
                return new CONSTANT_InterfaceMethodRef_info(dis, poolOffset);
            }
            case 4: {
                return new CONSTANT_Float_info(dis, poolOffset);
            }
            case 3: {
                return new CONSTANT_Integer_info(dis, poolOffset);
            }
            case 5: {
                return new CONSTANT_Long_info(dis, poolOffset);
            }
            case 6: {
                return new CONSTANT_Double_info(dis, poolOffset);
            }
        }
        throw new ClassFormatError("Cannot interpret class pool type " + tag);
    }
}

