/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.metadata;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.sql.Timestamp;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.PersistenceBrokerFactory;
import ojb.broker.accesslayer.ConversionStrategy;
import ojb.broker.accesslayer.ConversionStrategyDefaultImpl;
import ojb.broker.accesslayer.RowReader;
import ojb.broker.accesslayer.RowReaderDefaultImpl;
import ojb.broker.metadata.CollectionDescriptor;
import ojb.broker.metadata.DescriptorRepository;
import ojb.broker.metadata.FieldDescriptor;
import ojb.broker.metadata.JdbcConnectionDescriptor;
import ojb.broker.metadata.ObjectReferenceDescriptor;
import ojb.broker.metadata.PersistentField;
import ojb.broker.util.LoggerFactory;

public class ClassDescriptor
implements Serializable {
    private transient DescriptorRepository m_repository;
    private int m_IsolationLevel = 0;
    private String schema = null;
    private Class m_Class = null;
    private String m_TableName = null;
    private FieldDescriptor[] m_FieldDescriptions = null;
    private Vector m_CollectionDescriptors = new Vector();
    private Vector m_ObjectReferenceDescriptors = new Vector();
    private JdbcConnectionDescriptor m_ConnDescription = null;
    private boolean alreadyLookedup = false;
    private Class[] argsForConstructor = null;
    private Vector extentClasses = new Vector();
    private boolean isInterface = false;
    private transient Constructor multiArgumentConstructor = null;
    private String orderby = null;
    private Class proxyClass = null;
    private FieldDescriptor[] nonPrimaryKeyFieldDescriptors = null;
    private FieldDescriptor[] primaryKeyFieldDescriptors = null;
    private FieldDescriptor[] lockingFieldDescriptors = null;
    private transient ConversionStrategy conversionStrategy = null;
    private transient RowReader rowReader = null;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$lang$String;

    public void setConversionStrategy(ConversionStrategy newStrategy) {
        this.conversionStrategy = newStrategy;
    }

    public ConversionStrategy getConversionStrategy() {
        if (this.conversionStrategy == null) {
            this.conversionStrategy = new ConversionStrategyDefaultImpl();
        }
        return this.conversionStrategy;
    }

    public void setRowReader(RowReader newReader) {
        this.rowReader = newReader;
    }

    public RowReader getRowReader() {
        if (this.rowReader == null) {
            this.rowReader = new RowReaderDefaultImpl();
        }
        return this.rowReader;
    }

    private String getTableName() {
        return this.m_TableName;
    }

    public String getFullTableName() {
        if (this.getSchema() != null) {
            return this.getSchema() + "." + this.getTableName();
        }
        return this.getTableName();
    }

    public void setTableName(String str) {
        this.m_TableName = str;
    }

    public Class getClassOfObject() {
        return this.m_Class;
    }

    public void setClassOfObject(Class c) {
        this.m_Class = c;
    }

    public void addFieldDescriptor(FieldDescriptor fld) {
        fld.setClassDescriptor(this);
        if (this.m_FieldDescriptions == null) {
            this.m_FieldDescriptions = new FieldDescriptor[1];
            this.m_FieldDescriptions[0] = fld;
        } else {
            int size = this.m_FieldDescriptions.length;
            FieldDescriptor[] tmpArray = new FieldDescriptor[size + 1];
            System.arraycopy(this.m_FieldDescriptions, 0, tmpArray, 0, size);
            tmpArray[size] = fld;
            this.m_FieldDescriptions = tmpArray;
            Arrays.sort(this.m_FieldDescriptions, FieldDescriptor.getComparator());
        }
    }

    public Vector getCollectionDescriptors() {
        return this.m_CollectionDescriptors;
    }

    public void addCollectionDescriptor(CollectionDescriptor cod) {
        this.m_CollectionDescriptors.add(cod);
    }

    public Vector getObjectReferenceDescriptors() {
        return this.m_ObjectReferenceDescriptors;
    }

    public void addObjectReferenceDescriptor(ObjectReferenceDescriptor ord) {
        this.m_ObjectReferenceDescriptors.add(ord);
    }

    public JdbcConnectionDescriptor getConnectionDescriptor() {
        if (this.m_ConnDescription == null) {
            this.m_ConnDescription = DescriptorRepository.getInstance().getDefaultJdbcConnection();
        }
        return this.m_ConnDescription;
    }

    public void setConnectionDescriptor(JdbcConnectionDescriptor jcd) {
        this.m_ConnDescription = jcd;
    }

    public FieldDescriptor getFieldDescriptorByIndex(int index) {
        return this.m_FieldDescriptions[index - 1];
    }

    public ObjectReferenceDescriptor getORDescriptorByClass(Class c) {
        Iterator i = ((AbstractList)this.m_ObjectReferenceDescriptors).iterator();
        while (i.hasNext()) {
            ObjectReferenceDescriptor ord = (ObjectReferenceDescriptor)i.next();
            if (ord.getItemClass() != c) continue;
            return ord;
        }
        return null;
    }

    public String toString() {
        return "table:      \t" + this.m_TableName + "\n" + "FieldDescriptions:\t" + this.m_FieldDescriptions.toString();
    }

    public FieldDescriptor getFieldDescriptorByName(String name) {
        int i = 0;
        while (i < this.m_FieldDescriptions.length) {
            FieldDescriptor fmd = this.m_FieldDescriptions[i];
            if (fmd.getPersistentField().getName().equals(name)) {
                return fmd;
            }
            ++i;
        }
        return null;
    }

    public ObjectReferenceDescriptor getObjectReferenceDescriptorByName(String name) {
        Vector descr = this.getObjectReferenceDescriptors();
        int size = descr.size();
        ObjectReferenceDescriptor result = null;
        int i = 0;
        while (i < size) {
            ObjectReferenceDescriptor ord = (ObjectReferenceDescriptor)descr.elementAt(i);
            if (ord.getPersistentField().getName().equals(name)) {
                result = ord;
                break;
            }
            ++i;
        }
        return result;
    }

    public CollectionDescriptor getCollectionDescriptorByName(String name) {
        Vector descr = this.getCollectionDescriptors();
        int size = descr.size();
        CollectionDescriptor result = null;
        int i = 0;
        while (i < size) {
            CollectionDescriptor ord = (CollectionDescriptor)descr.elementAt(i);
            if (ord.getPersistentField().getName().equals(name)) {
                result = ord;
                break;
            }
            ++i;
        }
        return result;
    }

    public int getIsolationLevel() {
        return this.m_IsolationLevel;
    }

    public void setIsolationLevel(int isoLevel) {
        this.m_IsolationLevel = isoLevel;
    }

    public void addExtentClass(Class newExtendClass) {
        this.extentClasses.add(newExtendClass);
    }

    /*
     * Unable to fully structure code
     */
    public Constructor getConstructor() {
        if (this.multiArgumentConstructor == null && !this.alreadyLookedup) {
            block6: {
                if (this.argsForConstructor == null) {
                    this.argsForConstructor = new Class[this.getFieldDescriptions().length];
                    i = 0;
                    while (i < this.getFieldDescriptions().length) {
                        this.argsForConstructor[i] = this.getFieldDescriptions()[i].getPersistentField().getType();
                        ++i;
                    }
                }
                try {
                    this.multiArgumentConstructor = this.m_Class.getConstructor(this.argsForConstructor);
                    break block6;
                }
                catch (Exception ignored) {
                    args = "";
                    i = 0;
                    ** while (i < this.argsForConstructor.length)
                }
lbl-1000:
                // 1 sources

                {
                    args = args + (args.length() == 0 ? "(" : ", ");
                    args = args + this.argsForConstructor[i].getName();
                    ++i;
                    continue;
                }
lbl20:
                // 1 sources

                args = args + ")";
                LoggerFactory.getDefaultLogger().warn("Please define a public constructor for " + this.getClassOfObject() + "\nwith the following signature: " + args + ".\nIt must initialize the classes persistent attributes. This is recommended to increase performance but it's not mandatory!");
            }
            this.alreadyLookedup = true;
        }
        return this.multiArgumentConstructor;
    }

    public Vector getExtentClasses() {
        return this.extentClasses;
    }

    public String getOrderby() {
        return this.orderby;
    }

    public Class getProxyClass() {
        return this.proxyClass;
    }

    public boolean isExtent() {
        return this.extentClasses.size() > 0;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public void setIsInterface(boolean newIsInterface) {
        this.isInterface = newIsInterface;
    }

    public void setOrderby(String newOrderby) {
        this.orderby = newOrderby;
    }

    public void setProxyClass(Class newProxyClass) {
        this.proxyClass = newProxyClass;
    }

    public Object[] getAllValues(Object obj) throws PersistenceBrokerException {
        FieldDescriptor[] allFields = this.getFieldDescriptions();
        Object[] result = new Object[allFields.length];
        int i = 0;
        while (i < allFields.length) {
            FieldDescriptor fmd = allFields[i];
            PersistentField f = fmd.getPersistentField();
            Object cv = null;
            try {
                cv = f.get(obj);
                cv = this.getConversionStrategy().javaToSql(cv, fmd);
            }
            catch (Throwable t) {
                LoggerFactory.getDefaultLogger().error(t);
                throw new PersistenceBrokerException(t);
            }
            result[i] = cv;
            ++i;
        }
        return result;
    }

    public FieldDescriptor[] getFieldDescriptions() {
        return this.m_FieldDescriptions;
    }

    public Object[] getKeyValues(Object o) throws PersistenceBrokerException {
        FieldDescriptor[] pkFields = this.getPkFields();
        Object[] result = new Object[pkFields.length];
        int i = 0;
        while (i < result.length) {
            FieldDescriptor fmd = pkFields[i];
            PersistentField f = fmd.getPersistentField();
            Object cv = null;
            try {
                cv = f.get(o);
                if (fmd.isAutoIncrement()) {
                    cv = this.getAutoIncrementValue(fmd, o, cv);
                }
            }
            catch (Throwable t) {
                LoggerFactory.getDefaultLogger().error(t);
                throw new PersistenceBrokerException(t);
            }
            result[i] = cv;
            ++i;
        }
        return result;
    }

    public Object[] getCurrentLockingValues(Object o) throws PersistenceBrokerException {
        FieldDescriptor[] fields = this.getLockingFields();
        Object[] result = new Object[fields.length];
        int i = 0;
        while (i < result.length) {
            FieldDescriptor fmd = fields[i];
            PersistentField f = fmd.getPersistentField();
            Object cv = null;
            try {
                cv = f.get(o);
            }
            catch (Throwable t) {
                LoggerFactory.getDefaultLogger().error(t);
                throw new PersistenceBrokerException(t);
            }
            result[i] = cv;
            ++i;
        }
        return result;
    }

    public void updateLockingValues(Object obj) throws PersistenceBrokerException {
        FieldDescriptor[] fields = this.getLockingFields();
        int i = 0;
        while (i < fields.length) {
            FieldDescriptor fmd = fields[i];
            PersistentField f = fmd.getPersistentField();
            Object cv = null;
            try {
                cv = f.get(obj);
                if (f.getType() == Integer.TYPE || f.getType() == (class$java$lang$Integer == null ? ClassDescriptor.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    int newCv = 0;
                    if (cv != null) {
                        newCv = ((Number)cv).intValue();
                    }
                    f.set(obj, new Integer(++newCv));
                } else if (f.getType() == Long.TYPE || f.getType() == (class$java$lang$Long == null ? ClassDescriptor.class$("java.lang.Long") : class$java$lang$Long)) {
                    long newCv = 0L;
                    if (cv != null) {
                        newCv = ((Number)cv).longValue();
                    }
                    f.set(obj, new Long(++newCv));
                } else if (f.getType() == (class$java$sql$Timestamp == null ? ClassDescriptor.class$("java.sql.Timestamp") : class$java$sql$Timestamp)) {
                    long newCv = new Date().getTime();
                    f.set(obj, new Timestamp(newCv));
                }
            }
            catch (Throwable t) {
                LoggerFactory.getDefaultLogger().error(t);
                throw new PersistenceBrokerException(t);
            }
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object getAutoIncrementValue(FieldDescriptor fmd, Object obj, Object cv) {
        PersistentField f = fmd.getPersistentField();
        Object result = cv;
        PersistenceBroker broker = PersistenceBrokerFactory.createPersistenceBroker();
        try {
            if (f.getType() == Integer.TYPE || f.getType() == (class$java$lang$Integer == null ? (class$java$lang$Integer = ClassDescriptor.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                if (f.get(obj) != null && ((Number)f.get(obj)).intValue() != 0) return result;
                Class extent = broker.getExtentClass(this.getClassOfObject());
                result = new Integer(broker.getUniqueId(extent, f.getName()));
                f.set(obj, result);
                return result;
            } else if (f.getType() == Long.TYPE || f.getType() == (class$java$lang$Long == null ? (class$java$lang$Long = ClassDescriptor.class$("java.lang.Long")) : class$java$lang$Long)) {
                if (f.get(obj) != null && ((Number)f.get(obj)).longValue() != 0L) return result;
                Class extent = broker.getExtentClass(this.getClassOfObject());
                result = new Long(broker.getUniqueLong(extent, f.getName()));
                f.set(obj, result);
                return result;
            } else if ((class$java$lang$String == null ? (class$java$lang$String = ClassDescriptor.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(f.getType())) {
                if (f.get(obj) != null) return result;
                result = broker.getUniqueString(this.getClassOfObject(), f.getName());
                f.set(obj, result);
                return result;
            } else {
                if (f.getType().isPrimitive() || f.get(obj) != null) throw new RuntimeException("OJB ERROR: Dont know how to autoincrement field " + f.getDeclaringClass() + "." + f.getName());
                result = broker.getUniqueObject(this.getClassOfObject(), f.getName());
                if (result == null) throw new RuntimeException("OJB ERROR: Dont know how to autoincrement field " + f.getDeclaringClass() + "." + f.getName());
                f.set(obj, result);
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("OJB ERROR: Dont know how to autoincrement field " + f.getDeclaringClass() + "." + f.getName());
        }
    }

    public Object[] getNonKeyValues(Object o) throws PersistenceBrokerException {
        FieldDescriptor[] nonPkFields = this.getNonPkFields();
        Object[] result = new Object[nonPkFields.length];
        int i = 0;
        while (i < result.length) {
            FieldDescriptor fmd = nonPkFields[i];
            PersistentField f = fmd.getPersistentField();
            Object cv = null;
            try {
                cv = f.get(o);
                if (fmd.isAutoIncrement()) {
                    cv = this.getAutoIncrementValue(fmd, o, cv);
                }
                cv = this.getConversionStrategy().javaToSql(cv, fmd);
            }
            catch (Throwable t) {
                LoggerFactory.getDefaultLogger().error(t);
                throw new PersistenceBrokerException(t);
            }
            result[i] = cv;
            ++i;
        }
        return result;
    }

    public FieldDescriptor[] getNonPkFields() {
        if (this.nonPrimaryKeyFieldDescriptors == null) {
            Vector<FieldDescriptor> vec = new Vector<FieldDescriptor>();
            int i = 0;
            while (i < this.m_FieldDescriptions.length) {
                FieldDescriptor fmd = this.m_FieldDescriptions[i];
                if (!fmd.isPrimaryKey()) {
                    vec.add(fmd);
                }
                ++i;
            }
            Collections.sort(vec, FieldDescriptor.getComparator());
            this.nonPrimaryKeyFieldDescriptors = vec.toArray(new FieldDescriptor[vec.size()]);
        }
        return this.nonPrimaryKeyFieldDescriptors;
    }

    public FieldDescriptor[] getPkFields() {
        if (this.primaryKeyFieldDescriptors == null) {
            Vector<FieldDescriptor> vec = new Vector<FieldDescriptor>();
            int i = 0;
            while (i < this.m_FieldDescriptions.length) {
                FieldDescriptor fmd = this.m_FieldDescriptions[i];
                if (fmd.isPrimaryKey()) {
                    vec.add(fmd);
                }
                ++i;
            }
            Collections.sort(vec, FieldDescriptor.getComparator());
            this.primaryKeyFieldDescriptors = vec.toArray(new FieldDescriptor[vec.size()]);
        }
        return this.primaryKeyFieldDescriptors;
    }

    public FieldDescriptor[] getLockingFields() {
        if (this.lockingFieldDescriptors == null) {
            Vector<FieldDescriptor> vec = new Vector<FieldDescriptor>();
            int i = 0;
            while (i < this.m_FieldDescriptions.length) {
                FieldDescriptor fmd = this.m_FieldDescriptions[i];
                if (fmd.isLocking()) {
                    vec.add(fmd);
                }
                ++i;
            }
            Collections.sort(vec, FieldDescriptor.getComparator());
            this.lockingFieldDescriptors = vec.toArray(new FieldDescriptor[vec.size()]);
        }
        return this.lockingFieldDescriptors;
    }

    public boolean isLocking() {
        return this.getLockingFields().length > 0;
    }

    public DescriptorRepository getRepository() {
        return this.m_repository;
    }

    public void setRepository(DescriptorRepository repository) {
        this.m_repository = repository;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

