/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.util;

import ojb.broker.PersistenceBrokerFactory;
import ojb.broker.util.Logger;
import ojb.broker.util.PersistenceBrokerFactoryConfiguration;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;

public class Log4jLoggerImpl
implements Logger {
    private transient Category cat;
    private static boolean log4jconfigured = false;
    private String name;

    public Log4jLoggerImpl(String name) {
        this.name = name;
        if (!log4jconfigured) {
            if (!Category.getRoot().getAllAppenders().hasMoreElements()) {
                String configFile = PersistenceBrokerFactory.getConfiguration().getLoggerConfigFile();
                if (configFile != "") {
                    PropertyConfigurator.configure(configFile);
                } else {
                    BasicConfigurator.configure();
                }
            }
            log4jconfigured = true;
        }
        this.cat = Category.getInstance(name);
        Log4jLoggerImpl.setLevel(this.cat, name);
    }

    public final void debug(Object pObject) {
        this.getCat().debug(pObject);
    }

    public final void info(Object pObject) {
        this.getCat().info(pObject);
    }

    public final void warn(Object pObject) {
        this.getCat().warn(pObject);
    }

    public final void error(Object pObject) {
        this.getCat().error(pObject);
    }

    public final void fatal(Object pObject) {
        this.getCat().fatal(pObject);
    }

    private static void setLevel(Category cat, String name) {
        PersistenceBrokerFactoryConfiguration config = PersistenceBrokerFactory.getConfiguration();
        if (config != null) {
            String level = config.getLogLevel(name);
            if (level.equalsIgnoreCase("DEBUG")) {
                cat.setPriority(Priority.DEBUG);
            } else if (level.equalsIgnoreCase("INFO")) {
                cat.setPriority(Priority.INFO);
            } else if (level.equalsIgnoreCase("WARN")) {
                cat.setPriority(Priority.WARN);
            } else if (level.equalsIgnoreCase("ERROR")) {
                cat.setPriority(Priority.ERROR);
            } else if (level.equalsIgnoreCase("FATAL")) {
                cat.setPriority(Priority.FATAL);
            }
        }
    }

    private Category getCat() {
        if (this.cat == null) {
            this.cat = Category.getInstance(this.name);
            Log4jLoggerImpl.setLevel(this.cat, this.name);
        }
        return this.cat;
    }
}

