/*
 * Decompiled with CFR 0.152.
 */
package ojb.odmg;

import ojb.broker.Identity;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.PersistenceBrokerFactory;
import ojb.broker.metadata.ClassDescriptor;
import ojb.broker.util.Logger;
import ojb.broker.util.LoggerFactory;
import ojb.odmg.DatabaseImpl;
import ojb.odmg.TransactionImpl;
import ojb.odmg.TransactionTable;
import ojb.odmg.collections.DBagImpl;
import ojb.odmg.collections.DListImpl;
import ojb.odmg.collections.DMapImpl;
import ojb.odmg.collections.DSetImpl;
import ojb.odmg.oql.OQLQueryImpl;
import org.odmg.DArray;
import org.odmg.DBag;
import org.odmg.DList;
import org.odmg.DMap;
import org.odmg.DSet;
import org.odmg.Database;
import org.odmg.Implementation;
import org.odmg.ODMGRuntimeException;
import org.odmg.OQLQuery;
import org.odmg.Transaction;

public final class OJB
implements Implementation {
    private static OJB _instance;
    private DatabaseImpl currentDatabase = null;
    private static Logger logger;
    private TransactionTable tx_table = new TransactionTable();

    private OJB() {
    }

    public Transaction newTransaction() {
        TransactionImpl tx = new TransactionImpl(this.tx_table, this.currentDatabase);
        this.tx_table.put(Thread.currentThread(), tx);
        return tx;
    }

    public Transaction currentTransaction() {
        return this.tx_table.get(Thread.currentThread());
    }

    public Database newDatabase() {
        this.currentDatabase = new DatabaseImpl();
        return this.currentDatabase;
    }

    public OQLQuery newOQLQuery() {
        return new OQLQueryImpl();
    }

    public DList newDList() {
        return new DListImpl();
    }

    public DBag newDBag() {
        return new DBagImpl();
    }

    public DSet newDSet() {
        return new DSetImpl();
    }

    public DArray newDArray() {
        return new DListImpl();
    }

    public DMap newDMap() {
        return new DMapImpl();
    }

    public String getObjectId(Object obj) {
        Identity oid = new Identity(obj);
        return new String(oid.serialize());
    }

    public Database getDatabase(Object obj) {
        if (obj == null) {
            return this.currentDatabase;
        }
        PersistenceBroker broker = PersistenceBrokerFactory.createPersistenceBroker();
        try {
            ClassDescriptor cld = broker.getClassDescriptor(obj.getClass());
            PersistenceBrokerFactory.releaseInstance(broker);
            return this.currentDatabase;
        }
        catch (PersistenceBrokerException ex) {
            PersistenceBrokerFactory.releaseInstance(broker);
            throw new ODMGRuntimeException(ex.getMessage());
        }
    }

    public static synchronized OJB getInstance() {
        if (_instance == null) {
            _instance = new OJB();
        }
        return _instance;
    }

    public static Logger getLogger() {
        if (logger == null) {
            logger = LoggerFactory.getLogger("ODMG");
        }
        return logger;
    }

    void setCurrentDatabase(DatabaseImpl curDB) {
        this.currentDatabase = curDB;
    }

    static {
        logger = null;
    }
}

