/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.pool;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.pool.ConnectionWaitTimeoutException;

class ConnectionPool
implements ConnectionEventListener {
    public static final int DEFAULT_MAX_CONNECTIONS = 1;
    public static final int DEFAULT_EXPIRY_TIME = 3600000;
    public static final int DEFAULT_CONNECTION_WAIT_TIMEOUT = 10000;
    private Stack pool = new Stack();
    private String url;
    private String username;
    private String password;
    private int totalConnections = 0;
    private int maxConnections = 1;
    private long expiryTime = 3600000L;
    private int waitCount = 0;
    private static Log log = LogFactory.getLog((Class)(class$org$apache$torque$pool$ConnectionPool == null ? (class$org$apache$torque$pool$ConnectionPool = ConnectionPool.class$("org.apache.torque.pool.ConnectionPool")) : class$org$apache$torque$pool$ConnectionPool));
    private int logInterval = 0;
    private Monitor monitor;
    private long connectionWaitTimeout = 10000L;
    private ConnectionPoolDataSource cpds;
    private Map timeStamps = new HashMap();
    static /* synthetic */ Class class$org$apache$torque$pool$ConnectionPool;

    ConnectionPool(ConnectionPoolDataSource cpds, String username, String password, int maxConnections, int expiryTime, int connectionWaitTimeout, int logInterval) {
        this.cpds = cpds;
        this.username = username;
        this.password = password;
        this.maxConnections = maxConnections > 0 ? maxConnections : 1;
        this.expiryTime = expiryTime > 0 ? expiryTime * 1000 : 3600000;
        this.connectionWaitTimeout = connectionWaitTimeout > 0 ? connectionWaitTimeout * 1000 : 10000;
        this.logInterval = 1000 * logInterval;
        if (logInterval > 0) {
            log.debug((Object)("Starting Pool Monitor Thread with Log Interval " + logInterval + " Milliseconds"));
            this.monitor = new Monitor();
            this.monitor.setDaemon(true);
            this.monitor.start();
        }
    }

    final synchronized PooledConnection getConnection(String username, String password) throws SQLException {
        if (username != this.username || password != this.password) {
            throw new SQLException("Username and password are invalid.");
        }
        PooledConnection pcon = null;
        if (this.pool.empty() && this.totalConnections < this.maxConnections) {
            pcon = this.getNewConnection();
        } else {
            try {
                pcon = this.getInternalPooledConnection();
            }
            catch (Exception e) {
                throw new SQLException(e.getMessage());
            }
        }
        return pcon;
    }

    private PooledConnection getNewConnection() throws SQLException {
        PooledConnection pc = null;
        pc = this.username == null ? this.cpds.getPooledConnection() : this.cpds.getPooledConnection(this.username, this.password);
        pc.addConnectionEventListener(this);
        long currentTime = System.currentTimeMillis();
        double ratio = new Long(this.maxConnections - this.totalConnections).doubleValue() / (double)this.maxConnections;
        long ratioTime = new Double((double)currentTime - (double)this.expiryTime * ratio / 4.0).longValue();
        ratioTime = this.expiryTime < 0L ? currentTime : ratioTime;
        this.timeStamps.put(pc, new Long(ratioTime));
        ++this.totalConnections;
        return pc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized PooledConnection getInternalPooledConnection() throws ConnectionWaitTimeoutException, Exception {
        if (this.waitCount > 0 || this.pool.empty()) {
            try {
                ++this.waitCount;
                this.wait(this.connectionWaitTimeout);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                --this.waitCount;
            }
            if (this.pool.empty()) {
                throw new ConnectionWaitTimeoutException(this.url);
            }
        }
        return this.popConnection();
    }

    private PooledConnection popConnection() throws Exception {
        while (!this.pool.empty()) {
            PooledConnection con = (PooledConnection)this.pool.pop();
            if (this.isValid(con)) {
                return con;
            }
            con.close();
            --this.totalConnections;
            if (!this.pool.empty()) continue;
            return this.getNewConnection();
        }
        throw new Exception("Assertion failure: Attempted to pop connection from empty pool!");
    }

    private boolean isExpired(PooledConnection pc) {
        long birth = (Long)this.timeStamps.get(pc);
        long age = System.currentTimeMillis() - birth;
        boolean dead = this.expiryTime > 0L ? age > this.expiryTime : age > 3600000L;
        return dead;
    }

    private boolean isValid(PooledConnection connection) {
        return !this.isExpired(connection);
    }

    protected void finalize() throws Throwable {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        if (this.pool != null) {
            while (!this.pool.isEmpty()) {
                try {
                    ((PooledConnection)this.pool.pop()).close();
                }
                catch (SQLException sQLException) {}
                continue;
                finally {
                    --this.totalConnections;
                }
            }
        }
        this.monitor.shutdown();
    }

    int getTotalCount() {
        return this.totalConnections;
    }

    int getNbrAvailable() {
        return this.pool.size();
    }

    int getNbrCheckedOut() {
        return this.totalConnections - this.pool.size();
    }

    void decrementConnections() {
        --this.totalConnections;
        this.notify();
    }

    String getPoolName() {
        return this.toString();
    }

    public void connectionClosed(ConnectionEvent event) {
        this.releaseConnection((PooledConnection)event.getSource());
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        try {
            System.err.println("CLOSING DOWN CONNECTION DUE TO INTERNAL ERROR");
            ((PooledConnection)event.getSource()).removeConnectionEventListener(this);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            this.closePooledConnection((PooledConnection)event.getSource());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized void releaseConnection(PooledConnection pcon) {
        if (this.isValid(pcon)) {
            this.pool.push(pcon);
            this.notify();
        } else {
            this.closePooledConnection(pcon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closePooledConnection(PooledConnection pcon) {
        try {
            pcon.close();
            this.timeStamps.remove(pcon);
        }
        catch (Exception e) {
            log.error((Object)"Error occurred trying to close a PooledConnection.", (Throwable)e);
        }
        finally {
            this.decrementConnections();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class Monitor
    extends Thread {
        private boolean isRun = true;

        protected Monitor() {
        }

        public void run() {
            StringBuffer buf = new StringBuffer();
            while (ConnectionPool.this.logInterval > 0 && this.isRun) {
                buf.setLength(0);
                buf.append(ConnectionPool.this.getPoolName());
                buf.append(" avail: ").append(ConnectionPool.this.getNbrAvailable());
                buf.append(" in use: ").append(ConnectionPool.this.getNbrCheckedOut());
                buf.append(" total: ").append(ConnectionPool.this.getTotalCount());
                log.info((Object)buf.toString());
                try {
                    Thread.sleep(ConnectionPool.this.logInterval);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void shutdown() {
            this.isRun = false;
        }
    }
}

