/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.gadgets;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.services.config.ALConfigHandler;
import com.aimluck.eip.services.config.ALConfigService;
import com.aimluck.eip.services.social.ALContainerConfigService;
import com.aimluck.eip.services.social.ALSocialApplicationHandler;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.List;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class GadgetsContainerAdminFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)GadgetsContainerAdminFormData.class.getName());
    private ALNumberField lockedDomainRequired;
    private ALStringField lockedDomainSuffix;
    private ALStringField checkActivityInterval;
    private ALNumberField cacheGadgetXml;
    private ALStringField activitySaveLimit;

    public void initField() {
        this.lockedDomainRequired = new ALNumberField();
        this.lockedDomainSuffix = new ALStringField();
        this.lockedDomainSuffix.setTrim(true);
        this.lockedDomainSuffix.setFieldName(ALLocalizationUtils.getl10n((String)"GADGETS_SETFIELDNAME_LOCKED_DOMAIN_SUFFIX"));
        this.checkActivityInterval = new ALStringField();
        this.checkActivityInterval.setTrim(true);
        this.checkActivityInterval.setFieldName(ALLocalizationUtils.getl10n((String)"GADGETS_SETFIELDNAME_CHECK_ACTIVITY_INTERVAL"));
        this.cacheGadgetXml = new ALNumberField();
        this.activitySaveLimit = new ALStringField();
        this.checkActivityInterval.setTrim(true);
        this.checkActivityInterval.setFieldName(ALLocalizationUtils.getl10n((String)"GADGETS_SETFIELDNAME_ACTIVITY_SAVE_LIMIT"));
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        return res;
    }

    protected void setValidator() throws ALPageNotFoundException, ALDBErrorException {
        this.lockedDomainSuffix.setNotNull(true);
        this.lockedDomainSuffix.setCharacterType(19);
        this.lockedDomainSuffix.limitMaxLength(255);
        this.checkActivityInterval.setNotNull(true);
        this.activitySaveLimit.setNotNull(true);
    }

    protected boolean validate(List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        if (this.lockedDomainRequired.getValue() > 0L) {
            this.lockedDomainSuffix.validate(msgList);
        }
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        this.lockedDomainRequired.setValue(ALContainerConfigService.get((ALSocialApplicationHandler.Property)ALSocialApplicationHandler.Property.LOCKED_DOMAIN_REQUIRED).equals("true") ? 1L : 0L);
        this.checkActivityInterval.setValue(ALConfigService.get((ALConfigHandler.Property)ALConfigHandler.Property.CHECK_ACTIVITY_INTERVAL));
        this.lockedDomainSuffix.setValue(ALContainerConfigService.get((ALSocialApplicationHandler.Property)ALSocialApplicationHandler.Property.LOCKED_DOMAIN_SUFFIX));
        this.cacheGadgetXml.setValue(ALContainerConfigService.get((ALSocialApplicationHandler.Property)ALSocialApplicationHandler.Property.CACHE_GADGET_XML).equals("true") ? 1L : 0L);
        this.activitySaveLimit.setValue(ALContainerConfigService.get((ALSocialApplicationHandler.Property)ALSocialApplicationHandler.Property.ACTIVITY_SAVE_LIMIT));
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            long value = this.lockedDomainRequired.getValue();
            long cache = this.cacheGadgetXml.getValue();
            ALContainerConfigService.put((ALSocialApplicationHandler.Property)ALSocialApplicationHandler.Property.LOCKED_DOMAIN_REQUIRED, (String)(value == 1L ? "true" : "false"));
            ALContainerConfigService.put((ALSocialApplicationHandler.Property)ALSocialApplicationHandler.Property.LOCKED_DOMAIN_SUFFIX, (String)(value == 1L ? this.lockedDomainSuffix.getValue() : ""));
            ALConfigService.put((ALConfigHandler.Property)ALConfigHandler.Property.CHECK_ACTIVITY_INTERVAL, (String)this.checkActivityInterval.getValue());
            ALContainerConfigService.put((ALSocialApplicationHandler.Property)ALSocialApplicationHandler.Property.CACHE_GADGET_XML, (String)(cache == 1L ? "true" : "false"));
            ALContainerConfigService.put((ALSocialApplicationHandler.Property)ALSocialApplicationHandler.Property.ACTIVITY_SAVE_LIMIT, (String)this.activitySaveLimit.getValue());
        }
        catch (Throwable t) {
            logger.error((Object)t, t);
            throw new ALDBErrorException();
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            long value = this.lockedDomainRequired.getValue();
            long cache = this.cacheGadgetXml.getValue();
            ALContainerConfigService.put((ALSocialApplicationHandler.Property)ALSocialApplicationHandler.Property.LOCKED_DOMAIN_REQUIRED, (String)(value == 1L ? "true" : "false"));
            ALContainerConfigService.put((ALSocialApplicationHandler.Property)ALSocialApplicationHandler.Property.LOCKED_DOMAIN_SUFFIX, (String)(value == 1L ? this.lockedDomainSuffix.getValue() : ""));
            ALConfigService.put((ALConfigHandler.Property)ALConfigHandler.Property.CHECK_ACTIVITY_INTERVAL, (String)this.checkActivityInterval.getValue());
            ALContainerConfigService.put((ALSocialApplicationHandler.Property)ALSocialApplicationHandler.Property.CACHE_GADGET_XML, (String)(cache == 1L ? "true" : "false"));
            ALContainerConfigService.put((ALSocialApplicationHandler.Property)ALSocialApplicationHandler.Property.ACTIVITY_SAVE_LIMIT, (String)this.activitySaveLimit.getValue());
        }
        catch (Throwable t) {
            logger.error((Object)t, t);
            throw new ALDBErrorException();
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        return true;
    }

    public ALNumberField getLockedDomainRequired() {
        return this.lockedDomainRequired;
    }

    public ALStringField getLockedDomainSuffix() {
        return this.lockedDomainSuffix;
    }

    public ALStringField getCheckActivityInterval() {
        return this.checkActivityInterval;
    }

    public ALNumberField getCacheGadgetXml() {
        return this.cacheGadgetXml;
    }

    public ALStringField getActivitySaveLimit() {
        return this.activitySaveLimit;
    }
}

