/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.actions.gadgets;

import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.modules.actions.common.ALBaseAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.services.social.ALApplicationService;
import com.aimluck.eip.services.social.ALContainerConfigService;
import com.aimluck.eip.services.social.ALSocialApplicationHandler;
import com.aimluck.eip.services.social.gadgets.ALGadgetContext;
import com.aimluck.eip.util.ALEipUtils;
import java.util.HashMap;
import java.util.Iterator;
import net.sf.json.JSONObject;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletInstance;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.PsmlManager;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.persistence.PersistenceManager;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class GadgetsAction
extends ALBaseAction {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)GadgetsAction.class.getName());

    protected void buildNormalContext(VelocityPortlet portlet, Context context, RunData rundata) throws Exception {
        this.buildCommonContext(portlet, context, rundata, false);
        context.put("view", (Object)"home");
    }

    protected void buildMaximizedContext(VelocityPortlet portlet, Context context, RunData rundata) {
        this.buildCommonContext(portlet, context, rundata, true);
    }

    protected void buildCommonContext(VelocityPortlet portlet, Context context, RunData rundata, boolean isMaximized) {
        String appId = portlet.getPortletConfig().getInitParameter("aid");
        String url = portlet.getPortletConfig().getInitParameter("url");
        Long mid = null;
        try {
            mid = Long.valueOf(portlet.getPortletConfig().getInitParameter("mid"));
        }
        catch (Throwable ignore) {
            // empty catch block
        }
        if (mid == null) {
            mid = ALApplicationService.getNextModuleId();
            PortletInstance instance = PersistenceManager.getInstance((Portlet)portlet, (RunData)rundata);
            instance.setAttribute("mid", String.valueOf(mid));
            Profile profile = ((JetspeedRunData)rundata).getProfile();
            profile.setDocument(instance.getDocument());
            PsmlManager.store((Profile)profile);
        }
        boolean isActive = false;
        if (appId == null || url == null || mid == null) {
            isActive = false;
            context.put("isActive", (Object)isActive);
            this.setTemplate(rundata, isMaximized ? "gadgets-list" : "gadgets");
            return;
        }
        isActive = this.checkApplicationAvailability(appId);
        ALEipUser user = ALEipUtils.getALEipUser((RunData)rundata);
        String orgId = Database.getDomainName();
        String viewer = orgId + ":" + user.getName().getValue();
        ALGadgetContext gadgetContext = new ALGadgetContext(rundata, viewer, appId, url, mid.longValue());
        context.put("gadgetContext", (Object)gadgetContext);
        context.put("isActive", (Object)isActive);
        Iterator names = portlet.getPortletConfig().getInitParameterNames();
        HashMap maps = new HashMap();
        while (names.hasNext()) {
            String next = (String)names.next();
            if (next == null || !next.startsWith("pref-")) continue;
            String value = portlet.getPortletConfig().getInitParameter(next);
            String key = next.substring(5);
            HashMap<String, String> maps2 = new HashMap<String, String>();
            maps2.put("value", value);
            maps.put(key, maps2);
        }
        String appParams = rundata.getParameters().getString("appParams");
        String js_peid = rundata.getParameters().getString("js_peid");
        JSONObject viewParams = null;
        if (portlet.getID().equals(js_peid) && appParams != null && appParams.length() > 0) {
            try {
                viewParams = JSONObject.fromObject((Object)appParams);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"id", (Object)mid);
        jsonObject.put((Object)"appId", (Object)appId);
        jsonObject.put((Object)"portletId", (Object)portlet.getID());
        jsonObject.put((Object)"specUrl", (Object)gadgetContext.getAppUrl());
        jsonObject.put((Object)"secureToken", (Object)gadgetContext.getSecureToken());
        jsonObject.put((Object)"serverBase", (Object)gadgetContext.getServerBase());
        jsonObject.put((Object)"activeUrl", (Object)gadgetContext.getActiveUrl());
        jsonObject.put((Object)"height", (Object)"200");
        jsonObject.put((Object)"width", (Object)"100%");
        jsonObject.put((Object)"rpcRelay", (Object)"files/container/rpc_relay.html");
        jsonObject.put((Object)"userPrefs", (Object)JSONObject.fromObject(maps));
        if (viewParams != null) {
            jsonObject.put((Object)"viewParams", (Object)viewParams);
        }
        context.put("assignData", (Object)jsonObject.toString());
        context.put("nocache", (Object)("true".equals(ALContainerConfigService.get((ALSocialApplicationHandler.Property)ALSocialApplicationHandler.Property.CACHE_GADGET_XML)) ? "0" : "1"));
        this.setTemplate(rundata, isMaximized ? "gadgets-list" : "gadgets");
    }

    protected boolean checkApplicationAvailability(String appId) {
        return ALApplicationService.checkAvailability((String)appId);
    }
}

