/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.screens;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALApplication;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.modules.screens.ALVelocityScreen;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.services.social.ALApplicationService;
import com.aimluck.eip.services.social.ALContainerConfigService;
import com.aimluck.eip.services.social.ALSocialApplicationHandler;
import com.aimluck.eip.services.social.gadgets.ALGadgetContext;
import com.aimluck.eip.services.social.model.ALApplicationGetRequest;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.HashMap;
import java.util.Iterator;
import net.sf.json.JSONObject;
import org.apache.jetspeed.portal.Portlet;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class GadgetsPopupScreen
extends ALVelocityScreen {
    protected void doOutput(RunData rundata, Context context) throws Exception {
        context.put("l10n", (Object)ALLocalizationUtils.createLocalization((RunData)rundata));
        String appId = rundata.getParameters().getString("aid");
        ALApplication app = ALApplicationService.get((ALApplicationGetRequest)new ALApplicationGetRequest().withAppId(appId));
        if (app == null) {
            context.put("isActive", (Object)false);
            context.put("title", (Object)"");
            String template = "portlets/html/ja/gadgets-popup.vm";
            this.setTemplate(rundata, context, template);
            return;
        }
        ALStringField title = app.getTitle();
        String url = app.getUrl().getValue();
        boolean isActive = app.getStatus() == 1;
        ALEipUser user = ALEipUtils.getALEipUser((RunData)rundata);
        String orgId = Database.getDomainName();
        String viewer = orgId + ":" + user.getName().getValue();
        Long moduleId = rundata.getParameters().getLong("mid");
        HashMap maps = new HashMap();
        if (moduleId != null) {
            Portlet portlet = ALEipUtils.getPortlet((RunData)rundata, (String)String.valueOf(moduleId));
            if (portlet != null) {
                Iterator names = portlet.getPortletConfig().getInitParameterNames();
                while (names.hasNext()) {
                    String next = (String)names.next();
                    if (next == null || !next.startsWith("pref-")) continue;
                    String value = portlet.getPortletConfig().getInitParameter(next);
                    String key = next.substring(5);
                    HashMap<String, String> maps2 = new HashMap<String, String>();
                    maps2.put("value", value);
                    maps.put(key, maps2);
                }
            } else {
                moduleId = 0L;
            }
        } else {
            moduleId = 0L;
        }
        ALGadgetContext gadgetContext = new ALGadgetContext(rundata, viewer, appId, url, moduleId.longValue());
        context.put("gadgetContext", (Object)gadgetContext);
        context.put("isActive", (Object)isActive);
        String id = moduleId == 0L ? String.valueOf(System.nanoTime()) : String.valueOf(moduleId);
        context.put("portletId", (Object)id);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"portletId", (Object)id);
        jsonObject.put((Object)"appId", (Object)appId);
        jsonObject.put((Object)"specUrl", (Object)gadgetContext.getAppUrl());
        jsonObject.put((Object)"secureToken", (Object)gadgetContext.getSecureToken());
        jsonObject.put((Object)"serverBase", (Object)gadgetContext.getServerBase());
        jsonObject.put((Object)"width", (Object)"100%");
        jsonObject.put((Object)"rpcRelay", (Object)"files/container/rpc_relay.html");
        jsonObject.put((Object)"userPrefs", (Object)JSONObject.fromObject(maps));
        String externalId = rundata.getParameters().getString("eid");
        if (externalId != null && externalId.length() > 0) {
            JSONObject externalJson = new JSONObject();
            externalJson.put((Object)"externalId", (Object)externalId);
            jsonObject.put((Object)"viewParams", (Object)externalJson);
        }
        context.put("assignData", (Object)jsonObject.toString());
        context.put("title", (Object)title);
        context.put("nocache", (Object)("true".equals(ALContainerConfigService.get((ALSocialApplicationHandler.Property)ALSocialApplicationHandler.Property.CACHE_GADGET_XML)) ? "0" : "1"));
        String template = "portlets/html/ja/gadgets-popup.vm";
        this.setTemplate(rundata, context, template);
    }

    protected String getPortletName() {
        return "GadgetsTemplate";
    }
}

