/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.facilities;

import com.aimluck.eip.cayenne.om.portlet.EipMFacilityGroup;
import com.aimluck.eip.cayenne.om.portlet.EipMFacilityGroupMap;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class FacilityGroupMultiDelete
extends ALAbstractCheckList {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)FacilityGroupMultiDelete.class.getName());

    protected boolean action(RunData rundata, Context context, List<String> values, List<String> msgList) {
        try {
            SelectQuery query1 = Database.query(EipMFacilityGroupMap.class);
            Expression exp1 = ExpressionFactory.inExp((String)"GroupId", values);
            query1.setQualifier(exp1);
            List maplist = query1.fetchList();
            if (maplist != null && maplist.size() > 0) {
                Database.deleteAll((List)maplist);
            }
            SelectQuery query = Database.query(EipMFacilityGroup.class);
            Expression exp = ExpressionFactory.inDbExp((String)"GROUP_ID", values);
            query.setQualifier(exp);
            List flist = query.fetchList();
            if (flist == null || flist.size() == 0) {
                return false;
            }
            Database.deleteAll((List)flist);
            Database.commit();
            for (EipMFacilityGroup facilityGroup : flist) {
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(facilityGroup.getGroupId().intValue(), 5, ALLocalizationUtils.getl10nFormat((String)"FACILITIES_DELETED_FACILITYGROUP_WITH_NAME", (Object[])new Object[]{facilityGroup.getGroupName()}));
            }
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"facilities", (Throwable)ex);
            return false;
        }
        return true;
    }
}

