/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.facilities;

import com.aimluck.eip.cayenne.om.portlet.EipMFacility;
import com.aimluck.eip.cayenne.om.portlet.EipMFacilityGroupMap;
import com.aimluck.eip.cayenne.om.portlet.EipTScheduleMap;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.Operations;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class FacilityMultiDelete
extends ALAbstractCheckList {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)FacilityMultiDelete.class.getName());

    protected boolean action(RunData rundata, Context context, List<String> values, List<String> msgList) {
        try {
            SelectQuery query1 = Database.query(EipTScheduleMap.class);
            Expression exp1 = ExpressionFactory.inExp((String)"userId", values);
            Expression exp2 = ExpressionFactory.matchExp((String)"type", (Object)"F");
            query1.setQualifier(exp1.andExp(exp2));
            List slist = query1.fetchList();
            if (slist != null && slist.size() > 0) {
                Database.deleteAll((List)slist);
            }
            SelectQuery query = Database.query(EipMFacility.class);
            Expression exp = ExpressionFactory.inDbExp((String)"FACILITY_ID", values);
            query.setQualifier(exp);
            List flist = query.fetchList();
            if (flist == null || flist.size() == 0) {
                return false;
            }
            Database.deleteAll((List)flist);
            SelectQuery fmaps = Database.query(EipMFacilityGroupMap.class);
            fmaps.where(Operations.in((String)"FacilityId", values));
            fmaps.deleteAll();
            Database.commit();
            for (EipMFacility facility : flist) {
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(facility.getFacilityId().intValue(), 5, ALLocalizationUtils.getl10nFormat((String)"FACILITIES_DELETED_FACILITY_WITH_NAME", (Object[])new Object[]{facility.getFacilityName()}));
            }
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"facilities", (Throwable)ex);
            return false;
        }
        return true;
    }
}

