/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.screens;

import com.aimluck.eip.cayenne.om.portlet.EipTEventlog;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.eventlog.EventlogResultData;
import com.aimluck.eip.eventlog.util.ALEventlogUtils;
import com.aimluck.eip.modules.screens.ALCSVScreen;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.ListIterator;
import java.util.Locale;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;

public class EventlogCsvExportScreen
extends ALCSVScreen {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)EventlogCsvExportScreen.class.getName());

    protected String getContentType(RunData rundata) {
        return "application/octet-stream";
    }

    protected EventlogResultData getResultData(EipTEventlog record) {
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5(EE)HH:mm:ss");
            EventlogResultData rd = new EventlogResultData();
            rd.initField();
            rd.setEventlogId(record.getEventlogId().longValue());
            TurbineUser user = record.getTurbineUser();
            rd.setUserFullName(user == null ? "" : new StringBuffer().append(user.getLastName()).append(" ").append(user.getFirstName()).toString());
            rd.setEventDate(df.format(record.getUpdateDate()));
            rd.setPortletName(ALEventlogUtils.getPortletAliasName((int)record.getPortletType()));
            rd.setEntityId(record.getEntityId().longValue());
            rd.setIpAddr(record.getIpAddr());
            rd.setEventName(ALEventlogUtils.getEventAliasName((int)record.getEventType()));
            rd.setNote(record.getNote());
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"eventlog", (Throwable)ex);
            return null;
        }
    }

    protected String getCSVString(RunData rundata) throws Exception {
        if (ALEipUtils.isAdmin((RunData)rundata)) {
            SelectQuery query = Database.query(EipTEventlog.class);
            Date startDay = DateFormat.getDateInstance(2, Locale.JAPAN).parse(rundata.getParameters().get("start_day"));
            Date endDay = DateFormat.getDateInstance(2, Locale.JAPAN).parse(rundata.getParameters().get("end_day"));
            Calendar cal = Calendar.getInstance();
            cal.setTime(endDay);
            cal.set(5, cal.get(5) + 1);
            endDay = cal.getTime();
            Expression exp1 = ExpressionFactory.greaterOrEqualExp((String)"eventDate", (Object)startDay);
            Expression exp2 = ExpressionFactory.lessExp((String)"eventDate", (Object)endDay);
            query.andQualifier(exp1.andExp(exp2));
            ResultList list = query.getResultList();
            String LINE_SEPARATOR = System.getProperty("line.separator");
            try {
                StringBuffer sb = new StringBuffer("\"\u65e5\u6642\",\"\u540d\u524d\",\"\u6a5f\u80fd\u540d\",\"\u64cd\u4f5c\",\"\u63a5\u7d9aIP\",\"\u4ef6\u540d\"");
                ListIterator iterator = list.listIterator(list.size());
                while (iterator.hasPrevious()) {
                    sb.append(LINE_SEPARATOR);
                    EventlogResultData data = this.getResultData((EipTEventlog)iterator.previous());
                    sb.append("\"");
                    sb.append(data.getEventDate());
                    sb.append("\",\"");
                    sb.append(data.getUserFullName());
                    sb.append("\",\"");
                    sb.append(data.getPortletName());
                    sb.append("\",\"");
                    sb.append(data.getEventName());
                    sb.append("\",\"");
                    sb.append(data.getIpAddr());
                    sb.append("\",\"");
                    sb.append(data.getNote());
                    sb.append("\"");
                }
                return sb.toString();
            }
            catch (Exception e) {
                logger.error((Object)"EventlogCsvExportScreen.getCSVString", (Throwable)e);
                return null;
            }
        }
        throw new ALPermissionException();
    }

    protected String getFileName() {
        return "eventlog.csv";
    }
}

