/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.userfacility.util;

import com.aimluck.eip.cayenne.om.portlet.EipMFacility;
import com.aimluck.eip.cayenne.om.portlet.EipMFacilityGroupMap;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.user.beans.UserLiteBean;
import com.aimluck.eip.user.util.UserUtils;
import com.aimluck.eip.userfacility.beans.UserFacilityLiteBean;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.turbine.util.RunData;

public class UserFacilityUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)UserFacilityUtils.class.getName());

    public static List<UserFacilityLiteBean> getUserFacilityLiteBeansFromGroup(RunData rundata, String groupname) {
        UserFacilityLiteBean user;
        List tmp_u_list = UserUtils.getUserLiteBeansFromGroup((RunData)rundata, (String)groupname, (boolean)true);
        int t_size = tmp_u_list.size();
        ArrayList<UserFacilityLiteBean> list = new ArrayList<UserFacilityLiteBean>();
        for (int i = 0; i < t_size; ++i) {
            UserLiteBean t_user = (UserLiteBean)tmp_u_list.get(i);
            user = new UserFacilityLiteBean();
            user.initField();
            user.setUserFacilityId(Integer.parseInt(t_user.getUserId()));
            user.setName(t_user.getUserId());
            user.setAliasName(t_user.getAliasName());
            user.setUserFacilityType("U");
            list.add(user);
        }
        if (!"LoginUser".equals(groupname)) {
            StringBuffer statement = new StringBuffer();
            statement.append("SELECT DISTINCT ");
            statement.append("  B.FACILITY_ID, B.FACILITY_NAME, B.SORT ");
            statement.append("FROM eip_facility_group as A ");
            statement.append("LEFT JOIN eip_m_facility as B ");
            statement.append("  on A.FACILITY_ID = B.FACILITY_ID ");
            statement.append("LEFT JOIN turbine_group as C ");
            statement.append("  on A.GROUP_ID = C.GROUP_ID ");
            statement.append("WHERE C.GROUP_NAME = #bind($groupname)");
            statement.append("ORDER BY B.SORT");
            String query = statement.toString();
            List list2 = Database.sql(EipMFacility.class, (String)query).param("groupname", (Object)groupname).fetchList();
            for (EipMFacility record : list2) {
                user = new UserFacilityLiteBean();
                user.initField();
                user.setUserFacilityId(record.getFacilityId());
                user.setName("f" + user.getUserFacilityId());
                user.setAliasName(record.getFacilityName());
                user.setUserFacilityType("F");
                list.add(user);
            }
        } else {
            List aList = Database.query(EipMFacility.class).orderAscending("sort").fetchList();
            for (EipMFacility record : aList) {
                user = new UserFacilityLiteBean();
                user.initField();
                user.setUserFacilityId(record.getFacilityId());
                user.setName("f" + user.getUserFacilityId());
                user.setAliasName(record.getFacilityName());
                user.setUserFacilityType("F");
                list.add(user);
            }
        }
        return list;
    }

    public static List<UserFacilityLiteBean> getFacilityLiteBeansFromGroup(RunData rundata, int groupid) {
        ArrayList<UserFacilityLiteBean> facilityAllList = new ArrayList<UserFacilityLiteBean>();
        SelectQuery mapquery = Database.query(EipMFacilityGroupMap.class);
        Expression mapexp = ExpressionFactory.matchExp((String)"GroupId", (Object)groupid);
        mapquery.setQualifier(mapexp);
        List FacilityMaps = mapquery.fetchList();
        ArrayList<Integer> facilityIds = new ArrayList<Integer>();
        for (EipMFacilityGroupMap map : FacilityMaps) {
            facilityIds.add(map.getEipMFacilityFacilityId().getFacilityId());
        }
        SelectQuery fquery = Database.query(EipMFacility.class);
        if (facilityIds.size() > 0) {
            Expression fexp = ExpressionFactory.inDbExp((String)"FACILITY_ID", facilityIds);
            fquery.setQualifier(fexp);
            fquery.orderAscending("sort");
            List facility_list = fquery.fetchList();
            for (EipMFacility record : facility_list) {
                UserFacilityLiteBean bean = new UserFacilityLiteBean();
                bean.initField();
                bean.setUserFacilityId(record.getFacilityId());
                bean.setAliasName(record.getFacilityName());
                bean.setName("f" + record.getFacilityId());
                bean.setUserFacilityType("F");
                facilityAllList.add(bean);
            }
        }
        return facilityAllList;
    }

    public static List<UserFacilityLiteBean> getAllFacilityLiteBeans(RunData rundata) {
        ArrayList<UserFacilityLiteBean> facilityAllList = new ArrayList<UserFacilityLiteBean>();
        SelectQuery fquery = Database.query(EipMFacility.class);
        fquery.orderAscending("sort");
        List facility_list = fquery.fetchList();
        for (EipMFacility record : facility_list) {
            UserFacilityLiteBean bean = new UserFacilityLiteBean();
            bean.initField();
            bean.setUserFacilityId(record.getFacilityId());
            bean.setAliasName(record.getFacilityName());
            bean.setName("f" + record.getFacilityId());
            bean.setUserFacilityType("F");
            facilityAllList.add(bean);
        }
        return facilityAllList;
    }

    public static UserFacilityLiteBean getUserFacilityLiteBean(RunData rundata) {
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        UserFacilityLiteBean user = new UserFacilityLiteBean();
        user.initField();
        user.setUserFacilityId(Integer.parseInt(jdata.getJetspeedUser().getUserId()));
        user.setName(jdata.getJetspeedUser().getUserName());
        user.setAliasName(jdata.getJetspeedUser().getFirstName(), jdata.getJetspeedUser().getLastName());
        user.setUserFacilityType("U");
        return user;
    }
}

