/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.todo;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.utils.ALDateUtil;
import com.aimluck.eip.cayenne.om.portlet.EipTTodoCategory;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipGroup;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.Operations;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.todo.ToDoCategoryResultData;
import com.aimluck.eip.todo.util.ToDoUtils;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ToDoCategorySelectData
extends ALAbstractSelectData<EipTTodoCategory, EipTTodoCategory>
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ToDoCategorySelectData.class.getName());
    private int categorySum;
    private String target_user_id;
    private String target_group_name;
    private ArrayList<ALEipGroup> myGroupList;
    private ArrayList<ToDoCategoryResultData> categoryList;
    private boolean hasAclShowCategoryOther;
    private boolean hasAclEditCategoryOther;
    private boolean hasAclDeleteCategoryOther;
    private int login_user_id;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)"category_name");
            logger.debug((Object)"[ToDoCategorySelectData] Init Parameter. : category_name");
        }
        this.login_user_id = ALEipUtils.getUserId((RunData)rundata);
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        this.hasAclShowCategoryOther = aclhandler.hasAuthority(this.login_user_id, "todo_category_other", 1);
        this.hasAclEditCategoryOther = aclhandler.hasAuthority(this.login_user_id, "todo_category_other", 8);
        this.hasAclDeleteCategoryOther = aclhandler.hasAuthority(this.login_user_id, "todo_category_other", 16);
        super.init(action, rundata, context);
    }

    protected ResultList<EipTTodoCategory> selectList(RunData rundata, Context context) {
        try {
            this.target_group_name = ToDoUtils.getTargetGroupName(rundata, context);
            this.target_user_id = ToDoUtils.getTargetUserId(rundata, context);
            this.setMyGroupList(new ArrayList<ALEipGroup>());
            this.getMyGroupList().addAll(ALEipUtils.getMyGroups((RunData)rundata));
            SelectQuery<EipTTodoCategory> query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            ResultList list = query.getResultList();
            this.categorySum = list.getTotalCount();
            return list;
        }
        catch (Exception ex) {
            logger.error((Object)"todo", (Throwable)ex);
            return null;
        }
    }

    private SelectQuery<EipTTodoCategory> getSelectQuery(RunData rundata, Context context) {
        if (this.hasAclShowCategoryOther) {
            return Database.query(EipTTodoCategory.class).where(Operations.ne((String)"userId", (Object)0));
        }
        return Database.query(EipTTodoCategory.class).where(Operations.eq((String)"userId", (Object)ALEipUtils.getUserId((RunData)rundata)));
    }

    protected EipTTodoCategory selectDetail(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        return ToDoUtils.getEipTTodoCategory(rundata, context);
    }

    protected Object getResultData(EipTTodoCategory record) {
        ToDoCategoryResultData rd = new ToDoCategoryResultData();
        rd.initField();
        rd.setCategoryId(record.getCategoryId().longValue());
        rd.setCategoryName(ALCommonUtils.compressString((String)record.getCategoryName(), (int)this.getStrLength()));
        rd.setHasAclDeleteCategoryOther(this.hasAclDeleteCategoryOther);
        rd.setHasAclEditCategoryOther(this.hasAclEditCategoryOther);
        rd.setIsSelfCategory(record.getUpdateUserId() == this.login_user_id);
        try {
            rd.setUpdateUserId(new ALNumberField((long)record.getUpdateUserId().intValue()));
            rd.setUpdateUserName(ALEipUtils.getALEipUser((int)record.getUpdateUserId()).getAliasName().getValue());
        }
        catch (ALDBErrorException ex) {
            logger.error((Object)"todo", (Throwable)ex);
        }
        rd.setNote(record.getNote());
        return rd;
    }

    protected Object getResultDataDetail(EipTTodoCategory record) {
        ToDoCategoryResultData rd = new ToDoCategoryResultData();
        rd.initField();
        rd.setCategoryId(record.getCategoryId().longValue());
        rd.setCategoryName(record.getCategoryName());
        rd.setNote(record.getNote());
        try {
            rd.setUserName(ALEipUtils.getALEipUser((int)record.getUserId()).getAliasName().getValue());
            rd.setUserId(new ALNumberField((long)record.getUserId().intValue()));
            rd.setUpdateUserName(ALEipUtils.getALEipUser((int)record.getUpdateUserId()).getAliasName().getValue());
            rd.setUpdateUserId(new ALNumberField((long)record.getUpdateUserId().intValue()));
        }
        catch (ALDBErrorException ex) {
            logger.error((Object)"todo", (Throwable)ex);
        }
        rd.setCreateDate(ALDateUtil.format((Date)record.getCreateDate(), (String)"yyyy\u5e74M\u6708d\u65e5"));
        rd.setUpdateDate(ALDateUtil.format((Date)record.getUpdateDate(), (String)"yyyy\u5e74M\u6708d\u65e5"));
        rd.setHasAclDeleteCategoryOther(this.hasAclDeleteCategoryOther);
        rd.setHasAclEditCategoryOther(this.hasAclEditCategoryOther);
        rd.setIsSelfCategory(record.getUserId() == this.login_user_id);
        return rd;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("category_name", "categoryName");
        map.putValue("user_name", "turbineUser.lastNameKana");
        return map;
    }

    public void loadCategoryList(RunData rundata) {
        this.categoryList = ToDoUtils.getCategoryList(rundata);
    }

    public int getCategorySum() {
        return this.categorySum;
    }

    public String getCurrentTab() {
        return "category";
    }

    public String getTargetGroupName() {
        return this.target_group_name;
    }

    public String getTargetUserId() {
        return this.target_user_id;
    }

    public Map<Integer, ALEipPost> getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public List<ALEipUser> getUsers() {
        if (this.target_group_name != null && !this.target_group_name.equals("") && !this.target_group_name.equals("all")) {
            return ALEipUtils.getUsers((String)this.target_group_name);
        }
        return ALEipUtils.getUsers((String)"LoginUser");
    }

    public String getAclPortletFeature() {
        return "todo_category_self";
    }

    public void setMyGroupList(ArrayList<ALEipGroup> myGroupList) {
        this.myGroupList = myGroupList;
    }

    public ArrayList<ALEipGroup> getMyGroupList() {
        return this.myGroupList;
    }

    public List<ToDoCategoryResultData> getCategoryList() {
        return this.categoryList;
    }

    public ALNumberField getLoginUserId() {
        return new ALNumberField((long)this.login_user_id);
    }
}

