/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipHolidaysManager;
import com.aimluck.eip.common.ALHoliday;
import com.aimluck.eip.schedule.AjaxScheduleResultData;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class AjaxScheduleDayContainer
implements ALData {
    private ALDateTimeField today;
    private List<AjaxScheduleResultData> scheduleList;
    private List<Integer> doneList;
    private ALHoliday holiday;

    public void initField() {
        this.today = new ALDateTimeField("yyyy-MM-dd-HH-mm");
        this.scheduleList = new ArrayList<AjaxScheduleResultData>();
        this.doneList = new ArrayList<Integer>();
    }

    public List<AjaxScheduleResultData> getScheduleList() {
        return this.scheduleList;
    }

    public void setDate(Date date) {
        this.today.setValue(date);
        ALEipHolidaysManager holidaysManager = ALEipHolidaysManager.getInstance();
        this.holiday = holidaysManager.isHoliday(date);
    }

    public ALDateTimeField getDate() {
        return this.today;
    }

    public void addResultData(AjaxScheduleResultData rd, boolean show_all) {
        int schedule_id;
        int size = this.scheduleList.size();
        int position = 0;
        boolean canAdd = true;
        boolean repeat_del = false;
        boolean pos_bool = false;
        for (int i = 0; i < size; ++i) {
            repeat_del = false;
            AjaxScheduleResultData rd2 = this.scheduleList.get(i);
            if (rd.isRepeat() && rd.getUserId() == rd2.getUserId() && rd2.isDummy() && rd.getScheduleId().getValue() == rd2.getParentId().getValue() && ScheduleUtils.equalsToDate(rd.getStartDate().getValue(), rd2.getStartDate().getValue(), false)) {
                canAdd = false;
                break;
            }
            if (rd2.isRepeat() && rd.isDummy() && rd2.getScheduleId().getValue() == rd.getParentId().getValue() && ScheduleUtils.equalsToDate(rd.getStartDate().getValue(), rd2.getStartDate().getValue(), false)) {
                this.scheduleList.remove(rd2);
                canAdd = true;
                repeat_del = true;
            }
            if (!pos_bool && rd.getStartDate().getValue().before(rd2.getStartDate().getValue())) {
                position = i;
                pos_bool = true;
            }
            if (repeat_del || rd.isDummy() || rd2.isDummy() || !rd.getType().equals(rd2.getType()) || rd.getUserId() != rd2.getUserId() || !(rd.getStartDate().getValue().before(rd2.getStartDate().getValue()) && rd2.getStartDate().getValue().before(rd.getEndDate().getValue()) || rd2.getStartDate().getValue().before(rd.getStartDate().getValue()) && rd.getStartDate().getValue().before(rd2.getEndDate().getValue()) || rd.getStartDate().getValue().before(rd2.getEndDate().getValue()) && rd2.getEndDate().getValue().before(rd.getEndDate().getValue()) || rd2.getStartDate().getValue().before(rd.getEndDate().getValue()) && rd.getEndDate().getValue().before(rd2.getEndDate().getValue())) && (!rd.getEndDate().getValue().equals(rd2.getEndDate().getValue()) || !rd.getStartDate().getValue().equals(rd2.getStartDate().getValue()))) continue;
            rd2.setDuplicate(true);
            rd.setDuplicate(true);
        }
        if (canAdd && !this.doneList.contains(schedule_id = (int)rd.getScheduleId().getValue())) {
            if (pos_bool) {
                this.scheduleList.add(position, rd);
            } else {
                this.scheduleList.add(rd);
            }
            if (!show_all && !rd.isDummy()) {
                this.doneList.add(schedule_id);
            }
        }
    }

    public boolean isHoliday() {
        return this.holiday != null;
    }

    public ALHoliday getHoliday() {
        return this.holiday;
    }
}

