/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.commons.field.ALCellStringField;
import com.aimluck.eip.cayenne.om.portlet.EipMFacilityGroup;
import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.facilities.FacilityResultData;
import com.aimluck.eip.facilities.util.FacilitiesUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.schedule.AbstractCellScheduleFormData;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class CellScheduleFormFacilityData
extends AbstractCellScheduleFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CellScheduleFormFacilityData.class.getName());
    private List<EipMFacilityGroup> facilities;
    private ALCellStringField selected_group;
    private int rows_num = 10;
    private int start;
    private int count;
    private int current_page = 1;
    private int pages_num = 1;
    private List<FacilityResultData> facilityAllList;

    @Override
    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        this.facilityAllList = new ArrayList<FacilityResultData>();
        this.facilityAllList.addAll(FacilitiesUtils.getFacilityAllList());
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context) && rundata.getParameters().containsKey((Object)"start")) {
            this.current_page = rundata.getParameters().getInt("start");
        }
        this.selected_group.setValue(rundata.getParameters().get("selectedgroup"));
        super.init(action, rundata, context);
    }

    @Override
    public void initField() {
        this.selected_group = new ALCellStringField();
        super.initField();
    }

    @Override
    protected void loadCustomFormData(EipTSchedule record) {
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) throws ALDBErrorException {
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        return false;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        return false;
    }

    protected void setPageParam(int cnt) {
        this.start = this.rows_num * (this.current_page - 1);
        this.count = cnt;
        this.pages_num = (int)Math.ceil((double)this.count / (double)this.rows_num);
    }

    public List<FacilityResultData> getFacilities(String groupId) {
        ArrayList facilityAllList = new ArrayList();
        facilityAllList.addAll(FacilitiesUtils.getFacilityAllList());
        List facilityList = new ArrayList();
        facilityList = "all".equals(groupId) ? facilityAllList : FacilitiesUtils.getFacilityListByGroupId((String)groupId);
        int size = facilityList.size();
        this.setPageParam(size);
        int start = this.getStart();
        int rowsNum = this.getRowsNum();
        int count = -1;
        ArrayList<FacilityResultData> list = new ArrayList<FacilityResultData>();
        for (int i = 0; i < rowsNum && (count = i + start) < size; ++i) {
            list.add((FacilityResultData)facilityList.get(count));
        }
        return list;
    }

    @Override
    public List<EipMFacilityGroup> getFacilityGroupList() {
        return this.facilities;
    }

    public ALCellStringField getSelectedGroup() {
        return this.selected_group;
    }

    public int getPagesNum() {
        return this.pages_num;
    }

    public void setRowsNum(int num) {
        if (num >= 1) {
            this.rows_num = num;
        }
    }

    public int getRowsNum() {
        return this.rows_num;
    }

    public int getCurrentPage() {
        return this.current_page;
    }

    public int getStart() {
        return this.start;
    }

    public List<FacilityResultData> getFacilityAllList() {
        return this.facilityAllList;
    }

    public boolean isContains(List<FacilityResultData> facilityList, FacilityResultData rd) {
        return FacilitiesUtils.isContains(facilityList, (FacilityResultData)rd);
    }
}

