/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.schedule.ScheduleOnedayResultData;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class ScheduleOnedayContainer
implements ALData {
    private List<ScheduleOnedayResultData> list;
    private List<ScheduleOnedayResultData> dList;
    private List<ScheduleOnedayResultData> dupList;
    private int dRowCount;
    private ScheduleOnedayResultData rd;
    private int[] rows;
    private int count;
    private int dcount;
    private int rowIndex;

    public void initField() {
        this.list = new ArrayList<ScheduleOnedayResultData>();
        this.dList = new ArrayList<ScheduleOnedayResultData>();
        this.dupList = new ArrayList<ScheduleOnedayResultData>();
    }

    public void initHour(int startHour, int endHour) {
        this.rows = new int[(endHour - startHour) * 12 + 1];
        int size = this.rows.length;
        for (int i = 0; i < size; ++i) {
            this.rows[i] = 1;
        }
    }

    public void addResultData(ScheduleOnedayResultData rd, int startHour, int endHour, ALDateTimeField viewDate) {
        ScheduleOnedayResultData rd2 = new ScheduleOnedayResultData();
        rd2.setFormat("yyyy-MM-dd-HH-mm");
        rd2.initField();
        boolean dup = false;
        int sta = startHour * 12;
        int eta = endHour * 12;
        int st = Integer.parseInt(rd.getStartDate().getHour()) * 12 + Integer.parseInt(rd.getStartDate().getMinute()) / 5;
        int ed = Integer.parseInt(rd.getEndDate().getHour()) * 12 + Integer.parseInt(rd.getEndDate().getMinute()) / 5;
        if (ed - sta > 0 && eta - st > 0 || ed - sta == 0 && st == ed) {
            if (sta > st) {
                st = sta;
            }
            if (eta < ed) {
                ed = eta;
            }
            int tmpRowIndex = this.rowIndex;
            rd.setStartRow(st - sta);
            rd.setEndRow(ed - sta);
            if (ed - st == 0 && st - sta + tmpRowIndex - this.count >= 0) {
                rd.setIndex(this.rows[st - sta]);
                if (this.rows[st - sta] > 1) {
                    rd.setDuplicate(true);
                    this.list.get(this.list.size() - 1).setDuplicate(true);
                }
                int n = st - sta;
                this.rows[n] = this.rows[n] + 1;
                ++this.rowIndex;
                ++ed;
            }
            if (st - (sta -= tmpRowIndex) - this.count > 0) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(viewDate.getValue());
                cal.add(10, startHour);
                int hour = (this.count - tmpRowIndex) / 12;
                int min = (this.count - tmpRowIndex) % 12 * 5;
                cal.add(10, hour);
                cal.add(12, min);
                rd2.setStartDate(cal.getTime());
                hour = (st - sta - this.count) / 12;
                min = (st - sta - this.count) % 12 * 5;
                cal.add(10, hour);
                cal.add(12, min);
                rd2.setEndDate(cal.getTime());
                rd2.setStartRow(this.list.size() == 0 ? 0 : this.list.get(this.list.size() - 1).getEndRow());
                rd2.setEndRow(rd.getStartRow());
                this.list.add(rd2);
            } else if (st - sta - this.count != 0) {
                rd.setDuplicate(true);
                dup = true;
                this.list.get(this.list.size() - 1).setDuplicate(true);
                this.dupList.add(rd);
                this.dRowCount = this.dupList.size();
                block0: for (int i = 0; i < this.dupList.size() - 1; ++i) {
                    for (int j = i + 1; j < this.dupList.size(); ++j) {
                        if (this.dupList.get(i).getEndDateTime() <= this.dupList.get(j).getStartDateTime()) {
                            this.dupList.add(i + 1, this.dupList.get(j));
                            this.dupList.remove(j + 1);
                            --this.dRowCount;
                            continue block0;
                        }
                        if (this.dupList.get(i).getEndRow() > this.dupList.get(j).getStartRow()) continue;
                        --this.dRowCount;
                    }
                }
                this.interrupDList(rd, this.dupList, startHour, endHour, viewDate);
            }
            if (!dup) {
                this.list.add(rd);
                this.count = ed - sta;
            } else {
                rd.setdRowCount(this.dRowCount);
            }
        }
    }

    private void interrupDList(ScheduleOnedayResultData rd3, List<ScheduleOnedayResultData> dupList2, int startHour, int endHour, ALDateTimeField viewDate) {
        this.dList.clear();
        this.dcount = 0;
        int i = 0;
        int tmpRowIndex = 0;
        int dRowIndex = 0;
        int sta = startHour * 12;
        int eta = endHour * 12;
        int st = Integer.parseInt(rd3.getStartDate().getHour()) * 12 + Integer.parseInt(rd3.getStartDate().getMinute()) / 5;
        int ed = Integer.parseInt(rd3.getEndDate().getHour()) * 12 + Integer.parseInt(rd3.getEndDate().getMinute()) / 5;
        if (!rd3.getStartDate().getDay().equals(rd3.getEndDate().getDay()) && rd3.getEndDate().getHour().equals("0")) {
            ed = 288;
        }
        if (ed - sta > 0 && eta - st > 0 || ed - sta == 0 && st == ed) {
            if (sta > st) {
                st = sta;
            }
            if (eta < ed) {
                ed = eta;
            }
            tmpRowIndex = this.rowIndex;
            if (ed - st == 0 && st - sta + tmpRowIndex - this.dcount >= 0) {
                rd3.setIndex(this.rows[st - sta]);
                if (this.rows[st - sta] > 1) {
                    rd3.setDuplicate(true);
                }
                int n = st - sta;
                this.rows[n] = this.rows[n] + 1;
            }
        }
        do {
            Calendar cal;
            ScheduleOnedayResultData rd2 = new ScheduleOnedayResultData();
            rd2.setFormat("yyyy-MM-dd-HH-mm");
            rd2.initField();
            sta = startHour * 12;
            eta = endHour * 12;
            st = Integer.parseInt(dupList2.get(i).getStartDate().getHour()) * 12 + Integer.parseInt(dupList2.get(i).getStartDate().getMinute()) / 5;
            ed = Integer.parseInt(dupList2.get(i).getEndDate().getHour()) * 12 + Integer.parseInt(dupList2.get(i).getEndDate().getMinute()) / 5;
            if (!dupList2.get(i).getStartDate().getDay().equals(dupList2.get(i).getEndDate().getDay()) && dupList2.get(i).getEndDate().getHour().equals("0")) {
                ed = 288;
            }
            if ((ed - sta <= 0 || eta - st <= 0) && (ed - sta != 0 || st != ed)) continue;
            if (sta > st) {
                st = sta;
            }
            if (eta < ed) {
                ed = eta;
            }
            tmpRowIndex = dRowIndex++;
            dupList2.get(i).setStartRow(st - sta);
            dupList2.get(i).setEndRow(ed - sta);
            if (ed - st == 0 && st - sta + tmpRowIndex - this.dcount >= 0) {
                ++ed;
            }
            sta -= tmpRowIndex;
            if (i > 0) {
                if (st - sta - this.dcount > 0) {
                    cal = Calendar.getInstance();
                    cal.setTime(viewDate.getValue());
                    cal.add(10, startHour);
                    int hour = (this.dcount - tmpRowIndex) / 12;
                    int min = (this.dcount - tmpRowIndex) % 12 * 5;
                    cal.add(10, hour);
                    cal.add(12, min);
                    rd2.setStartDate(cal.getTime());
                    hour = (st - sta - this.dcount) / 12;
                    min = (st - sta - this.dcount) % 12 * 5;
                    cal.add(10, hour);
                    cal.add(12, min);
                    rd2.setEndDate(cal.getTime());
                    rd2.setStartRow(this.dList.size() == 0 ? 0 : this.dList.get(this.dList.size() - 1).getEndRow());
                    rd2.setEndRow(dupList2.get(i).getStartRow());
                    this.dList.add(rd2);
                } else if (st - sta - this.dcount != 0) {
                    int index = (endHour - startHour) * 12 + dRowIndex;
                    if (index > this.dcount) {
                        ScheduleOnedayResultData rd = new ScheduleOnedayResultData();
                        rd.setFormat("yyyy-MM-dd-HH-mm");
                        rd.initField();
                        rd.setRowspan(index - this.dcount);
                        Calendar cal2 = Calendar.getInstance();
                        cal2.setTime(viewDate.getValue());
                        cal2.add(10, startHour);
                        int hour = (this.dcount - dRowIndex) / 12;
                        int min = (this.dcount - dRowIndex) % 12 * 5;
                        cal2.add(10, hour);
                        cal2.add(12, min);
                        rd.setStartDate(cal2.getTime());
                        hour = (index - this.dcount) / 12;
                        min = (index - this.dcount) % 12 * 5;
                        cal2.add(10, hour);
                        cal2.add(12, min);
                        rd.setEndDate(cal2.getTime());
                        rd.setStartRow(this.dList.size() == 0 ? 0 : this.dList.get(this.dList.size() - 1).getEndRow());
                        rd.setEndRow(this.rows.length - 1);
                        this.dList.add(rd);
                    }
                    this.dcount = 0;
                    tmpRowIndex = dRowIndex = 0;
                    sta = startHour * 12;
                    if (st - sta - this.dcount > 0) {
                        Calendar cal3 = Calendar.getInstance();
                        cal3.setTime(viewDate.getValue());
                        cal3.add(10, startHour);
                        int hour = (this.dcount - tmpRowIndex) / 12;
                        int min = (this.dcount - tmpRowIndex) % 12 * 5;
                        cal3.add(10, hour);
                        cal3.add(12, min);
                        rd2.setStartDate(cal3.getTime());
                        hour = (st - sta - this.dcount) / 12;
                        min = (st - sta - this.dcount) % 12 * 5;
                        cal3.add(10, hour);
                        cal3.add(12, min);
                        rd2.setEndDate(cal3.getTime());
                        rd2.setStartRow(0);
                        rd2.setEndRow(dupList2.get(i).getStartRow());
                        this.dList.add(rd2);
                    }
                }
            } else if (st - sta - this.dcount > 0) {
                cal = Calendar.getInstance();
                cal.setTime(viewDate.getValue());
                cal.add(10, startHour);
                int hour = (this.dcount - tmpRowIndex) / 12;
                int min = (this.dcount - tmpRowIndex) % 12 * 5;
                cal.add(10, hour);
                cal.add(12, min);
                rd2.setStartDate(cal.getTime());
                hour = (st - sta - this.dcount) / 12;
                min = (st - sta - this.dcount) % 12 * 5;
                cal.add(10, hour);
                cal.add(12, min);
                rd2.setEndDate(cal.getTime());
                rd2.setStartRow(this.dList.size() == 0 ? 0 : this.dList.get(this.dList.size() - 1).getEndRow());
                rd2.setEndRow(dupList2.get(i).getStartRow());
                this.dList.add(rd2);
            } else if (st - sta - this.dcount != 0) {
                // empty if block
            }
            this.dcount = ed - sta;
            this.dList.add(dupList2.get(i));
        } while (++i < dupList2.size());
    }

    public void last(int startHour, int endHour, ALDateTimeField viewDate) {
        int min;
        int hour;
        Calendar cal;
        ScheduleOnedayResultData rd;
        int index = (endHour - startHour) * 12 + this.rowIndex;
        if (index > this.count) {
            rd = new ScheduleOnedayResultData();
            rd.setFormat("yyyy-MM-dd-HH-mm");
            rd.initField();
            rd.setRowspan(index - this.count);
            cal = Calendar.getInstance();
            cal.setTime(viewDate.getValue());
            cal.add(10, startHour);
            hour = (this.count - this.rowIndex) / 12;
            min = (this.count - this.rowIndex) % 12 * 5;
            cal.add(10, hour);
            cal.add(12, min);
            rd.setStartDate(cal.getTime());
            hour = (index - this.count) / 12;
            min = (index - this.count) % 12 * 5;
            cal.add(10, hour);
            cal.add(12, min);
            rd.setEndDate(cal.getTime());
            rd.setStartRow(this.list.size() == 0 ? 0 : this.list.get(this.list.size() - 1).getEndRow());
            rd.setEndRow(this.rows.length - 1);
            this.list.add(rd);
        }
        if (index > this.dcount + this.rowIndex) {
            rd = new ScheduleOnedayResultData();
            rd.setFormat("yyyy-MM-dd-HH-mm");
            rd.initField();
            rd.setRowspan(index - this.dcount);
            cal = Calendar.getInstance();
            cal.setTime(viewDate.getValue());
            cal.add(10, startHour);
            hour = (this.dcount - this.rowIndex) / 12;
            min = (this.dcount - this.rowIndex) % 12 * 5;
            cal.add(10, hour);
            cal.add(12, min);
            rd.setStartDate(cal.getTime());
            hour = (index - this.dcount) / 12;
            min = (index - this.dcount) % 12 * 5;
            cal.add(10, hour);
            cal.add(12, min);
            rd.setEndDate(cal.getTime());
            rd.setStartRow(this.dList.size() == 0 ? 0 : this.dList.get(this.dList.size() - 1).getEndRow());
            rd.setEndRow(this.rows.length - 1);
            this.dList.add(rd);
        }
    }

    public void setSpanResultData(ScheduleOnedayResultData rd) {
        this.rd = rd;
    }

    public int[] getRows() {
        return this.rows;
    }

    public ScheduleOnedayResultData getSpanResultData() {
        return this.rd;
    }

    public List<ScheduleOnedayResultData> getSchedule() {
        return this.list;
    }

    public List<ScheduleOnedayResultData> getDuplicateSchedule() {
        return this.dList;
    }

    public boolean isDuplicate() {
        return this.dList.size() != 0;
    }

    public int getDuplicateScheduleRowCount() {
        return this.dRowCount;
    }
}

