/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.cabinet.util;

import com.aimluck.eip.cabinet.FolderInfo;
import com.aimluck.eip.cayenne.om.portlet.EipTCabinetFile;
import com.aimluck.eip.cayenne.om.portlet.EipTCabinetFolder;
import com.aimluck.eip.cayenne.om.portlet.EipTCabinetFolderMap;
import com.aimluck.eip.common.ALActivity;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.services.social.ALActivityService;
import com.aimluck.eip.services.social.model.ALActivityPutRequest;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class CabinetUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CabinetUtils.class.getName());
    public static final String DATE_TIME_FORMAT = "yyyy/MM/dd HH:mm";
    public static final int ROOT_FODLER_ID = 1;
    public static final String KEY_FOLDER_ID = "folder_id";
    public static final String KEY_POST_NAME = "post_name";
    public static final String CATEGORY_KEY = JetspeedResources.getString((String)"aipo.cabinet.categorykey", (String)"");
    public static final String FOLDER_FILEDIR_CABINET = JetspeedResources.getString((String)"aipo.filedir", (String)"");
    public static final int ACCESS_PUBLIC_ALL = 0;
    public static final int ACCESS_PUBLIC_MEMBER = 1;
    public static final int ACCESS_SECRET_MEMBER = 2;
    public static final int ACCESS_SECRET_SELF = 3;
    public static final String PUBLIC_FLAG_PUBLIC_ALL = "P";
    public static final String PUBLIC_FLAG_PUBLIC_MEMBER = "E";
    public static final String PUBLIC_FLAG_SECRET_MEMBER = "S";
    public static final String PUBLIC_FLAG_SECRET_SELF = "O";
    public static final String CABINET_PORTLET_NAME = "Cabinet";
    private static final String RESET_FLAG = "reset_params";
    public static final String TARGET_KEYWORD = "keyword";

    public static EipTCabinetFolder getEipTCabinetFolder(RunData rundata, Context context) {
        String folderid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)KEY_FOLDER_ID);
        try {
            if (folderid == null || Integer.valueOf(folderid) == null) {
                logger.debug((Object)"[Cabinet Folder] Empty ID...");
                return null;
            }
            SelectQuery query = Database.query(EipTCabinetFolder.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"FOLDER_ID", (Object)folderid);
            query.setQualifier(exp);
            List folders = query.fetchList();
            if (folders == null || folders.size() == 0) {
                logger.debug((Object)"[Cabinet Folder] Not found ID...");
                return null;
            }
            return (EipTCabinetFolder)folders.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"cabinet", (Throwable)ex);
            return null;
        }
    }

    public static EipTCabinetFile getEipTCabinetFile(RunData rundata, Context context) {
        String fileid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (fileid == null || Integer.valueOf(fileid) == null) {
                logger.debug((Object)"[Cabinet File] Empty ID...");
                return null;
            }
            SelectQuery query = Database.query(EipTCabinetFile.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"FILE_ID", (Object)fileid);
            query.setQualifier(exp);
            List files = query.fetchList();
            if (files == null || files.size() == 0) {
                logger.debug((Object)"[Cabinet File] Not found ID...");
                ALEipUtils.redirectPageNotFound((RunData)rundata);
                return null;
            }
            return (EipTCabinetFile)files.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"cabinet", (Throwable)ex);
            return null;
        }
    }

    public static List<EipTCabinetFile> getEipTCabinetFileList(int folderId) {
        try {
            SelectQuery query = Database.query(EipTCabinetFile.class);
            Expression exp = ExpressionFactory.matchExp((String)"folderId", (Object)folderId);
            query.setQualifier(exp);
            List files = query.fetchList();
            if (files == null || files.size() == 0) {
                return null;
            }
            return files;
        }
        catch (Exception ex) {
            logger.error((Object)"cabinet", (Throwable)ex);
            return null;
        }
    }

    public static List<FolderInfo> getFolderList() {
        try {
            SelectQuery query = Database.query(EipTCabinetFolder.class);
            query.orderAscending("folderName");
            List list = query.fetchList();
            if (list == null || list.size() < 0) {
                return null;
            }
            ArrayList<FolderInfo> prerootlist = CabinetUtils.getEipTCabinetFolderList(list, 0, 0);
            ArrayList<FolderInfo> result = CabinetUtils.getFolderList(prerootlist);
            return result;
        }
        catch (Exception e) {
            logger.error((Object)"[CabinetUtils]", (Throwable)e);
            return null;
        }
    }

    public static ArrayList<FolderInfo> getFolderList(List<FolderInfo> list) {
        try {
            if (list == null || list.size() <= 0) {
                return null;
            }
            ArrayList<FolderInfo> res = new ArrayList<FolderInfo>();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                FolderInfo info = list.get(i);
                res.add(info);
                List<FolderInfo> infos = info.getList();
                ArrayList<FolderInfo> a = CabinetUtils.getFolderList(infos);
                if (a == null || a.size() <= 0) continue;
                res.addAll(a);
            }
            return res;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static ArrayList<FolderInfo> getEipTCabinetFolderList(List<EipTCabinetFolder> dblist, int parent_id, int hierarchy_index) {
        FolderInfo info;
        ArrayList<FolderInfo> list = new ArrayList<FolderInfo>();
        int size = dblist.size();
        for (int i = 0; i < size; ++i) {
            EipTCabinetFolder folder = dblist.get(i);
            if (folder.getParentId() != parent_id) continue;
            info = new FolderInfo();
            info.setHierarchyIndex(hierarchy_index);
            info.setFolderId(folder.getFolderId());
            info.setParentFolderId(folder.getParentId());
            info.setFolderName(folder.getFolderName());
            info.setUpdateDate(folder.getUpdateDate());
            try {
                info.setUpdateUserId(folder.getUpdateUserId().intValue());
                info.setUpdateName(ALEipUtils.getALEipUser((int)folder.getUpdateUserId()));
            }
            catch (ALDBErrorException e) {
                e.printStackTrace();
            }
            list.add(info);
        }
        if (list.size() <= 0) {
            return null;
        }
        int size2 = list.size();
        for (int i = 0; i < size2; ++i) {
            info = list.get(i);
            ArrayList<FolderInfo> colist = CabinetUtils.getEipTCabinetFolderList(dblist, info.getFolderId(), info.getHierarchyIndex() + 1);
            if (colist == null || colist.size() <= 0) continue;
            info.setList(colist);
        }
        return list;
    }

    public static void setFolderVisible(List<FolderInfo> folder_list, FolderInfo selectedinfo, RunData rundata) {
        int size;
        int i;
        if (folder_list == null || folder_list.size() <= 0) {
            return;
        }
        ArrayList<FolderInfo> list = new ArrayList<FolderInfo>();
        FolderInfo info = null;
        int hierarchy_index = 0;
        int parent_id = 0;
        for (i = size = folder_list.size() - 1; i >= 0 && hierarchy_index >= 0; --i) {
            info = folder_list.get(i);
            if (null != selectedinfo && info.getFolderId() == selectedinfo.getFolderId()) {
                info.setOpened(true);
                list.add(0, info);
                parent_id = info.getParentFolderId();
                hierarchy_index = info.getHierarchyIndex() - 1;
                continue;
            }
            if (info.getFolderId() != parent_id) continue;
            info.setOpened(true);
            list.add(0, info);
            parent_id = info.getParentFolderId();
            hierarchy_index = info.getHierarchyIndex() - 1;
        }
        size = folder_list.size();
        for (i = 0; i < size; ++i) {
            FolderInfo info1 = folder_list.get(i);
            boolean containsId = false;
            for (int j = 0; j < list.size(); ++j) {
                FolderInfo info2 = (FolderInfo)list.get(j);
                if (info1.getFolderId() == info2.getFolderId()) {
                    containsId = true;
                    break;
                }
                if (info1.getParentFolderId() != info2.getFolderId()) continue;
                containsId = true;
                break;
            }
            if (containsId) {
                info1.setVisible(true);
                continue;
            }
            info1.setVisible(false);
        }
        CabinetUtils.setFolderAuthorizedVisible(folder_list, rundata);
    }

    public static void setFolderAuthorizedVisible(List<FolderInfo> folder_list, RunData rundata) {
        int size = folder_list.size();
        ArrayList<Integer> invisible_children = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            FolderInfo info = folder_list.get(i);
            if (info.getHierarchyIndex() == 0) {
                info.setAuthorizedVisible(true);
                continue;
            }
            if (!invisible_children.contains(i)) {
                info.setAuthorizedVisible(CabinetUtils.isAccessibleFolder(info.getFolderId(), rundata));
            }
            if (info.isAuthorizedVisible()) continue;
            for (int j = 0; j < size; ++j) {
                FolderInfo info1 = folder_list.get(j);
                if (info1.getParentFolderId() != info.getFolderId()) continue;
                invisible_children.add(j);
                info1.setAuthorizedVisible(false);
            }
        }
    }

    public static String getFolderPosition(List<FolderInfo> folder_list, int folder_id) {
        int size;
        String sepa = "<b> &gt; </b>";
        StringBuffer folderpath = new StringBuffer();
        FolderInfo info = null;
        int parent_id = -1;
        for (int i = size = folder_list.size() - 1; i >= 0; --i) {
            info = folder_list.get(i);
            if (info.getFolderId() <= 1) {
                folderpath.insert(0, info.getFolderName());
                break;
            }
            if (info.getFolderId() == folder_id) {
                folderpath.append(sepa);
                folderpath.append(info.getFolderName());
                parent_id = info.getParentFolderId();
                continue;
            }
            if (info.getFolderId() != parent_id) continue;
            folderpath.insert(0, info.getFolderName());
            folderpath.insert(0, sepa);
            parent_id = info.getParentFolderId();
        }
        return folderpath.toString();
    }

    public static FolderInfo getSelectedFolderInfo(List<FolderInfo> list, int folder_id) {
        FolderInfo selected_folderinfo = null;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            FolderInfo info = list.get(i);
            if (info.getFolderId() != folder_id) continue;
            selected_folderinfo = info;
            break;
        }
        return selected_folderinfo;
    }

    public static String getSaveDirPath(String orgId) {
        return ALStorageService.getDocumentPath((String)FOLDER_FILEDIR_CABINET, (String)CATEGORY_KEY);
    }

    public static String getRelativePath(String fileName) {
        return new StringBuffer().append("/").append(fileName).toString();
    }

    public static boolean isAccessibleFolder(int folder_id, RunData rundata) {
        EipTCabinetFolder folder = CabinetUtils.getFolderByPK(folder_id);
        int public_flag = Integer.valueOf(folder.getPublicFlag());
        int current_user_id = ALEipUtils.getUserId((RunData)rundata);
        if (folder.getParentId() == 1 || folder.getFolderId() == 1) {
            if (public_flag == 0 || public_flag == 1) {
                return true;
            }
            if (public_flag == 3) {
                if (folder.getCreateUserId() == current_user_id) {
                    return true;
                }
            } else {
                SelectQuery query = Database.query(EipTCabinetFolderMap.class);
                Expression exp1 = ExpressionFactory.matchDbExp((String)"eipTCabinetFolder", (Object)folder);
                Expression exp2 = ExpressionFactory.matchExp((String)"userId", (Object)current_user_id);
                query.setQualifier(exp1);
                query.andQualifier(exp2);
                List list = query.fetchList();
                if (list != null && list.size() != 0) {
                    return true;
                }
            }
            return false;
        }
        if (public_flag == 0) {
            return CabinetUtils.isAccessibleFolder(folder.getParentId(), rundata);
        }
        if (public_flag == 1) {
            return CabinetUtils.isAccessibleFolder(folder.getParentId(), rundata);
        }
        if (public_flag == 3) {
            if (folder.getCreateUserId() == current_user_id) {
                return CabinetUtils.isAccessibleFolder(folder.getParentId(), rundata);
            }
        } else {
            SelectQuery query = Database.query(EipTCabinetFolderMap.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"eipTCabinetFolder", (Object)folder);
            Expression exp2 = ExpressionFactory.matchExp((String)"userId", (Object)current_user_id);
            query.setQualifier(exp1);
            query.andQualifier(exp2);
            List list = query.fetchList();
            if (list != null && list.size() != 0) {
                return CabinetUtils.isAccessibleFolder(folder.getParentId(), rundata);
            }
        }
        return false;
    }

    public static boolean isEditableFolder(int folder_id, RunData rundata) {
        int current_user_id = ALEipUtils.getUserId((RunData)rundata);
        EipTCabinetFolder folder = CabinetUtils.getFolderByPK(folder_id);
        int public_flag = Integer.valueOf(folder.getPublicFlag());
        if (folder.getParentId() == 1 || folder.getFolderId() == 1) {
            if (public_flag == 0) {
                return true;
            }
            if (public_flag == 3) {
                if (folder.getCreateUserId() == current_user_id) {
                    return true;
                }
            } else {
                SelectQuery query = Database.query(EipTCabinetFolderMap.class);
                Expression exp1 = ExpressionFactory.matchDbExp((String)"eipTCabinetFolder", (Object)folder);
                Expression exp2 = ExpressionFactory.matchExp((String)"userId", (Object)current_user_id);
                query.setQualifier(exp1);
                query.andQualifier(exp2);
                List list = query.fetchList();
                if (list != null && list.size() != 0) {
                    return true;
                }
            }
            return false;
        }
        if (public_flag == 0) {
            return CabinetUtils.isEditableFolder(folder.getParentId(), rundata);
        }
        if (public_flag == 3) {
            if (folder.getCreateUserId() == current_user_id) {
                return CabinetUtils.isEditableFolder(folder.getParentId(), rundata);
            }
        } else {
            SelectQuery query = Database.query(EipTCabinetFolderMap.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"eipTCabinetFolder", (Object)folder);
            Expression exp2 = ExpressionFactory.matchExp((String)"userId", (Object)current_user_id);
            query.setQualifier(exp1);
            query.andQualifier(exp2);
            List list = query.fetchList();
            if (list != null && list.size() != 0) {
                return CabinetUtils.isEditableFolder(folder.getParentId(), rundata);
            }
        }
        return false;
    }

    public static void setFolderVisibleForForm(List<FolderInfo> folder_list, RunData rundata) {
        int size = folder_list.size();
        ArrayList<Integer> invisible_children = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            FolderInfo info = folder_list.get(i);
            if (info.getHierarchyIndex() == 0) {
                info.setAuthorizedVisible(true);
                continue;
            }
            if (!invisible_children.contains(i)) {
                info.setAuthorizedVisible(CabinetUtils.isEditableFolder(info.getFolderId(), rundata));
            }
            if (info.isAuthorizedVisible()) continue;
            for (int j = 0; j < size; ++j) {
                FolderInfo info1 = folder_list.get(j);
                if (info1.getParentFolderId() != info.getFolderId()) continue;
                invisible_children.add(j);
                info1.setAuthorizedVisible(false);
            }
        }
    }

    public static List<Integer> getAuthorizedVisibleFolderIds(RunData rundata) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        List<FolderInfo> list = CabinetUtils.getFolderList();
        CabinetUtils.setFolderAuthorizedVisible(list, rundata);
        for (int i = 0; i < list.size(); ++i) {
            FolderInfo folder = list.get(i);
            if (!folder.isAuthorizedVisible()) continue;
            ids.add(folder.getFolderId());
        }
        return ids;
    }

    public static Integer getAccessControlFolderId(Integer parentId) {
        if (parentId == 1) {
            return 1;
        }
        EipTCabinetFolder folder = CabinetUtils.getFolderByPK(parentId);
        if (Integer.valueOf(folder.getPublicFlag()) == 0) {
            return CabinetUtils.getAccessControlFolderId(folder.getParentId());
        }
        return folder.getFolderId();
    }

    public static List<EipTCabinetFolder> getChildFolders(EipTCabinetFolder folder) {
        ArrayList<EipTCabinetFolder> list = new ArrayList<EipTCabinetFolder>();
        List<EipTCabinetFolder> children = CabinetUtils.getChildren(folder.getFolderId());
        ArrayList<EipTCabinetFolder> children_tmp = new ArrayList<EipTCabinetFolder>();
        list.addAll(children);
        int add_count = children.size();
        while (add_count > 0) {
            add_count = 0;
            for (int i = 0; i < children.size(); ++i) {
                children_tmp.addAll(CabinetUtils.getChildren(children.get(i).getFolderId()));
            }
            add_count = children_tmp.size();
            children.clear();
            children.addAll(children_tmp);
            list.addAll(children_tmp);
            children_tmp.clear();
        }
        return list;
    }

    public static List<EipTCabinetFolder> getChildren(int parent_id) {
        SelectQuery query = Database.query(EipTCabinetFolder.class);
        Expression pk_exp = ExpressionFactory.matchExp((String)"parentId", (Object)parent_id);
        query.setQualifier(pk_exp);
        List list = query.fetchList();
        return list;
    }

    public static EipTCabinetFolder getFolderByPK(Integer folder_id) {
        SelectQuery query = Database.query(EipTCabinetFolder.class);
        Expression pk_exp = ExpressionFactory.matchDbExp((String)"FOLDER_ID", (Object)folder_id);
        query.setQualifier(pk_exp);
        List list = query.fetchList();
        EipTCabinetFolder folder = (EipTCabinetFolder)list.get(0);
        return folder;
    }

    public static void createCabinetActivity(EipTCabinetFile file, String loginName, List<String> recipients, boolean isNew) {
        ALActivity RecentActivity = ALActivity.getRecentActivity((String)CABINET_PORTLET_NAME, (int)file.getFileId(), (float)0.0f);
        boolean isDeletePrev = RecentActivity != null && RecentActivity.isReplace(loginName);
        String title = "\u30d5\u30a1\u30a4\u30eb\u300c" + file.getFileTitle() + "\u300d\u3092" + (isNew ? "\u8ffd\u52a0\u3057\u307e\u3057\u305f\u3002" : "\u7de8\u96c6\u3057\u307e\u3057\u305f\u3002");
        String portletParams = "?template=CabinetFileDetailScreen" + "&entityid=" + file.getFileId();
        if (recipients != null && recipients.size() > 0) {
            ALActivityService.create((ALActivityPutRequest)new ALActivityPutRequest().withAppId(CABINET_PORTLET_NAME).withLoginName(loginName).withPortletParams(portletParams).withRecipients(recipients).withTitle(title).withUserId(file.getUpdateUserId().intValue()).withPriority(0.0f).withExternalId(String.valueOf(file.getFileId())));
        } else {
            ALActivityService.create((ALActivityPutRequest)new ALActivityPutRequest().withAppId(CABINET_PORTLET_NAME).withLoginName(loginName).withPortletParams(portletParams).withTitle(title).withUserId(file.getUpdateUserId().intValue()).withPriority(0.0f).withExternalId(String.valueOf(file.getFileId())));
        }
        if (isDeletePrev) {
            RecentActivity.delete();
        }
    }

    public static List<Integer> getWhatsNewInsertList(RunData rundata, int folderid, String is_public) throws ALPageNotFoundException, ALDBErrorException {
        int userid = ALEipUtils.getUserId((RunData)rundata);
        ArrayList<ALEipUser> result = new ArrayList<ALEipUser>();
        if ("0".equals(is_public) || "1".equals(is_public)) {
            ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
            ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
            List userIds = aclhandler.getAcceptUserIdsExceptLoginUser(ALEipUtils.getUserId((RunData)rundata), "msgboard_topic", 2);
            return userIds;
        }
        if ("2".equals(is_public)) {
            try {
                SelectQuery query = Database.query(EipTCabinetFolderMap.class);
                query.select("USER_ID");
                Expression exp1 = ExpressionFactory.matchExp((String)"folderId", (Object)folderid);
                query.setQualifier(exp1);
                List uids = query.fetchList();
                ArrayList<Integer> userIds = new ArrayList<Integer>();
                if (uids != null && uids.size() != 0) {
                    int size = uids.size();
                    for (int i = 0; i < size; ++i) {
                        EipTCabinetFolderMap uid = (EipTCabinetFolderMap)uids.get(i);
                        Integer id = uid.getUserId();
                        if (id == userid) continue;
                        result.add(ALEipUtils.getALEipUser((int)id));
                        userIds.add((int)id);
                    }
                }
                return userIds;
            }
            catch (Exception ex) {
                logger.error((Object)"[CabinetUtils]", (Throwable)ex);
                throw new ALDBErrorException();
            }
        }
        return null;
    }

    public static boolean hasResetFlag(RunData rundata, Context context) {
        String resetflag = rundata.getParameters().getString(RESET_FLAG);
        return resetflag != null;
    }

    public static void resetFilter(RunData rundata, Context context, String className) {
        ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)new StringBuffer().append(className).append("filter").toString());
        ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)new StringBuffer().append(className).append("filtertype").toString());
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_KEYWORD, (String)"");
    }

    public static String getTargetKeyword(RunData rundata, Context context) {
        String target_keyword = null;
        String keywordParam = rundata.getParameters().getString(TARGET_KEYWORD);
        target_keyword = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)TARGET_KEYWORD);
        if (keywordParam == null && target_keyword == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_KEYWORD, (String)"");
            target_keyword = "";
        } else if (keywordParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_KEYWORD, (String)keywordParam.trim());
            target_keyword = keywordParam;
        }
        return target_keyword;
    }
}

