/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.screens;

import com.aimluck.eip.cabinet.util.CabinetUtils;
import com.aimluck.eip.cayenne.om.portlet.EipTCabinetFile;
import com.aimluck.eip.cayenne.om.portlet.EipTCabinetFolder;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.modules.screens.FileuploadRawScreen;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;

public class CabinetFileRawScreen
extends FileuploadRawScreen {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CabinetFileRawScreen.class.getName());
    private EipTCabinetFolder cabinetfolder;

    protected String getContentType(RunData rundata) {
        return "application/octet-stream";
    }

    protected void doOutput(RunData rundata) throws Exception {
        try {
            this.doCheckAclPermission(rundata, "cabinet_file", 1);
        }
        catch (ALPermissionException e) {
            throw new Exception();
        }
        try {
            int fileindex = rundata.getParameters().getInt("entityid");
            EipTCabinetFile cabinetfile = (EipTCabinetFile)Database.get(EipTCabinetFile.class, (Object)fileindex);
            if (cabinetfile != null) {
                this.doFileCheckView(rundata, cabinetfile);
                super.setFilePath(CabinetUtils.getSaveDirPath(Database.getDomainName()) + cabinetfile.getFilePath());
                super.setFileName(cabinetfile.getFileName());
                super.doOutput(rundata);
                cabinetfile.setCounter(Integer.valueOf(cabinetfile.getCounter() + 1));
                Database.commit();
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(cabinetfile.getFileId().intValue(), 220, cabinetfile.getFileTitle() + "  (" + cabinetfile.getFileName() + ")", "download");
            }
        }
        catch (ALPermissionException e) {
            throw new Exception();
        }
        catch (Exception e) {
            Database.rollback();
            logger.error((Object)"CabinetFileRawScreen.doOutput", (Throwable)e);
        }
    }

    private boolean doFileCheckView(RunData rundata, EipTCabinetFile cabinetfile) throws ALPermissionException {
        this.cabinetfolder = cabinetfile.getEipTCabinetFolder();
        if (CabinetUtils.isAccessibleFolder(this.cabinetfolder.getFolderId(), rundata)) {
            return true;
        }
        throw new ALPermissionException();
    }
}

