/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.msgboard;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardCategoryMap;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardFile;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardTopic;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALFileNotRemovedException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.fileupload.beans.FileuploadLiteBean;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.msgboard.MsgboardCategoryResultData;
import com.aimluck.eip.msgboard.util.MsgboardUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.timeline.util.TimelineUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class MsgboardTopicFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)MsgboardTopicFormData.class.getName());
    private ALStringField topic_name;
    private ALNumberField category_id;
    private ALStringField category_name;
    private ALStringField note;
    private List<MsgboardCategoryResultData> categoryList;
    private boolean is_new_category;
    private List<FileuploadLiteBean> fileuploadList = null;
    private String folderName = null;
    private int uid;
    private EipTMsgboardCategory category;
    private String orgId;
    private String aclPortletFeature = null;
    private boolean hasAclCategoryList;
    private boolean hasAclUpdateTopicOthers;
    private boolean hasAclDeleteTopicOthers;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.is_new_category = rundata.getParameters().getBoolean("is_new_category");
        this.uid = ALEipUtils.getUserId((RunData)rundata);
        this.orgId = Database.getDomainName();
        this.folderName = rundata.getParameters().getString("folderName");
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        this.hasAclCategoryList = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "msgboard_category", 1);
        this.hasAclDeleteTopicOthers = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "msgboard_topic_other", 16);
        this.hasAclUpdateTopicOthers = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "msgboard_topic_other", 8);
    }

    public void initField() {
        this.topic_name = new ALStringField();
        this.topic_name.setFieldName(ALLocalizationUtils.getl10n((String)"MSGBOARD_TITLE"));
        this.topic_name.setTrim(true);
        this.category_id = new ALNumberField();
        this.category_id.setFieldName(ALLocalizationUtils.getl10n((String)"MSGBOARD_PORTLET_CATEGORY"));
        this.category_name = new ALStringField();
        this.category_name.setFieldName(ALLocalizationUtils.getl10n((String)"MSGBOARD_CATEGORY_NAME"));
        this.note = new ALStringField();
        this.note.setFieldName(ALLocalizationUtils.getl10n((String)"MSGBOARD_NOTE"));
        this.note.setTrim(false);
        this.fileuploadList = new ArrayList<FileuploadLiteBean>();
        this.aclPortletFeature = "msgboard_topic";
    }

    public void loadCategoryList(RunData rundata, Context context) {
        this.categoryList = MsgboardUtils.loadCategoryList(rundata);
    }

    protected void setValidator() {
        this.topic_name.setNotNull(true);
        this.topic_name.limitMaxLength(50);
        this.note.setNotNull(true);
        this.note.limitMaxLength(10000);
        if (this.is_new_category) {
            this.category_name.setNotNull(true);
            this.category_name.limitMaxLength(50);
        }
    }

    protected boolean validate(List<String> msgList) {
        this.topic_name.validate(msgList);
        this.note.validate(msgList);
        if (this.is_new_category) {
            this.category_name.validate(msgList);
        }
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTMsgboardTopic topic = MsgboardUtils.getEipTMsgboardParentTopic(rundata, context, false);
            this.topic_name.setValue(topic.getTopicName());
            this.category_id.setValue((long)topic.getEipTMsgboardCategory().getCategoryId().intValue());
            this.note.setValue(topic.getNote());
            SelectQuery query = Database.query(EipTMsgboardFile.class);
            query.andQualifier(ExpressionFactory.matchDbExp((String)"eipTMsgboardTopic", (Object)topic.getTopicId()));
            List msgboardFileList = query.fetchList();
            for (EipTMsgboardFile file : msgboardFileList) {
                FileuploadLiteBean fbean = new FileuploadLiteBean();
                fbean.initField();
                fbean.setFileId(file.getFileId().intValue());
                fbean.setFileName(file.getFileName());
                this.fileuploadList.add(fbean);
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)"msgboard", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            int parentid = Integer.parseInt(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid"));
            EipTMsgboardTopic parent = (EipTMsgboardTopic)Database.get(EipTMsgboardTopic.class, (Object)parentid);
            List<EipTMsgboardTopic> list = this.hasAclDeleteTopicOthers ? MsgboardUtils.getEipTMsgboardTopicListToDeleteTopic(rundata, context, true) : MsgboardUtils.getEipTMsgboardTopicListToDeleteTopic(rundata, context, false);
            if (list == null) {
                logger.debug((Object)"[MsgboardTopicFormData] Not found List...");
                throw new ALPageNotFoundException();
            }
            ArrayList<Integer> topicIdList = new ArrayList<Integer>();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                EipTMsgboardTopic topic = list.get(i);
                topicIdList.add(topic.getTopicId());
            }
            SelectQuery query = Database.query(EipTMsgboardTopic.class);
            Expression exp = ExpressionFactory.inDbExp((String)"TOPIC_ID", topicIdList);
            query.setQualifier(exp);
            List topics = query.fetchList();
            ArrayList<String> fpaths = new ArrayList<String>();
            if (topics.size() > 0) {
                int tsize = topics.size();
                for (int i = 0; i < tsize; ++i) {
                    List files = ((EipTMsgboardTopic)topics.get(i)).getEipTMsgboardFileArray();
                    if (files == null || files.size() <= 0) continue;
                    int fsize = files.size();
                    for (int j = 0; j < fsize; ++j) {
                        fpaths.add(((EipTMsgboardFile)files.get(j)).getFilePath());
                    }
                    MsgboardUtils.deleteFiles(((EipTMsgboardTopic)topics.get(i)).getTopicId(), this.orgId, ((EipTMsgboardTopic)topics.get(i)).getOwnerId(), fpaths);
                }
            }
            Database.deleteAll((List)topics);
            Database.commit();
            TimelineUtils.deleteTimelineActivity((RunData)rundata, (Context)context, (String)"Msgboard", (String)parent.getTopicId().toString());
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(parent.getTopicId().intValue(), 180, parent.getTopicName());
        }
        catch (ALFileNotRemovedException fe) {
            Database.rollback();
            logger.error((Object)"[MsgboardCategorySelectData]", (Throwable)fe);
            msgList.add(ALLocalizationUtils.getl10n((String)"ERROR_FILE_DETELE_FAILURE"));
            return false;
        }
        catch (RuntimeException e) {
            Database.rollback();
            logger.error((Object)"[MsgboardCategorySelectData]", (Throwable)e);
            throw new ALDBErrorException();
        }
        catch (Exception e) {
            Database.rollback();
            logger.error((Object)"[MsgboardCategorySelectData]", (Throwable)e);
            throw new ALDBErrorException();
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            if (this.is_new_category) {
                if (!this.insertCategoryData(rundata, context, msgList)) {
                    return false;
                }
            } else {
                this.category = (EipTMsgboardCategory)Database.get(EipTMsgboardCategory.class, (Object)((int)this.category_id.getValue()));
            }
            EipTMsgboardTopic topic = (EipTMsgboardTopic)Database.create(EipTMsgboardTopic.class);
            topic.setTopicName(this.topic_name.getValue());
            topic.setParentId(Integer.valueOf(0));
            topic.setEipTMsgboardCategory(this.category);
            topic.setOwnerId(Integer.valueOf(this.uid));
            topic.setNote(this.note.getValue());
            topic.setCreateUserId(Integer.valueOf(this.uid));
            topic.setUpdateUserId(Integer.valueOf(this.uid));
            topic.setCreateDate(Calendar.getInstance().getTime());
            topic.setUpdateDate(Calendar.getInstance().getTime());
            if (!MsgboardUtils.insertFileDataDelegate(rundata, context, topic, this.fileuploadList, this.folderName, msgList)) {
                return false;
            }
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(topic.getTopicId().intValue(), 180, topic.getTopicName());
            if ("T".equals(topic.getEipTMsgboardCategory().getPublicFlag())) {
                ALEipUser user = ALEipUtils.getALEipUser((int)this.uid);
                MsgboardUtils.createTopicActivity(topic, user.getName().getValue(), true);
            } else {
                List<Integer> userIds = MsgboardUtils.getWhatsNewInsertList(rundata, this.category.getCategoryId(), this.category.getPublicFlag());
                ArrayList<String> recipients = new ArrayList<String>();
                int u_size = userIds.size();
                for (int i = 0; i < u_size; ++i) {
                    Integer _id = userIds.get(i);
                    ALEipUser user = ALEipUtils.getALEipUser((int)_id);
                    if (user == null) continue;
                    recipients.add(user.getName().getValue());
                }
                if (recipients.size() > 0) {
                    ALEipUser user = ALEipUtils.getALEipUser((int)this.uid);
                    MsgboardUtils.createTopicActivity(topic, user.getName().getValue(), recipients, true);
                }
            }
            ALStorageService.deleteTmpFolder((int)this.uid, (String)this.folderName);
        }
        catch (RuntimeException ex) {
            Database.rollback();
            throw ex;
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"msgboard", (Throwable)ex);
            return false;
        }
        return true;
    }

    private boolean insertCategoryData(RunData rundata, Context context, List<String> msgList) {
        try {
            this.setAclPortletFeature("msgboard_category");
            this.doCheckAclPermission(rundata, context, 4);
            this.setAclPortletFeature("msgboard_topic");
            int userid = ALEipUtils.getUserId((RunData)rundata);
            TurbineUser tuser = (TurbineUser)Database.get(TurbineUser.class, (Object)userid);
            this.category = (EipTMsgboardCategory)Database.create(EipTMsgboardCategory.class);
            this.category.setCategoryName(this.category_name.getValue());
            this.category.setPublicFlag("T");
            this.category.setNote("");
            this.category.setTurbineUser(tuser);
            this.category.setCreateDate(Calendar.getInstance().getTime());
            this.category.setUpdateDate(Calendar.getInstance().getTime());
            EipTMsgboardCategoryMap map = (EipTMsgboardCategoryMap)Database.create(EipTMsgboardCategoryMap.class);
            map.setEipTMsgboardCategory(this.category);
            map.setUserId(Integer.valueOf(userid));
            map.setStatus("A");
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(this.category.getCategoryId().intValue(), 181, this.category.getCategoryName());
        }
        catch (ALPermissionException e) {
            msgList.add("\u30a2\u30af\u30bb\u30b9\u6a29\u9650\u304c\u3042\u308a\u307e\u305b\u3093\u3002\u30b7\u30b9\u30c6\u30e0\u7ba1\u7406\u8005\u306b\u304a\u554f\u3044\u5408\u308f\u305b\u304f\u3060\u3055\u3044\u3002");
            return false;
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"msgboard", (Throwable)ex);
            msgList.add("\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002");
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            if (this.is_new_category) {
                if (!this.insertCategoryData(rundata, context, msgList)) {
                    return false;
                }
            } else {
                this.category = (EipTMsgboardCategory)Database.get(EipTMsgboardCategory.class, (Object)((int)this.category_id.getValue()));
            }
            EipTMsgboardTopic topic = MsgboardUtils.getEipTMsgboardParentTopic(rundata, context, false);
            topic.setTopicName(this.topic_name.getValue());
            topic.setEipTMsgboardCategory(this.category);
            topic.setNote(this.note.getValue());
            topic.setUpdateUserId(Integer.valueOf(this.uid));
            topic.setUpdateDate(Calendar.getInstance().getTime());
            if (!MsgboardUtils.insertFileDataDelegate(rundata, context, topic, this.fileuploadList, this.folderName, msgList)) {
                return false;
            }
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(topic.getTopicId().intValue(), 180, topic.getTopicName());
            if ("T".equals(topic.getEipTMsgboardCategory().getPublicFlag())) {
                ALEipUser user = ALEipUtils.getALEipUser((int)this.uid);
                MsgboardUtils.createTopicActivity(topic, user.getName().getValue(), false);
            } else {
                List<Integer> userIds = MsgboardUtils.getWhatsNewInsertList(rundata, this.category.getCategoryId(), this.category.getPublicFlag());
                ArrayList<String> recipients = new ArrayList<String>();
                int u_size = userIds.size();
                for (int i = 0; i < u_size; ++i) {
                    Integer _id = userIds.get(i);
                    ALEipUser user = ALEipUtils.getALEipUser((int)_id);
                    if (user == null) continue;
                    recipients.add(user.getName().getValue());
                }
                if (recipients.size() > 0) {
                    ALEipUser user = ALEipUtils.getALEipUser((int)this.uid);
                    MsgboardUtils.createTopicActivity(topic, user.getName().getValue(), recipients, false);
                }
            }
            ALStorageService.deleteTmpFolder((int)this.uid, (String)this.folderName);
        }
        catch (RuntimeException ex) {
            Database.rollback();
            throw ex;
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"msgboard", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        try {
            this.fileuploadList = MsgboardUtils.getFileuploadList(rundata);
        }
        catch (Exception ex) {
            logger.error((Object)"msgboard", (Throwable)ex);
        }
        return res;
    }

    public ALNumberField getCategoryId() {
        return this.category_id;
    }

    public ALStringField getNote() {
        return this.note;
    }

    public ALStringField getTopicName() {
        return this.topic_name;
    }

    public List<MsgboardCategoryResultData> getCategoryList() {
        return this.categoryList;
    }

    public boolean isNewCategory() {
        return this.is_new_category;
    }

    public void setIsNewCategory(boolean bool) {
        this.is_new_category = bool;
    }

    public ALStringField getCategoryName() {
        return this.category_name;
    }

    public List<FileuploadLiteBean> getAttachmentFileNameList() {
        return this.fileuploadList;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public String getAclPortletFeature() {
        return this.aclPortletFeature;
    }

    public void setAclPortletFeature(String aclPortletFeature) {
        this.aclPortletFeature = aclPortletFeature;
    }

    public boolean hasAclUpdateTopicOthers() {
        return this.hasAclUpdateTopicOthers;
    }

    public boolean hasAclDeleteTopicOthers() {
        return this.hasAclDeleteTopicOthers;
    }
}

