/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.types;

import java.io.Serializable;
import java.util.Date;
import org.exolab.castor.types.Duration;
import org.exolab.castor.types.GDay;
import org.exolab.castor.types.GMonth;
import org.exolab.castor.types.GMonthDay;
import org.exolab.castor.types.GYear;
import org.exolab.castor.types.GYearMonth;
import org.exolab.castor.types.OperationNotSupportedException;
import org.exolab.castor.types.Time;

public abstract class DateTimeBase
implements Serializable {
    private short _century = 0;
    private short _year = 0;
    private short _month = 0;
    private short _day = 0;
    private short _hour = 0;
    private short _minute = 0;
    private short _second = 0;
    private short _millsecond = 0;
    private short _zoneHour = 0;
    private short _zoneMinute = 0;
    private boolean _UTC = false;
    private boolean _zoneNegative = false;
    private boolean _isNegative = false;
    public static final int INDETERMINATE = -1;
    public static final int LESS_THAN = 0;
    public static final int EQUALS = 1;
    public static final int GREATER_THAN = 2;

    /*
     * Unable to fully structure code
     */
    public void addDuration(Duration var1_1) {
        block22: {
            block21: {
                block20: {
                    block19: {
                        block18: {
                            block17: {
                                var2_2 = 0;
                                var3_3 = 0;
                                var4_4 = var1_1.isNegative() != false ? -1 : 1;
                                try {
                                    var2_2 = this._month + var4_4 * var1_1.getMonth();
                                    var3_3 = this.fQuotient(var2_2 - 1, 12);
                                    var2_2 = this.modulo(var2_2 - 1, 12) + 1;
                                    this.setMonth((short)var2_2);
                                }
                                catch (OperationNotSupportedException var5_5) {
                                    if (this instanceof Time || this instanceof GYear || this instanceof GDay) break block17;
                                    throw var5_5;
                                }
                            }
                            try {
                                var2_2 = this._century * 100 + this._year + var4_4 * var1_1.getYear() + var3_3;
                                var5_6 = (short)(var2_2 / 100);
                                this.setCentury(var5_6);
                                this.setYear((short)(var2_2 %= 100));
                            }
                            catch (OperationNotSupportedException var5_7) {
                                if (this instanceof Time || this instanceof GMonthDay) break block18;
                                throw var5_7;
                            }
                        }
                        try {
                            var2_2 = this._second + var4_4 * var1_1.getSeconds();
                            var3_3 = this.fQuotient(var2_2, 60);
                            var2_2 = this.modulo(var2_2, 60);
                            this.setSecond((short)var2_2, this.getMilli());
                        }
                        catch (OperationNotSupportedException var5_8) {
                            if (!(this instanceof Time)) break block19;
                            throw var5_8;
                        }
                    }
                    try {
                        var2_2 = this._minute + var4_4 * var1_1.getMinute() + var3_3;
                        var3_3 = this.fQuotient(var2_2, 60);
                        var2_2 = this.modulo(var2_2, 60);
                        this.setMinute((short)var2_2);
                    }
                    catch (OperationNotSupportedException var5_9) {
                        if (!(this instanceof Time)) break block20;
                        throw var5_9;
                    }
                }
                try {
                    var2_2 = this._hour + var4_4 * var1_1.getHour();
                    var3_3 = this.fQuotient(var2_2, 24);
                    var2_2 = this.modulo(var2_2, 24);
                    this.setHour((short)var2_2);
                }
                catch (OperationNotSupportedException var5_10) {
                    if (!(this instanceof Time)) break block21;
                    throw var5_10;
                }
            }
            try {
                var5_11 = this.maxDayInMonthFor(this._century, this._year, this._month);
                var6_13 = this._day > var5_11 ? var5_11 : this._day;
                var6_13 = var6_13 + var4_4 * var1_1.getDay() + var3_3;
                while (true) lbl-1000:
                // 3 sources

                {
                    if (var6_13 < 1) {
                        var6_13 = (short)(var6_13 + this.maxDayInMonthFor(this._century, this._year, this._month - 1));
                        this.setDay((short)var6_13);
                        var3_3 = -1;
                    } else {
                        if (var6_13 <= var5_11) break block22;
                        var6_13 = (short)(var6_13 - (short)var5_11);
                        this.setDay((short)var6_13);
                        var3_3 = 1;
                    }
                    try {
                        var2_2 = this._month + var3_3;
                        this.setMonth((short)(this.modulo(var2_2 - 1, 12) + 1));
                        var2_2 = this.fQuotient(var2_2 - 1, 12);
                        var2_2 = this.getCentury() * 100 + this.getYear() + var2_2;
                        var7_14 = (short)(var2_2 / 100);
                        this.setCentury(var7_14);
                        this.setYear((short)(var2_2 %= 100));
                    }
                    catch (OperationNotSupportedException var7_15) {
                        if (!(this instanceof Time) && !(this instanceof GMonthDay)) ** break;
                        continue;
                        throw var7_15;
                    }
                    break;
                }
            }
            catch (OperationNotSupportedException var5_12) {
                if (this instanceof Time || this instanceof GYearMonth || this instanceof GMonth) break block22;
                throw var5_12;
            }
            ** GOTO lbl-1000
        }
    }

    private static int compareFields(DateTimeBase dateTimeBase, DateTimeBase dateTimeBase2) {
        int n = -1;
        int n2 = -1;
        try {
            n = dateTimeBase.getCentury();
        }
        catch (OperationNotSupportedException operationNotSupportedException) {}
        try {
            n2 = dateTimeBase2.getCentury();
        }
        catch (OperationNotSupportedException operationNotSupportedException) {}
        if (n * n2 < 0) {
            return -1;
        }
        if (n < n2) {
            return 0;
        }
        if (n > n2) {
            return 2;
        }
        try {
            n = dateTimeBase.getYear();
        }
        catch (OperationNotSupportedException operationNotSupportedException) {}
        try {
            n2 = dateTimeBase2.getYear();
        }
        catch (OperationNotSupportedException operationNotSupportedException) {}
        if (n * n2 < 0) {
            return -1;
        }
        if (n < n2) {
            return 0;
        }
        if (n > n2) {
            return 2;
        }
        try {
            n = dateTimeBase.getMonth();
        }
        catch (OperationNotSupportedException operationNotSupportedException) {}
        try {
            n2 = dateTimeBase2.getMonth();
        }
        catch (OperationNotSupportedException operationNotSupportedException) {}
        if (n * n2 < 0) {
            return -1;
        }
        if (n < n2) {
            return 0;
        }
        if (n > n2) {
            return 2;
        }
        try {
            n = dateTimeBase.getDay();
        }
        catch (OperationNotSupportedException operationNotSupportedException) {}
        try {
            n2 = dateTimeBase2.getDay();
        }
        catch (OperationNotSupportedException operationNotSupportedException) {}
        if (n * n2 < 0) {
            return -1;
        }
        if (n < n2) {
            return 0;
        }
        if (n > n2) {
            return 2;
        }
        try {
            n = dateTimeBase.getHour();
        }
        catch (OperationNotSupportedException operationNotSupportedException) {}
        try {
            n2 = dateTimeBase2.getHour();
        }
        catch (OperationNotSupportedException operationNotSupportedException) {}
        if (n * n2 < 0) {
            return -1;
        }
        if (n < n2) {
            return 0;
        }
        if (n > n2) {
            return 2;
        }
        try {
            n = dateTimeBase.getMinute();
        }
        catch (OperationNotSupportedException operationNotSupportedException) {}
        try {
            n2 = dateTimeBase2.getMinute();
        }
        catch (OperationNotSupportedException operationNotSupportedException) {}
        if (n * n2 < 0) {
            return -1;
        }
        if (n < n2) {
            return 0;
        }
        if (n > n2) {
            return 2;
        }
        try {
            n = dateTimeBase.getSeconds();
        }
        catch (OperationNotSupportedException operationNotSupportedException) {}
        try {
            n2 = dateTimeBase2.getSeconds();
        }
        catch (OperationNotSupportedException operationNotSupportedException) {}
        if (n * n2 < 0) {
            return -1;
        }
        if (n < n2) {
            return 0;
        }
        if (n > n2) {
            return 2;
        }
        try {
            n = dateTimeBase.getMilli();
        }
        catch (OperationNotSupportedException operationNotSupportedException) {}
        try {
            n2 = dateTimeBase2.getMilli();
        }
        catch (OperationNotSupportedException operationNotSupportedException) {}
        if (n * n2 < 0) {
            return -1;
        }
        if (n < n2) {
            return 0;
        }
        if (n > n2) {
            return 2;
        }
        return 1;
    }

    public int compareTo(DateTimeBase dateTimeBase) {
        if (dateTimeBase == null) {
            throw new IllegalArgumentException("a Date/Time datatype cannot be compared with a null value");
        }
        DateTimeBase dateTimeBase2 = this;
        DateTimeBase dateTimeBase3 = dateTimeBase;
        if (dateTimeBase2.isUTC()) {
            dateTimeBase2.normalize();
        }
        if (dateTimeBase3.isUTC()) {
            dateTimeBase3.normalize();
        }
        if (dateTimeBase2.isUTC() && dateTimeBase3.isUTC() || !dateTimeBase2.isUTC() && !dateTimeBase3.isUTC()) {
            return DateTimeBase.compareFields(dateTimeBase2, dateTimeBase3);
        }
        if (dateTimeBase2.isUTC()) {
            dateTimeBase3.setZone((short)14, (short)0);
            dateTimeBase3.normalize();
            int n = DateTimeBase.compareFields(dateTimeBase2, dateTimeBase3);
            if (n == 0) {
                return n;
            }
            dateTimeBase3.setZone((short)14, (short)0);
            dateTimeBase3.setZoneNegative();
            dateTimeBase3.normalize();
            n = DateTimeBase.compareFields(dateTimeBase2, dateTimeBase3);
            if (n == 2) {
                return n;
            }
            return -1;
        }
        if (dateTimeBase3.isUTC()) {
            dateTimeBase2.setZone((short)14, (short)0);
            dateTimeBase2.normalize();
            int n = DateTimeBase.compareFields(dateTimeBase2, dateTimeBase3);
            if (n == 2) {
                return n;
            }
            dateTimeBase2.setZone((short)14, (short)0);
            dateTimeBase2.setZoneNegative();
            dateTimeBase2.normalize();
            n = DateTimeBase.compareFields(dateTimeBase2, dateTimeBase3);
            if (n == 0) {
                return n;
            }
            return -1;
        }
        dateTimeBase2 = null;
        dateTimeBase3 = null;
        return -1;
    }

    protected boolean equal(DateTimeBase dateTimeBase) {
        int n = this.compareTo(dateTimeBase);
        return n == 1;
    }

    public boolean equals(Object object) {
        if (object instanceof DateTimeBase) {
            return this.equal((DateTimeBase)object);
        }
        return false;
    }

    private int fQuotient(int n, int n2) {
        return (int)Math.floor((float)n / (float)n2);
    }

    public short getCentury() {
        return this._century;
    }

    public short getDay() {
        return this._day;
    }

    public short getHour() {
        return this._hour;
    }

    public short getMilli() {
        return this._millsecond;
    }

    public short getMinute() {
        return this._minute;
    }

    public short getMonth() {
        return this._month;
    }

    public short getSeconds() {
        return this._second;
    }

    public abstract short[] getValues();

    public short getYear() {
        return this._year;
    }

    public short getZoneHour() {
        return this._zoneHour;
    }

    public short getZoneMinute() {
        return this._zoneMinute;
    }

    public int hashCode() {
        return this._year ^ this._month ^ this._day ^ this._hour ^ this._minute ^ this._second ^ this._zoneHour ^ this._zoneMinute;
    }

    public final boolean isLeap(int n) {
        short s = (short)(n / 100);
        return this.isLeap(s, (short)(n %= 100));
    }

    private final boolean isLeap(short s, short s2) {
        int n = s * 100 + s2;
        boolean bl = n % 4 == 0 && n % 100 != 0;
        bl = bl || n % 400 == 0;
        return bl;
    }

    public boolean isNegative() {
        return this._isNegative;
    }

    public boolean isUTC() {
        return this._UTC;
    }

    public boolean isZoneNegative() {
        return this._zoneNegative;
    }

    private final short maxDayInMonthFor(short s, short s2, int n) {
        if (n == 4 || n == 6 || n == 9 || n == 11) {
            return 30;
        }
        if (n == 2) {
            if (this.isLeap(s, s2)) {
                return 29;
            }
            return 28;
        }
        return 31;
    }

    private int modulo(int n, int n2) {
        return n - this.fQuotient(n, n2) * n2;
    }

    public void normalize() {
        if (!this.isUTC()) {
            return;
        }
        if (this._zoneHour == 0 && this._zoneMinute == 0) {
            return;
        }
        Duration duration = new Duration();
        duration.setHour(this._zoneHour);
        duration.setMinute(this._zoneMinute);
        if (this.isZoneNegative()) {
            duration.setNegative();
        }
        this.addDuration(duration);
        this.setZone((short)0, (short)0);
        duration = null;
    }

    public void setCentury(short s) {
        String string = "";
        if (s < -1) {
            string = "century : " + s + " must not be a negative value.";
            throw new IllegalArgumentException(string);
        }
        this._century = s;
    }

    public void setDay(short s) throws OperationNotSupportedException {
        String string = "";
        if (s == -1) {
            if (this._month != -1) {
                string = "day cannot be omitted if the previous component is not omitted.\nonly higher level components can be omitted.";
                throw new IllegalArgumentException(string);
            }
        } else if (s < 1) {
            string = "day : " + s + " is not a correct value.";
            string = String.valueOf(string) + "\n 1<day";
            throw new IllegalArgumentException(string);
        }
        if (this._month == 2) {
            if (this.isLeap(this._century, this._year)) {
                if (s > 29) {
                    string = "day : " + s + " is not a correct value.";
                    string = String.valueOf(string) + "\n day<30 (leap year and month is february)";
                    throw new IllegalArgumentException(string);
                }
            } else if (s > 28) {
                string = "day : " + s + " is not a correct value.";
                string = String.valueOf(string) + "\n day<30 (not a leap year and month is february)";
                throw new IllegalArgumentException(string);
            }
        } else if (this._month == 4 || this._month == 6 || this._month == 9 || this._month == 11) {
            if (s > 30) {
                string = "day : " + s + " is not a correct value.";
                string = String.valueOf(string) + "\n day<31 ";
                throw new IllegalArgumentException(string);
            }
        } else if (s > 31) {
            string = "day : " + s + " is not a correct value.";
            string = String.valueOf(string) + "\n day<=31 ";
            throw new IllegalArgumentException(string);
        }
        this._day = s;
    }

    public void setHour(short s) throws OperationNotSupportedException {
        if (s > 23) {
            String string = "the hour field (" + s + ")must be strictly lower than 24";
            throw new IllegalArgumentException(string);
        }
        this._hour = s;
    }

    public void setMinute(short s) throws OperationNotSupportedException {
        if (s > 59) {
            String string = "the minute field (" + s + ")must be lower than 59.";
            throw new IllegalArgumentException(string);
        }
        this._minute = s;
    }

    public void setMonth(short s) throws OperationNotSupportedException {
        String string = "";
        if (s == -1) {
            if (this._century != -1) {
                string = "month cannot be omitted if the previous component is not omitted.\nonly higher level components can be omitted.";
                throw new IllegalArgumentException(string);
            }
        } else {
            if (s < 1) {
                string = "month : " + s + " is not a correct value." + "\n 1<month<12";
                throw new IllegalArgumentException(string);
            }
            if (s > 12) {
                string = "month : " + s + " is not a correct value.";
                string = String.valueOf(string) + "\n 1<month<12";
                throw new IllegalArgumentException(string);
            }
        }
        this._month = s;
    }

    public void setNegative() {
        this._isNegative = true;
    }

    public void setSecond(short s, short s2) throws OperationNotSupportedException {
        if (s > 60) {
            String string = "the second field (" + s + ")must be lower than 60";
            throw new IllegalArgumentException(string);
        }
        this._second = s;
        this._millsecond = s2;
    }

    public void setUTC() {
        this._UTC = true;
    }

    public abstract void setValues(short[] var1);

    public void setYear(short s) throws OperationNotSupportedException {
        String string = "";
        if (s < -1) {
            string = "year : " + s + " must not be a negative value.";
            throw new IllegalArgumentException(string);
        }
        if (s == -1 && this._century != -1) {
            string = "year can not be omitted if century is not omitted.";
            throw new IllegalArgumentException(string);
        }
        if (s == 0 && this._century == 0) {
            string = "0000 is not an allowed year";
            throw new IllegalArgumentException(string);
        }
        this._year = s;
    }

    public void setZone(short s, short s2) throws OperationNotSupportedException {
        if (s > 23) {
            String string = "the zone hour field (" + s + ")must be strictly lower than 24";
            throw new IllegalArgumentException(string);
        }
        this._zoneHour = s;
        if (s2 > 59) {
            String string = "the minute field (" + s2 + ")must be lower than 59";
            throw new IllegalArgumentException(string);
        }
        this._zoneMinute = s2;
        this.setUTC();
    }

    public void setZoneNegative() throws OperationNotSupportedException {
        this._zoneNegative = true;
    }

    public abstract Date toDate();
}

