/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.addressbook;

import com.aimluck.commons.field.ALDateField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.addressbook.AddressBookFilterData;
import com.aimluck.eip.addressbook.AddressBookFilterdSelectData;
import com.aimluck.eip.addressbook.AddressBookResultData;
import com.aimluck.eip.addressbook.util.AddressBookUtils;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressGroup;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressbook;
import com.aimluck.eip.cayenne.om.portlet.EipTAddressbookGroupMap;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AddressBookGroupFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AddressBookGroupFormData.class.getName());
    private List<EipMAddressGroup> groupList;
    private List<AddressBookFilterData> allAddressList;
    private List<Object> addressList;
    private List<AddressBookResultData> addresses;
    private ALStringField group_name;
    private ALStringField public_flag;
    private ALDateField create_date;
    private ALDateField update_date;
    private Integer uid;
    private Integer gid;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.uid = ALEipUtils.getUserId((RunData)rundata);
    }

    public void initField() {
        this.groupList = new ArrayList<EipMAddressGroup>();
        this.allAddressList = new ArrayList<AddressBookFilterData>();
        this.addressList = new ArrayList<Object>();
        this.addresses = new ArrayList<AddressBookResultData>();
        this.group_name = new ALStringField();
        this.group_name.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_GROUP_NAME"));
        this.group_name.setTrim(true);
        this.public_flag = new ALStringField();
        this.public_flag.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_SETFIELDNAME_PUBLIC"));
        this.create_date = new ALDateField();
        this.create_date.setFieldName(ALLocalizationUtils.getl10n((String)"COMMON_CREATE_DATE"));
        this.update_date = new ALDateField();
        this.update_date.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_SETFIELDNAME_LAST_UPDATE_DATE"));
    }

    protected void setValidator() {
        this.group_name.setNotNull(true);
        this.group_name.limitMaxLength(50);
        this.public_flag.setNotNull(true);
        this.public_flag.limitMaxLength(1);
    }

    protected boolean validate(List<String> msgList) {
        try {
            SelectQuery query = Database.query(EipMAddressGroup.class);
            if ("insert".equals(this.getMode())) {
                Expression exp1 = ExpressionFactory.matchExp((String)"groupName", (Object)this.group_name.getValue());
                query.setQualifier(exp1);
                Expression exp2 = ExpressionFactory.matchExp((String)"ownerId", (Object)this.uid);
                query.andQualifier(exp2);
            } else {
                Expression exp1 = ExpressionFactory.matchExp((String)"groupName", (Object)this.group_name.getValue());
                query.setQualifier(exp1);
                Expression exp2 = ExpressionFactory.matchExp((String)"ownerId", (Object)this.uid);
                query.andQualifier(exp2);
                Expression exp3 = ExpressionFactory.noMatchDbExp((String)"GROUP_ID", (Object)this.gid);
                query.andQualifier(exp3);
            }
            if (query.fetchList().size() != 0) {
                msgList.add("\u793e\u5916\u30b0\u30eb\u30fc\u30d7\u540d\u300e <span class='em'>" + this.group_name + "</span> \u300f\u306f\u65e2\u306b\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
            }
            this.group_name.validate(msgList);
            this.public_flag.validate(msgList);
        }
        catch (Exception ex) {
            logger.error((Object)"AddressBookGroupFormData.validate", (Throwable)ex);
            return false;
        }
        return msgList.size() == 0;
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        this.setPublicFlag(new ALStringField("F"));
        boolean res = super.setFormData(rundata, context, msgList);
        this.addressList = new ArrayList<Object>();
        if (res) {
            try {
                Object[] str;
                if ("update".equals(this.getMode())) {
                    this.gid = Integer.valueOf(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid"));
                }
                if (this.hasEmpty((String[])(str = rundata.getParameters().getStrings("address_to")))) {
                    return res;
                }
                SelectQuery query = Database.query(EipMAddressbook.class);
                Expression exp = ExpressionFactory.inDbExp((String)"ADDRESS_ID", (Object[])str);
                query.setQualifier(exp);
                List list = query.fetchList();
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    EipMAddressbook address = (EipMAddressbook)list.get(i);
                    AddressBookResultData rd = new AddressBookResultData();
                    rd.initField();
                    rd.setAddressId(address.getAddressId());
                    rd.setName(address.getLastName() + " " + address.getFirstName());
                    this.addresses.add(rd);
                }
            }
            catch (Exception ex) {
                logger.error((Object)"AddressBookGroupFormData.setFormData", (Throwable)ex);
                throw new ALDBErrorException();
            }
        }
        return res;
    }

    private boolean hasEmpty(String[] list) {
        if (list == null || list.length == 0) {
            return true;
        }
        String str2 = null;
        for (String str2 : list) {
            if (str2 != null && !"".equals(str2)) continue;
            return true;
        }
        return false;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipMAddressGroup group = AddressBookUtils.getEipMAddressGroup(rundata, context);
            if (group == null) {
                return false;
            }
            this.group_name.setValue(group.getGroupName());
            this.public_flag.setValue(group.getPublicFlag());
        }
        catch (Exception ex) {
            logger.error((Object)"AddressBookGroupFormData.loadFormData", (Throwable)ex);
            return false;
        }
        return true;
    }

    public boolean loadAddresses(RunData rundata, Context context) {
        try {
            String gid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
            if (gid != null) {
                SelectQuery query = Database.query(EipMAddressGroup.class);
                Expression exp1 = ExpressionFactory.matchDbExp((String)"GROUP_ID", (Object)Integer.valueOf(gid));
                query.setQualifier(exp1);
                Expression exp2 = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
                query.andQualifier(exp2);
                List list = query.fetchList();
                if (list.size() == 0) {
                    return false;
                }
            } else {
                return false;
            }
            SelectQuery mapquery = Database.query(EipTAddressbookGroupMap.class);
            Expression mapexp = ExpressionFactory.matchDbExp((String)"eipTAddressGroup.GROUP_ID", (Object)Integer.valueOf(gid));
            mapquery.setQualifier(mapexp);
            List aList = mapquery.fetchList();
            int size = aList.size();
            for (int i = 0; i < size; ++i) {
                EipTAddressbookGroupMap record = (EipTAddressbookGroupMap)aList.get(i);
                EipMAddressbook addressbook = (EipMAddressbook)Database.get(EipMAddressbook.class, (Object)record.getAddressId());
                AddressBookResultData rd = new AddressBookResultData();
                rd.initField();
                rd.setAddressId(record.getAddressId());
                rd.setName(addressbook.getLastName() + " " + addressbook.getFirstName());
                this.addresses.add(rd);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"AddressBookGroupFormData.loadAddresses", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipMAddressGroup address = (EipMAddressGroup)Database.create(EipMAddressGroup.class);
            rundata.getParameters().setProperties((Object)address);
            address.setGroupName(this.group_name.getValue());
            address.setPublicFlag(this.public_flag.getValue());
            int uid = ALEipUtils.getUserId((RunData)rundata);
            address.setOwnerId(Integer.valueOf(uid));
            Date now = new Date();
            address.setCreateDate(now);
            address.setUpdateDate(now);
            for (int i = 0; i < this.addresses.size(); ++i) {
                EipTAddressbookGroupMap map = (EipTAddressbookGroupMap)Database.create(EipTAddressbookGroupMap.class);
                int addressid = (int)this.addresses.get(i).getAddressId().getValue();
                map.setEipMAddressbook((EipMAddressbook)Database.get(EipMAddressbook.class, (Object)addressid));
                map.setEipTAddressGroup(address);
            }
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(address.getGroupId().intValue(), 162, this.group_name.getValue());
            return true;
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"AddressBookGroupFormData.insertFormData", (Throwable)ex);
            return false;
        }
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipMAddressGroup group = AddressBookUtils.getEipMAddressGroup(rundata, context);
            if (group == null) {
                return false;
            }
            group.setGroupName(this.group_name.getValue());
            group.setPublicFlag(this.public_flag.getValue());
            group.setUpdateDate(new Date());
            String gid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
            SelectQuery query1 = Database.query(EipTAddressbookGroupMap.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"eipTAddressGroup.GROUP_ID", (Object)gid);
            query1.setQualifier(exp1);
            List maps = query1.fetchList();
            Database.deleteAll((List)maps);
            for (int i = 0; i < this.addresses.size(); ++i) {
                EipTAddressbookGroupMap map = (EipTAddressbookGroupMap)Database.create(EipTAddressbookGroupMap.class);
                int addressid = (int)this.addresses.get(i).getAddressId().getValue();
                map.setEipMAddressbook((EipMAddressbook)Database.get(EipMAddressbook.class, (Object)addressid));
                map.setEipTAddressGroup(group);
            }
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(group.getGroupId().intValue(), 162, this.group_name.getValue());
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"AddressBookGroupFormData.updateFormData", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            String groupid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
            if (groupid == null || Integer.valueOf(groupid) == null) {
                logger.debug((Object)"[AddressBook] Cannot find Ext Group ID .");
                return false;
            }
            SelectQuery query1 = Database.query(EipTAddressbookGroupMap.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"eipTAddressGroup.GROUP_ID", (Object)Integer.valueOf(groupid));
            query1.setQualifier(exp1);
            List maps = query1.fetchList();
            Database.deleteAll((List)maps);
            SelectQuery query2 = Database.query(EipMAddressGroup.class);
            Expression exp2 = ExpressionFactory.matchDbExp((String)"GROUP_ID", (Object)Integer.valueOf(groupid));
            query2.setQualifier(exp2);
            List groups = query2.fetchList();
            EipMAddressGroup delete_group = (EipMAddressGroup)groups.get(0);
            int entityId = delete_group.getGroupId();
            String groupName = delete_group.getGroupName();
            Database.deleteAll((List)groups);
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(entityId, 162, groupName);
            String filtername = AddressBookFilterdSelectData.class.getName() + "filter";
            ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)filtername);
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"AddressBookGroupFormData.deleteFormData", (Throwable)ex);
            return false;
        }
        return true;
    }

    public ALStringField getGroupName() {
        return this.group_name;
    }

    public ALStringField getPublicFlag() {
        return this.public_flag;
    }

    public void setPublicFlag(ALStringField field) {
        this.public_flag = field;
    }

    public ALDateField getCreateDate() {
        return this.create_date;
    }

    public ALDateField getUpdateDate() {
        return this.update_date;
    }

    public void setCreateDate(ALDateField field) {
        this.create_date = field;
    }

    public void setUpdateDate(ALDateField field) {
        this.update_date = field;
    }

    public void loadFilter(RunData rundata, Context context) {
        try {
            SelectQuery query1 = Database.query(EipMAddressGroup.class);
            Expression exp1 = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
            query1.setQualifier(exp1);
            List glist = query1.fetchList();
            for (int i = 0; i < glist.size(); ++i) {
                EipMAddressGroup group = (EipMAddressGroup)glist.get(i);
                this.groupList.add(group);
            }
            SelectQuery query2 = Database.query(EipMAddressbook.class);
            Expression exp21 = ExpressionFactory.matchExp((String)"publicFlag", (Object)"T");
            Expression exp22 = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
            query2.setQualifier(exp21.orExp(exp22));
            List list = query2.fetchList();
            int addressNum = list.size();
            for (int i = 0; i < addressNum; ++i) {
                EipMAddressbook rec = (EipMAddressbook)list.get(i);
                AddressBookFilterData address = new AddressBookFilterData();
                address.initField();
                address.setAddressId(rec.getAddressId());
                address.setFullName(rec.getLastName(), rec.getFirstName());
                this.allAddressList.add(address);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"AddressBookGroupFormData.loadFilter", (Throwable)ex);
        }
    }

    public List<EipMAddressGroup> getGroupList() {
        return this.groupList;
    }

    public List<Object> getAddressList() {
        return this.addressList;
    }

    public List<AddressBookFilterData> getAllAddressList() {
        return this.allAddressList;
    }

    public List<AddressBookFilterData> getGroupAddressList(int gid) {
        ArrayList<AddressBookFilterData> list = new ArrayList<AddressBookFilterData>();
        for (int i = 0; i < this.addressList.size(); ++i) {
            AddressBookFilterData fData = (AddressBookFilterData)this.addressList.get(i);
            if (fData.getGroupId().getValue() != (long)gid) continue;
            list.add(fData);
        }
        return list;
    }

    public List<AddressBookResultData> getAddresses() {
        return this.addresses;
    }

    public String getAclPortletFeature() {
        return "addressbook_company_group";
    }
}

