/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.hibernate.regions;

import java.util.Properties;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.hibernate.regions.EhcacheDataRegion;
import org.hibernate.cache.GeneralDataRegion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class EhcacheGeneralDataRegion
extends EhcacheDataRegion
implements GeneralDataRegion {
    private static final Logger LOG = LoggerFactory.getLogger(EhcacheGeneralDataRegion.class);

    public EhcacheGeneralDataRegion(Ehcache cache, Properties properties) {
        super(cache, properties);
    }

    public Object get(Object key) throws org.hibernate.cache.CacheException {
        try {
            LOG.debug("key: {}", key);
            if (key == null) {
                return null;
            }
            Element element = this.cache.get(key);
            if (element == null) {
                LOG.debug("Element for key {} is null", key);
                return null;
            }
            return element.getObjectValue();
        }
        catch (CacheException e) {
            throw new org.hibernate.cache.CacheException((Throwable)e);
        }
    }

    public void put(Object key, Object value) throws org.hibernate.cache.CacheException {
        LOG.debug("key: {} value: {}", key, value);
        try {
            Element element = new Element(key, value);
            this.cache.put(element);
        }
        catch (IllegalArgumentException e) {
            throw new org.hibernate.cache.CacheException((Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new org.hibernate.cache.CacheException((Throwable)e);
        }
        catch (CacheException e) {
            throw new org.hibernate.cache.CacheException((Throwable)e);
        }
    }

    public void evict(Object key) throws org.hibernate.cache.CacheException {
        try {
            this.cache.remove(key);
        }
        catch (ClassCastException e) {
            throw new org.hibernate.cache.CacheException((Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new org.hibernate.cache.CacheException((Throwable)e);
        }
        catch (CacheException e) {
            throw new org.hibernate.cache.CacheException((Throwable)e);
        }
    }

    public void evictAll() throws org.hibernate.cache.CacheException {
        try {
            this.cache.removeAll();
        }
        catch (IllegalStateException e) {
            throw new org.hibernate.cache.CacheException((Throwable)e);
        }
        catch (CacheException e) {
            throw new org.hibernate.cache.CacheException((Throwable)e);
        }
    }
}

