/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.project.util;

import com.aimluck.eip.cayenne.om.portlet.EipMProjectKubun;
import com.aimluck.eip.cayenne.om.portlet.EipMProjectKubunValue;
import com.aimluck.eip.cayenne.om.portlet.EipTProject;
import com.aimluck.eip.cayenne.om.portlet.EipTProjectFile;
import com.aimluck.eip.cayenne.om.portlet.EipTProjectMember;
import com.aimluck.eip.cayenne.om.portlet.EipTProjectTask;
import com.aimluck.eip.cayenne.om.portlet.EipTProjectTaskComment;
import com.aimluck.eip.cayenne.om.portlet.EipTProjectTaskCommentFile;
import com.aimluck.eip.cayenne.om.portlet.EipTProjectTaskMember;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.mail.ALAdminMailContext;
import com.aimluck.eip.mail.ALAdminMailMessage;
import com.aimluck.eip.mail.ALMailService;
import com.aimluck.eip.mail.util.ALEipUserAddr;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.Operations;
import com.aimluck.eip.orm.query.SQLTemplate;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.project.ProjectResultData;
import com.aimluck.eip.project.ProjectTaskCommentResultData;
import com.aimluck.eip.project.ProjectTaskMemberResultData;
import com.aimluck.eip.project.ProjectTaskResultData;
import com.aimluck.eip.project.util.ProjectFile;
import com.aimluck.eip.services.orgutils.ALOrgUtilsService;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.services.customlocalization.CustomLocalizationService;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.util.ServiceUtil;
import org.apache.turbine.util.RunData;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class ProjectUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ProjectUtils.class.getName());
    public static final String PROJECT_PORTLET_NAME = "Project";
    public static final String FLG_ON = "t";
    public static final String FLG_OFF = "f";
    public static final String EMPTY_DATE = "9999/12/31";
    public static final String DATE_FORMAT = "yyyy/MM/dd";
    public static final String DB_DATE_FORMAT = "YYYY/MM/DD";
    public static final String DISP_DATE_FORMAT = "yyyy\u5e74M\u6708d\u65e5\uff08E\uff09";
    private static final DecimalFormat df = new DecimalFormat("#.0##");
    public static final List<String> incompleteStatus = Arrays.asList("1", "2", "3");
    public static final List<String> completeStatus = Arrays.asList("4", "5", "6");

    public static EipTProject getEipTProject(RunData rundata, Context context) {
        Integer projectId = Integer.valueOf(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid"));
        return ProjectUtils.getEipTProject(projectId);
    }

    public static EipTProject getEipTProject(Integer projectId) {
        try {
            if (projectId == null) {
                logger.debug((Object)"[ProjectUtils] Empty ID...");
                return null;
            }
            SelectQuery query = Database.query(EipTProject.class);
            query.setQualifier(ExpressionFactory.matchDbExp((String)"PROJECT_ID", (Object)projectId));
            List list = query.fetchList();
            if (list == null || list.isEmpty()) {
                logger.debug((Object)"[ProjectUtils] Not found ID...");
                return null;
            }
            return (EipTProject)list.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static List<ProjectResultData> getAllProject() {
        ArrayList<ProjectResultData> allProject = new ArrayList<ProjectResultData>();
        try {
            List list = Database.query(EipTProject.class).orderAscending("projectName").fetchList();
            for (EipTProject project : list) {
                ProjectResultData data = new ProjectResultData();
                data.initField();
                data.setProjectId(project.getProjectId().intValue());
                data.setProjectName(project.getProjectName());
                allProject.add(data);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
        return allProject;
    }

    public static ProjectResultData getProjectResultData(EipTProject model) {
        try {
            ALEipUser adminUser = ALEipUtils.getALEipUser((int)model.getAdminUserId());
            ProjectResultData data = new ProjectResultData();
            data.initField();
            data.setProjectId(model.getProjectId().intValue());
            data.setProjectName(model.getProjectName());
            data.setExplanation(model.getExplanation());
            data.setAdminUserId(model.getAdminUserId().intValue());
            data.setAdminUserName(adminUser.getAliasName().getValue());
            data.setProgressFlg(model.getProgressFlg());
            data.setProgressRate(model.getProgressRate().intValue());
            data.setCreateDate(model.getCreateDate());
            data.setUpdateDate(model.getUpdateDate());
            data.setTaskUpdateDate(model.getUpdateDate());
            return data;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static int getProjectProgressRate(Integer projectId) {
        try {
            List<DataRow> result = ProjectUtils.getProjectProgress(projectId);
            if (result == null) {
                return 0;
            }
            DataRow row = result.get(0);
            Object per = row.get((Object)"result_per");
            if (per == null) {
                return 0;
            }
            return Integer.valueOf(row.get((Object)"result_per").toString());
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return 0;
        }
    }

    public static List<DataRow> getProjectProgress(Integer projectId) {
        if (Database.isJdbcMySQL()) {
            SimpleDateFormat sdfSrc = new SimpleDateFormat(DATE_FORMAT);
            Date date = null;
            try {
                date = sdfSrc.parse(EMPTY_DATE);
            }
            catch (ParseException e) {
                logger.error((Object)"getProjectProgress", (Throwable)e);
                throw new RuntimeException(e);
            }
            SimpleDateFormat sdfDest = new SimpleDateFormat("yyyy-MM-dd");
            String formatedEmptyDate = sdfDest.format(date);
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT task.progress_rate, task.start_plan_date, task.end_plan_date, task.plan_workload, member.workload, ");
            sb.append("  CASE WHEN ");
            sb.append("    ").append(ProjectUtils.getCurrentDateWithCast()).append(" < task.end_plan_date ");
            sb.append("  THEN");
            sb.append("    CASE WHEN ");
            sb.append("      ").append(ProjectUtils.getCurrentDateWithCast()).append(" - task.start_plan_date + 1 < 0 THEN 0 ");
            sb.append("    ELSE");
            sb.append("      ").append(ProjectUtils.getCurrentDateWithCast()).append(" - task.start_plan_date + 1 ");
            sb.append("    END");
            sb.append("  ELSE");
            sb.append("    task.end_plan_date - task.start_plan_date + 1 ");
            sb.append("  END");
            sb.append("  AS lapsed_days, ");
            sb.append("  task.end_plan_date - task.start_plan_date + 1 AS task_days, task.update_date AS task_update_date FROM eip_t_project_task AS task ");
            sb.append("  JOIN");
            sb.append("  (");
            sb.append("    SELECT task_id, SUM(workload) AS workload FROM eip_t_project_task_member GROUP BY task_id");
            sb.append("  ) AS member ON member.task_id = task.task_id ");
            sb.append("  WHERE task.project_id = #bind($project_id) AND NOT EXISTS");
            sb.append("  (");
            sb.append("    SELECT 0 FROM eip_t_project_task AS sub WHERE sub.parent_task_id = task.task_id");
            sb.append("  )");
            sb.append("  AND start_plan_date <> #bind($empty_date) AND end_plan_date <> #bind($empty_date)");
            String subQuery = sb.toString();
            StringBuilder main = new StringBuilder();
            main.append("SELECT COUNT(0) AS cnt, SUM(lapsed_days) AS lapsed_days, SUM(task_days) AS task_days, CONVERT(SUM(task_days * progress_rate) / SUM(task_days), SIGNED) AS result_per, CONVERT(SUM(lapsed_days) * 100 / SUM(task_days), SIGNED) AS plan_per, CONVERT(SUM(plan_workload), SIGNED) AS plan_workload, CONVERT(SUM(workload), SIGNED) AS workload, CONVERT(SUM(task_days * progress_rate) / SUM(task_days), SIGNED) AS result_per, MAX(task_update_date) AS task_update_date FROM");
            main.append("(").append(subQuery).append(") AS base");
            String query = main.toString();
            SQLTemplate sqltemp = Database.sql(EipTProjectTask.class, (String)query);
            sqltemp.param("project_id", (Object)projectId);
            sqltemp.param("empty_date", (Object)formatedEmptyDate);
            List result = sqltemp.fetchListAsDataRow();
            return result;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("WITH base AS (");
        sb.append("  SELECT");
        sb.append("        task.progress_rate");
        sb.append("      , task.start_plan_date");
        sb.append("      , task.end_plan_date");
        sb.append("      , task.plan_workload");
        sb.append("      , member.workload");
        sb.append("      , CASE");
        sb.append("          WHEN ").append(ProjectUtils.getCurrentDateWithCast()).append(" < task.end_plan_date");
        sb.append("            THEN");
        sb.append("              CASE WHEN ").append(ProjectUtils.getCurrentDateWithCast()).append(" - task.start_plan_date + 1 < 0");
        sb.append("                THEN 0");
        sb.append("                ELSE ").append(ProjectUtils.getCurrentDateWithCast()).append(" - task.start_plan_date + 1");
        sb.append("              END");
        sb.append("            ELSE");
        sb.append("              task.end_plan_date - task.start_plan_date + 1");
        sb.append("        END AS lapsed_days");
        sb.append("      , task.end_plan_date - task.start_plan_date + 1 AS task_days");
        sb.append("      , task.update_date AS task_update_date");
        sb.append("    FROM");
        sb.append("      eip_t_project_task AS task");
        sb.append("        JOIN ( ");
        sb.append("          SELECT");
        sb.append("              task_id");
        sb.append("              , SUM(workload) AS workload");
        sb.append("            FROM");
        sb.append("              eip_t_project_task_member");
        sb.append("            GROUP BY");
        sb.append("              task_id");
        sb.append("        ) AS member ");
        sb.append("          ON member.task_id = task.task_id");
        sb.append("   WHERE");
        sb.append("         task.project_id = #bind($project_id)");
        sb.append("     AND NOT EXISTS(");
        sb.append("           SELECT 0");
        sb.append("             FROM eip_t_project_task AS sub");
        sb.append("            WHERE");
        sb.append("                  sub.parent_task_id = task.task_id");
        sb.append("         )");
        sb.append("     AND start_plan_date <> TO_DATE(#bind($empty_date), #bind($date_format))");
        sb.append("     AND end_plan_date <> TO_DATE(#bind($empty_date), #bind($date_format))");
        sb.append(")");
        sb.append("SELECT");
        sb.append("      #result('COUNT(0)' 'int' 'cnt')");
        sb.append("    , #result('SUM(lapsed_days)' 'int' 'lapsed_days')");
        sb.append("    , #result('SUM(task_days)' 'int' 'task_days')");
        sb.append("    , #result('SUM(task_days * progress_rate) / SUM(task_days)' 'int' 'result_per')");
        sb.append("    , #result('SUM(lapsed_days) * 100 / SUM(task_days)' 'int' 'plan_per')");
        sb.append("    , #result('SUM(plan_workload)' 'java.math.BigDecimal' 'plan_workload')");
        sb.append("    , #result('SUM(workload)' 'java.math.BigDecimal' 'workload')");
        sb.append("    , #result('SUM(task_days * progress_rate) / SUM(task_days)' 'int' 'result_per')");
        sb.append("    , #result('MAX(task_update_date)' 'java.util.Date' 'task_update_date')");
        sb.append("  FROM");
        sb.append("    base");
        SQLTemplate sqltemp = Database.sql(EipTProjectTask.class, (String)String.valueOf(sb));
        sqltemp.param("project_id", (Object)projectId);
        sqltemp.param("date_format", (Object)DB_DATE_FORMAT);
        sqltemp.param("empty_date", (Object)EMPTY_DATE);
        List result = sqltemp.fetchListAsDataRow();
        return result;
    }

    public static List<ALEipUser> getProjectMembers(Integer projectId) {
        ArrayList<ALEipUser> members = new ArrayList<ALEipUser>();
        try {
            SelectQuery query = Database.query(EipTProjectMember.class);
            query.setQualifier(ExpressionFactory.matchExp((String)"eipTProject", (Object)projectId));
            List list = query.fetchList();
            for (EipTProjectMember member : list) {
                members.add(ALEipUtils.getALEipUser((int)member.getUserId()));
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
        return members;
    }

    public static List<EipTProjectMember> getEipTProjectMember(EipTProject project) {
        try {
            SelectQuery query = Database.query(EipTProjectMember.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"PROJECT_ID", (Object)project.getProjectId());
            query.setQualifier(exp);
            List members = query.fetchList();
            if (members == null || members.size() == 0) {
                logger.debug((Object)"[ProjectUtils] Not found ID...");
                return null;
            }
            return members;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static boolean removeProjectMember(EipTProject project) {
        try {
            SelectQuery query = Database.query(EipTProjectMember.class);
            query.setQualifier(ExpressionFactory.matchExp((String)"eipTProject", (Object)project));
            List projectMemberList = query.fetchList();
            if (projectMemberList == null || projectMemberList.isEmpty()) {
                return true;
            }
            Database.deleteAll((List)projectMemberList);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    public static boolean sendMailForProjectMembers(RunData rundata, Context context, EipTProject project, List<ALEipUser> memberList) {
        String orgId = Database.getDomainName();
        String subject = "[" + ALOrgUtilsService.getAlias() + "]" + ALLocalizationUtils.getl10n((String)"PROJECT_MAIL_TITLE");
        try {
            List destMemberList = ALMailUtils.getALEipUserAddrs(memberList, (int)ALEipUtils.getUserId((RunData)rundata), (boolean)false);
            ArrayList<ALAdminMailMessage> messageList = new ArrayList<ALAdminMailMessage>();
            for (ALEipUserAddr destMember : destMemberList) {
                ALAdminMailMessage message = new ALAdminMailMessage(destMember);
                message.setPcSubject(subject);
                message.setCellularSubject(subject);
                message.setPcBody(ProjectUtils.createProjectMemberMsg(rundata, message.getPcMailAddr(), project));
                message.setCellularBody(ProjectUtils.createProjectMemberMsg(rundata, message.getCellMailAddr(), project));
                messageList.add(message);
            }
            ALMailService.sendAdminMailAsync((ALAdminMailContext)new ALAdminMailContext(orgId, ALEipUtils.getUserId((RunData)rundata), messageList, ALMailUtils.getSendDestType((int)23)));
        }
        catch (Exception ex) {
            logger.error((Object)"project", (Throwable)ex);
            return false;
        }
        return true;
    }

    public static String createProjectMemberMsg(RunData rundata, String addr, EipTProject project) {
        VelocityContext context = new VelocityContext();
        boolean enableAsp = JetspeedResources.getBoolean((String)"aipo.asp", (boolean)false);
        String CR = ALMailUtils.CR;
        context.put("user_email", (Object)addr);
        StringBuffer message = new StringBuffer("");
        message.append(CR);
        message.append(ALLocalizationUtils.getl10nFormat((String)"PROJECT_MAIL_TEXT2", (Object[])new Object[]{project.getProjectName()})).append(CR);
        context.put("message", (Object)message);
        context.put("serviceAlias", (Object)ALOrgUtilsService.getAlias());
        context.put("enableAsp", (Object)enableAsp);
        context.put("globalurl", (Object)ALMailUtils.getGlobalurl());
        context.put("localurl", (Object)ALMailUtils.getLocalurl());
        CustomLocalizationService locService = (CustomLocalizationService)ServiceUtil.getServiceByName((String)"LocalizationService");
        String lang = locService.getLocale(rundata).getLanguage();
        StringWriter writer = new StringWriter();
        try {
            Template template;
            if (lang != null && lang.equals("ja")) {
                template = Velocity.getTemplate((String)("portlets/mail/" + lang + "/project-notification-mail.vm"), (String)"utf-8");
                template.merge((Context)context, (Writer)writer);
            } else {
                template = Velocity.getTemplate((String)"portlets/mail/project-notification-mail.vm", (String)"utf-8");
                template.merge((Context)context, (Writer)writer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        writer.flush();
        String ret = writer.getBuffer().toString();
        return ret;
    }

    public static EipTProjectTask getEipTProjectTask(RunData rundata, Context context) {
        String taskId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        return ProjectUtils.getEipTProjectTask(taskId);
    }

    public static EipTProjectTask getEipTProjectTask(String taskId) {
        try {
            if (taskId == null || Integer.valueOf(taskId) == null) {
                logger.debug((Object)"[ProjectUtils] Empty ID...");
                return null;
            }
            SelectQuery query = Database.query(EipTProjectTask.class);
            query.setQualifier(ExpressionFactory.matchDbExp((String)"TASK_ID", (Object)taskId));
            List list = query.fetchList();
            if (list == null || list.isEmpty()) {
                logger.debug((Object)"[ProjectUtils] Not found ID...");
                return null;
            }
            return (EipTProjectTask)list.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static boolean getEipTProjectTaskCheck(Integer projectId) {
        try {
            SelectQuery query = Database.query(EipTProjectTask.class);
            query.setQualifier(ExpressionFactory.matchExp((String)"eipTProject", (Object)projectId));
            List list = query.fetchList();
            return list == null || list.isEmpty();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
    }

    public static List<ProjectTaskResultData> getProjectTaskResultList(List<EipTProjectTask> taskList) {
        ArrayList<ProjectTaskResultData> resultList = new ArrayList<ProjectTaskResultData>();
        for (EipTProjectTask task : taskList) {
            resultList.add(ProjectUtils.getProjectTaskResultData(task));
        }
        return resultList;
    }

    public static ProjectTaskResultData getProjectTaskResultData(EipTProjectTask model) {
        ProjectTaskResultData data = new ProjectTaskResultData();
        data.initField();
        data.setTaskId(model.getTaskId().intValue());
        data.setProjectId(model.getProjectId().intValue());
        data.setTracker(model.getTracker());
        data.setTaskName(model.getTaskName());
        data.setExplanation(model.getExplanation());
        data.setStatus(model.getStatus());
        data.setPriority(model.getPriority());
        if (!ProjectUtils.isEmptyDate(model.getStartPlanDate())) {
            data.setStartPlanDate(model.getStartPlanDate());
        }
        if (!ProjectUtils.isEmptyDate(model.getEndPlanDate())) {
            data.setEndPlanDate(model.getEndPlanDate());
        }
        if (!ProjectUtils.isEmptyDate(model.getStartDate())) {
            data.setStartDate(model.getStartDate());
        }
        if (!ProjectUtils.isEmptyDate(model.getEndDate())) {
            data.setEndDate(model.getEndDate());
        }
        data.setPlanWorkload(new BigDecimal(df.format(model.getPlanWorkload())));
        data.setProgressRate(model.getProgressRate().intValue());
        data.setCreateDate(model.getCreateDate());
        data.setUpdateDate(model.getUpdateDate());
        data.setMemberList(ProjectUtils.getProjectTaskMembers(model.getTaskId().toString()));
        Integer parentTaskId = model.getParentTaskId();
        if (parentTaskId != null) {
            EipTProjectTask parent = ProjectUtils.getEipTProjectTask("" + parentTaskId);
            data.setParentTaskId(parent.getTaskId().intValue());
            data.setParentTaskName(parent.getTaskName());
        }
        data.setIndent(model.getIndent());
        return data;
    }

    public static int getCountChildrenTask(Integer taskId) {
        try {
            if (taskId == null) {
                return 0;
            }
            SelectQuery query = Database.query(EipTProjectTask.class);
            query.setQualifier(ExpressionFactory.matchExp((String)"parentTaskId", (Object)taskId));
            List list = query.fetchList();
            if (list == null || list.isEmpty()) {
                return 0;
            }
            return list.size();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return -1;
        }
    }

    public static List<ProjectTaskMemberResultData> getProjectTaskMembers(String taskId) {
        ArrayList<ProjectTaskMemberResultData> members = new ArrayList<ProjectTaskMemberResultData>();
        try {
            SelectQuery query = Database.query(EipTProjectTaskMember.class);
            query.setQualifier(ExpressionFactory.matchExp((String)"eipTProjectTask", (Object)taskId));
            query.orderAscending("userId");
            List list = query.fetchList();
            for (EipTProjectTaskMember member : list) {
                ALEipUser user = ALEipUtils.getALEipUser((int)member.getUserId());
                ProjectTaskMemberResultData data = new ProjectTaskMemberResultData();
                data.initField();
                data.setUserId(user.getUserId().getValue());
                data.setUserName(user.getAliasName().getValue());
                BigDecimal workload = new BigDecimal(df.format(member.getWorkload()));
                data.setWorkload(workload);
                members.add(data);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
        return members;
    }

    public static boolean removeProjectTaskMember(EipTProjectTask task) {
        try {
            SelectQuery query = Database.query(EipTProjectTaskMember.class);
            query.setQualifier(ExpressionFactory.matchExp((String)"eipTProjectTask", (Object)task));
            List taskMemberList = query.fetchList();
            if (taskMemberList == null || taskMemberList.isEmpty()) {
                return true;
            }
            Database.deleteAll((List)taskMemberList);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    public static boolean sendMailForTaskMembers(RunData rundata, Context context, EipTProjectTask task, EipTProject project, List<ProjectTaskMemberResultData> mailUserList) {
        String orgId = Database.getDomainName();
        String subject = "[" + ALOrgUtilsService.getAlias() + "]" + ALLocalizationUtils.getl10n((String)"PROJECT_MAIL_TITLE");
        try {
            ArrayList<ALEipUser> memberList = new ArrayList<ALEipUser>();
            for (ProjectTaskMemberResultData rd : mailUserList) {
                memberList.add(ALEipUtils.getALEipUser((int)rd.getUserId().getValueWithInt()));
            }
            List destMemberList = ALMailUtils.getALEipUserAddrs(memberList, (int)ALEipUtils.getUserId((RunData)rundata), (boolean)false);
            ArrayList<ALAdminMailMessage> messageList = new ArrayList<ALAdminMailMessage>();
            for (ALEipUserAddr destMember : destMemberList) {
                ALAdminMailMessage message = new ALAdminMailMessage(destMember);
                message.setPcSubject(subject);
                message.setCellularSubject(subject);
                message.setPcBody(ProjectUtils.createTaskMemberMsg(rundata, message.getPcMailAddr(), task, project));
                message.setCellularBody(ProjectUtils.createTaskMemberMsg(rundata, message.getCellMailAddr(), task, project));
                messageList.add(message);
            }
            ALMailService.sendAdminMailAsync((ALAdminMailContext)new ALAdminMailContext(orgId, ALEipUtils.getUserId((RunData)rundata), messageList, ALMailUtils.getSendDestType((int)23)));
        }
        catch (Exception ex) {
            logger.error((Object)"project", (Throwable)ex);
            return false;
        }
        return true;
    }

    public static String createTaskMemberMsg(RunData rundata, String addr, EipTProjectTask task, EipTProject project) {
        VelocityContext context = new VelocityContext();
        boolean enableAsp = JetspeedResources.getBoolean((String)"aipo.asp", (boolean)false);
        String CR = ALMailUtils.CR;
        context.put("user_email", (Object)addr);
        StringBuffer message = new StringBuffer("");
        message.append(CR);
        message.append(ALLocalizationUtils.getl10nFormat((String)"PROJECT_MAIL_TEXT", (Object[])new Object[]{project.getProjectName(), task.getTaskName()})).append(CR);
        context.put("message", (Object)message);
        context.put("serviceAlias", (Object)ALOrgUtilsService.getAlias());
        context.put("enableAsp", (Object)enableAsp);
        context.put("globalurl", (Object)ALMailUtils.getGlobalurl());
        context.put("localurl", (Object)ALMailUtils.getLocalurl());
        CustomLocalizationService locService = (CustomLocalizationService)ServiceUtil.getServiceByName((String)"LocalizationService");
        String lang = locService.getLocale(rundata).getLanguage();
        StringWriter writer = new StringWriter();
        try {
            Template template;
            if (lang != null && lang.equals("ja")) {
                template = Velocity.getTemplate((String)("portlets/mail/" + lang + "/project-notification-mail.vm"), (String)"utf-8");
                template.merge((Context)context, (Writer)writer);
            } else {
                template = Velocity.getTemplate((String)"portlets/mail/project-notification-mail.vm", (String)"utf-8");
                template.merge((Context)context, (Writer)writer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        writer.flush();
        String ret = writer.getBuffer().toString();
        return ret;
    }

    public static EipTProjectTaskComment getEipTProjectTaskComment(RunData rundata, Context context) {
        String commentId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        return ProjectUtils.getEipTProjectTaskComment(commentId);
    }

    public static EipTProjectTaskComment getEipTProjectTaskComment(String commentId) {
        try {
            if (commentId == null || Integer.valueOf(commentId) == null) {
                logger.debug((Object)"[ProjectUtils] Empty ID...");
                return null;
            }
            SelectQuery query = Database.query(EipTProjectTaskComment.class);
            query.setQualifier(ExpressionFactory.matchDbExp((String)"COMMENT_ID", (Object)commentId));
            List list = query.fetchList();
            if (list == null || list.isEmpty()) {
                logger.debug((Object)"[ProjectUtils] Not found ID...");
                return null;
            }
            return (EipTProjectTaskComment)list.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static List<ProjectTaskCommentResultData> getProjectTaskCommentList(String taskId) {
        ArrayList<ProjectTaskCommentResultData> commentList = new ArrayList<ProjectTaskCommentResultData>();
        try {
            SelectQuery query = Database.query(EipTProjectTaskComment.class);
            query.setQualifier(ExpressionFactory.matchExp((String)"eipTProjectTask", (Object)taskId));
            List list = query.fetchList();
            ProjectFile pfile = new ProjectFile(EipTProjectTaskCommentFile.class);
            for (EipTProjectTaskComment comment : list) {
                ALEipUser user = ALEipUtils.getALEipUser((int)comment.getTurbineUser().getUserId());
                ProjectTaskCommentResultData data = new ProjectTaskCommentResultData();
                data.initField();
                data.setCommentId(comment.getCommentId().intValue());
                data.setTaskId(comment.getTaskId().intValue());
                data.setComment(comment.getComment());
                data.setCreateUserId(user.getUserId().getValue());
                data.setCreateUser(user.getAliasName().getValue());
                data.setCreateDate(comment.getCreateDate());
                data.setUpdateDate(comment.getUpdateDate());
                data.setHasPhoto(user.hasPhoto());
                List filelist = pfile.getSelectQueryForFiles("COMMENT_ID", comment.getCommentId()).fetchList();
                data.setAttachmentFiles(pfile.getFileList(filelist));
                commentList.add(data);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
        return commentList;
    }

    public static boolean removeProjectTaskComment(RunData rundata, EipTProjectTask task) {
        try {
            SelectQuery query = Database.query(EipTProjectTaskComment.class);
            query.setQualifier(ExpressionFactory.matchExp((String)"eipTProjectTask", (Object)task));
            List taskCommentList = query.fetchList();
            if (taskCommentList == null || taskCommentList.isEmpty()) {
                return true;
            }
            ProjectFile pfile = new ProjectFile(EipTProjectTaskCommentFile.class);
            for (EipTProjectTaskComment comment : taskCommentList) {
                pfile.removeFile(rundata, "eipTProjectTaskComment", comment.getCommentId());
            }
            Database.deleteAll((List)taskCommentList);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    public static SelectQuery<EipTProjectFile> getSelectQueryForFiles(int requestid) {
        SelectQuery query = Database.query(EipTProjectFile.class);
        Expression exp = ExpressionFactory.matchDbExp((String)"PROJECT_ID", (Object)requestid);
        query.setQualifier(exp);
        return query;
    }

    public static EipTProjectFile getEipTProjectFile(RunData rundata) throws ALPageNotFoundException, ALDBErrorException {
        try {
            int attachmentIndex = rundata.getParameters().getInt("attachmentIndex", -1);
            if (attachmentIndex < 0) {
                logger.debug((Object)"[ProjectUtils] Empty ID...");
                throw new ALPageNotFoundException();
            }
            SelectQuery query = Database.query(EipTProjectFile.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"FILE_ID", (Object)attachmentIndex);
            query.andQualifier(exp);
            List files = query.fetchList();
            if (files == null || files.size() == 0) {
                logger.debug((Object)"[ProjectUtils] Not found ID...");
                throw new ALPageNotFoundException();
            }
            return (EipTProjectFile)files.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"[ProjectUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static EipMProjectKubun getEipMProjectKubun(String key) {
        try {
            SelectQuery query = Database.query(EipMProjectKubun.class);
            query.setQualifier(ExpressionFactory.matchExp((String)"projectKubunCd", (Object)key));
            return (EipMProjectKubun)query.fetchSingle();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static EipMProjectKubunValue getEipMProjectKubunValue(String cd, String valCd) {
        try {
            EipMProjectKubun kubun = ProjectUtils.getEipMProjectKubun(cd);
            SelectQuery query = Database.query(EipMProjectKubunValue.class);
            query.setQualifier(ExpressionFactory.matchExp((String)"projectKubun", (Object)kubun));
            query.andQualifier(ExpressionFactory.matchExp((String)"projectKubunValueCd", (Object)valCd));
            return (EipMProjectKubunValue)query.fetchSingle();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static Map<String, String> getKubunMap(String cd) {
        try {
            EipMProjectKubun kubun = ProjectUtils.getEipMProjectKubun(cd);
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            SelectQuery query = Database.query(EipMProjectKubunValue.class);
            query.setQualifier(ExpressionFactory.matchExp((String)"projectKubun", (Object)kubun));
            query.orderAscending("orderNo");
            List list = query.fetchList();
            for (EipMProjectKubunValue value : list) {
                map.put(value.getProjectKubunValueCd(), value.getProjectKubunValue());
            }
            return map;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static String getKubunValueString(String key, String valCd) {
        try {
            EipMProjectKubunValue val = ProjectUtils.getEipMProjectKubunValue(key, valCd);
            return val.getProjectKubunValue();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date getEmptyDate() {
        Calendar cal = Calendar.getInstance();
        cal.set(9999, 11, 31);
        return cal.getTime();
    }

    public static boolean isEmptyDate(Date date) {
        if (date == null) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1) == 9999;
    }

    public static int getLapsedDays(Calendar from, Calendar to) {
        return ProjectUtils.getLapsedDays(ProjectUtils.toString(from.getTime()), ProjectUtils.toString(to.getTime()));
    }

    public static int getLapsedDays(String from, String to) {
        if (EMPTY_DATE.equals(from) || EMPTY_DATE.equals(to)) {
            return 0;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        Date dateFrom = null;
        Date dateTo = null;
        try {
            dateFrom = sdf.parse(from);
            dateTo = sdf.parse(to);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return 0;
        }
        return (int)((dateTo.getTime() - dateFrom.getTime()) / 86400000L + 1L);
    }

    public static Date toDate(String str) {
        try {
            return new SimpleDateFormat(DATE_FORMAT).parse(str);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String toString(Date date) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat(DATE_FORMAT).format(date);
    }

    public static Calendar getViewCalendar(RunData rundata, Context context, String key) {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        String year = ProjectUtils.getParameter(rundata, context, key + "_year");
        String month = ProjectUtils.getParameter(rundata, context, key + "_month");
        String day = ProjectUtils.getParameter(rundata, context, key + "_day");
        if (year != null) {
            cal.set(1, Integer.valueOf(year));
        }
        if (month != null) {
            cal.set(2, Integer.valueOf(month) - 1);
        }
        if (day != null) {
            cal.set(5, Integer.valueOf(day));
        }
        return cal;
    }

    public static String getParameter(RunData rundata, Context context, String key) {
        String val = rundata.getParameters().getString(key);
        if (val == null) {
            val = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)key);
        } else {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)key, (String)val);
        }
        return val;
    }

    public static void setParameterList(RunData rundata, Context context) {
        String filter = rundata.getParameters().getString("filter", "");
        String filterType = rundata.getParameters().getString("filtertype", "");
        if (filterType.isEmpty()) {
            return;
        }
        if (filterType.equals("target_user_id,target_tracker,target_priority,target_status")) {
            String[] filterTypeList = filterType.split(",");
            String[] filterList = filter.split(",");
            for (int i = 0; i <= 4; ++i) {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)filterTypeList[i], (String)filterList[i]);
            }
        }
    }

    public static Integer getPlanWorkload(Integer lapsedDays, Integer taskDays) {
        if (taskDays == 0) {
            return 0;
        }
        Integer planProgressRate = lapsedDays * 100 / taskDays;
        if (planProgressRate < 0) {
            planProgressRate = 0;
        }
        return planProgressRate;
    }

    public static String getSaveDirPath(String orgId, int uid) {
        return ALStorageService.getDocumentPath((String)ProjectFile.FOLDER_FILEDIR, (String)(ProjectFile.CATEGORY_KEY + ALStorageService.separator() + uid));
    }

    public static String getTaskTopicPath(Integer projectId) {
        String path = "";
        EipTProject project = ProjectUtils.getEipTProject(projectId);
        if (project != null) {
            path = project.getProjectName();
        }
        return path;
    }

    public static String getEscapedStringForMysql(String text) {
        if (StringUtils.isEmpty((String)text)) {
            return text;
        }
        StringBuffer buf = new StringBuffer();
        block9: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\u0000': {
                    buf.append('\\');
                    buf.append('0');
                    continue block9;
                }
                case '\n': {
                    buf.append('\\');
                    buf.append('n');
                    continue block9;
                }
                case '\r': {
                    buf.append('\\');
                    buf.append('r');
                    continue block9;
                }
                case '\\': {
                    buf.append('\\');
                    buf.append('\\');
                    continue block9;
                }
                case '\'': {
                    buf.append('\\');
                    buf.append('\'');
                    continue block9;
                }
                case '\"': {
                    buf.append('\\');
                    buf.append('\"');
                    continue block9;
                }
                case '\u001a': {
                    buf.append('\\');
                    buf.append('Z');
                    continue block9;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    public static String getLikeEnclosed(String text) {
        return new StringBuffer().append("'%").append(text).append("%'").toString();
    }

    public static String getSingleQuoteEnclosed(String text) {
        return new StringBuffer().append("'").append(text).append("'").toString();
    }

    public static String getCurrentDateWithCast() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String currentDate = sdf.format(new Date());
        return "CAST(" + ProjectUtils.getSingleQuoteEnclosed(currentDate) + " AS DATE)";
    }

    public static Expression getIncompleteExpression() {
        Expression exp = null;
        for (String status : incompleteStatus) {
            Expression tmp = ExpressionFactory.matchExp((String)"status", (Object)status);
            if (null == exp) {
                exp = tmp;
                continue;
            }
            exp = exp.orExp(tmp);
        }
        return exp;
    }

    public static String getIncompleteSQL(String column) {
        StringBuilder build = new StringBuilder();
        build.append(" ").append(column).append(" IN (");
        Iterator<String> it = incompleteStatus.iterator();
        while (it.hasNext()) {
            String status = it.next();
            build.append("'").append(status).append("'");
            if (!it.hasNext()) continue;
            build.append(",");
        }
        build.append(") ");
        return build.toString();
    }

    public static List<EipTProjectMember> getProjectMember(Integer projectId) {
        List result = Database.query(EipTProjectMember.class).where(Operations.eq((String)"projectId", (Object)projectId)).fetchList();
        return result;
    }

    public static Map<String, String> getProjectMemberMap(Integer projectId) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<EipTProjectMember> result = ProjectUtils.getProjectMember(projectId);
        if (result.isEmpty()) {
            return map;
        }
        ArrayList<Integer> idList = new ArrayList<Integer>();
        for (EipTProjectMember member : result) {
            idList.add(member.getUserId());
        }
        List<ALEipUser> users = ProjectUtils.getALEipUsers(idList);
        for (EipTProjectMember member : result) {
            for (ALEipUser user : users) {
                if (user.getUserId().getValueWithInt() != member.getUserId().intValue()) continue;
                map.put(user.getUserId().toString(), user.getAliasName().toString());
            }
        }
        return map;
    }

    private static List<TurbineUser> getTurbineUsers(List<Integer> idList) {
        if (idList.isEmpty()) {
            return new ArrayList<TurbineUser>(0);
        }
        SelectQuery query = Database.query(TurbineUser.class);
        Expression inExp = ExpressionFactory.inDbExp((String)"USER_ID", idList);
        query.setQualifier(inExp);
        return query.fetchList();
    }

    private static List<ALEipUser> getALEipUsers(List<Integer> idList) {
        List<TurbineUser> list = ProjectUtils.getTurbineUsers(idList);
        ArrayList<ALEipUser> users = new ArrayList<ALEipUser>();
        for (TurbineUser user : list) {
            try {
                users.add(ALEipUtils.getALEipUser((TurbineUser)user));
            }
            catch (ALDBErrorException ignore) {}
        }
        return users;
    }
}

