/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.cache;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.configuration.Configuration;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.cache.CachedObject;
import org.apache.turbine.services.cache.GlobalCacheService;
import org.apache.turbine.services.cache.ObjectExpiredException;
import org.apache.turbine.services.cache.RefreshableCachedObject;
import org.apache.turbine.services.resources.TurbineResources;

public class TurbineGlobalCacheService
extends TurbineBaseService
implements GlobalCacheService,
Runnable {
    public static final int DEFAULT_INITIAL_CACHE_SIZE = 20;
    public static final String INITIAL_CACHE_SIZE = "cache.initial.size";
    public static final String CACHE_CHECK_FREQUENCY = "cache.check.frequency";
    public static final long DEFAULT_CACHE_CHECK_FREQUENCY = TurbineResources.getLong("cache.check.frequency", 5000L);
    private Hashtable cache = null;
    private long cacheCheckFrequency = DEFAULT_CACHE_CHECK_FREQUENCY;

    public void init() throws InitializationException {
        int cacheInitialSize = 20;
        Configuration conf = this.getConfiguration();
        if (conf != null) {
            try {
                cacheInitialSize = conf.getInt(INITIAL_CACHE_SIZE, 20);
                if (cacheInitialSize <= 0) {
                    throw new IllegalArgumentException("cache.initial.size must be >0");
                }
                this.cacheCheckFrequency = conf.getLong(CACHE_CHECK_FREQUENCY, DEFAULT_CACHE_CHECK_FREQUENCY);
                if (this.cacheCheckFrequency <= 0L) {
                    throw new IllegalArgumentException("cache.check.frequency must be >0");
                }
            }
            catch (Exception x) {
                throw new InitializationException("Failed to initialize TurbineGlobalCacheService", x);
            }
        }
        try {
            this.cache = new Hashtable(cacheInitialSize);
            Thread housekeeping = new Thread(this);
            housekeeping.setDaemon(true);
            housekeeping.start();
            this.setInit(true);
        }
        catch (Exception e) {
            throw new InitializationException("TurbineGlobalCacheService failed to initialize", e);
        }
    }

    public CachedObject getObject(String id) throws ObjectExpiredException {
        RefreshableCachedObject rco;
        CachedObject obj = null;
        boolean stale = false;
        obj = (CachedObject)this.cache.get(id);
        if (obj == null) {
            throw new ObjectExpiredException();
        }
        if (obj.isStale()) {
            if (obj instanceof RefreshableCachedObject) {
                rco = (RefreshableCachedObject)obj;
                if (rco.isUntouched()) {
                    throw new ObjectExpiredException();
                }
                rco.refresh();
                if (rco.isStale()) {
                    throw new ObjectExpiredException();
                }
            } else {
                throw new ObjectExpiredException();
            }
        }
        if (obj instanceof RefreshableCachedObject) {
            rco = (RefreshableCachedObject)obj;
            rco.touch();
        }
        return obj;
    }

    public void addObject(String id, CachedObject o) {
        if (this.cache.containsKey(id)) {
            this.cache.remove(id);
        }
        this.cache.put(id, o);
    }

    public void removeObject(String id) {
        this.cache.remove(id);
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(this.cacheCheckFrequency);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.clearCache();
        }
    }

    public void clearCache() {
        RefreshableCachedObject rco;
        CachedObject co;
        String key;
        Enumeration<Object> e;
        Vector<String> refreshThese = new Vector<String>(20);
        TurbineGlobalCacheService turbineGlobalCacheService = this;
        synchronized (turbineGlobalCacheService) {
            e = this.cache.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                co = (CachedObject)this.cache.get(key);
                if (co instanceof RefreshableCachedObject) {
                    rco = (RefreshableCachedObject)co;
                    if (rco.isUntouched()) {
                        this.cache.remove(key);
                        continue;
                    }
                    if (!rco.isStale()) continue;
                    refreshThese.addElement(key);
                    continue;
                }
                if (!co.isStale()) continue;
                this.cache.remove(key);
            }
        }
        e = refreshThese.elements();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            co = (CachedObject)this.cache.get(key);
            rco = (RefreshableCachedObject)co;
            rco.refresh();
        }
    }

    public int getNumberOfObjects() {
        return this.cache.size();
    }

    public int getCacheSize() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(this.cache);
        out.flush();
        int objectsize = baos.toByteArray().length - 4;
        return objectsize;
    }

    public void flushCache() {
        TurbineGlobalCacheService turbineGlobalCacheService = this;
        synchronized (turbineGlobalCacheService) {
            Enumeration e = this.cache.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                CachedObject co = (CachedObject)this.cache.get(key);
                this.cache.remove(key);
            }
        }
    }
}

