/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.db;

import java.sql.Connection;
import org.apache.torque.adapter.DB;
import org.apache.torque.map.DatabaseMap;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.db.MapBrokerService;
import org.apache.turbine.services.db.PoolBrokerService;
import org.apache.turbine.util.TurbineException;

public abstract class TurbineDB {
    public static String getDefaultMap() {
        try {
            return TurbineDB.getMapBroker().getDefaultMap();
        }
        catch (Exception exception) {
            return "default";
        }
    }

    public static DatabaseMap getDatabaseMap() throws TurbineException {
        return TurbineDB.getMapBroker().getDatabaseMap();
    }

    public static DatabaseMap getDatabaseMap(String name) throws TurbineException {
        return TurbineDB.getMapBroker().getDatabaseMap(name);
    }

    public static String getDefaultDB() {
        try {
            return TurbineDB.getPoolBroker().getDefaultDB();
        }
        catch (Exception exception) {
            return "default";
        }
    }

    public static Connection getConnection() throws Exception {
        return TurbineDB.getPoolBroker().getConnection();
    }

    public static Connection getConnection(String name) throws Exception {
        return TurbineDB.getPoolBroker().getConnection(name);
    }

    public static void releaseConnection(Connection dbconn) throws Exception {
        TurbineDB.getPoolBroker().releaseConnection(dbconn);
    }

    public static DB getDB() throws Exception {
        return TurbineDB.getPoolBroker().getDB();
    }

    public static DB getDB(String name) throws Exception {
        return TurbineDB.getPoolBroker().getDB(name);
    }

    private static MapBrokerService getMapBroker() {
        return (MapBrokerService)TurbineServices.getInstance().getService("MapBrokerService");
    }

    private static PoolBrokerService getPoolBroker() {
        return (PoolBrokerService)TurbineServices.getInstance().getService("PoolBrokerService");
    }
}

