/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake.model;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.apache.turbine.services.intake.model.Field;
import org.apache.turbine.services.intake.model.Group;
import org.apache.turbine.services.intake.validator.DateStringValidator;
import org.apache.turbine.services.intake.xmlmodel.XmlField;
import org.apache.turbine.util.ParameterParser;

public class DateStringField
extends Field {
    private DateFormat df = null;

    public DateStringField(XmlField field, Group group) throws Exception {
        super(field, group);
        if (this.validator == null) {
            this.df = DateFormat.getInstance();
            this.df.setLenient(true);
        }
    }

    protected String getDefaultValidator() {
        return "org.apache.turbine.services.intake.validator.DateStringValidator";
    }

    private Date getDate(String dateString) {
        Date date = null;
        try {
            date = this.df == null ? ((DateStringValidator)this.validator).parse(dateString) : this.df.parse(dateString);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date;
    }

    protected void doSetValue(ParameterParser pp) {
        if (this.isMultiValued) {
            String[] ss = pp.getStrings(this.getKey());
            Date[] dates = new Date[ss.length];
            int i = 0;
            while (i < ss.length) {
                dates[i] = this.getDate(ss[i]);
                ++i;
            }
            this.setTestValue(dates);
        } else {
            this.setTestValue(this.getDate(pp.getString(this.getKey())));
        }
    }

    protected void setDefaultValue(String prop) {
        this.defaultValue = prop;
    }
}

