/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.localization;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.turbine.services.localization.Localization;
import org.apache.turbine.services.pull.ApplicationTool;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;

public class LocalizationTool
implements ApplicationTool {
    protected Locale locale;
    private ResourceBundle bundle;
    private String bundleName;

    public LocalizationTool() {
        this.refresh();
    }

    public String get(String key) {
        try {
            return Localization.getString(this.getBundleName(null), this.getLocale(), key);
        }
        catch (MissingResourceException noKey) {
            Log.error(noKey);
            return null;
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected String getBundleName(Object data) {
        return Localization.getDefaultBundleName();
    }

    public final void init(Object data) {
        if (data instanceof RunData) {
            this.locale = Localization.getLocale(((RunData)data).getRequest());
            this.bundleName = this.getBundleName(data);
        }
    }

    public void refresh() {
        this.locale = null;
        this.bundle = null;
        this.bundleName = null;
    }
}

