/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.resources;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletConfig;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.turbine.Turbine;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.resources.ResourceService;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.TurbineConfig;
import org.apache.turbine.util.TurbineException;

public class TurbineResourceService
extends TurbineBaseService
implements ResourceService {
    private Configuration configuration = null;
    private static final String START_TOKEN = "${";
    private static final String END_TOKEN = "}";
    static /* synthetic */ Class class$org$apache$turbine$services$resources$TurbineResourceService;

    public void init(Object data) throws InitializationException {
        if (data instanceof ServletConfig) {
            this.init((ServletConfig)data);
        } else if (data instanceof Properties) {
            this.init((Properties)data);
        } else if (data instanceof Configuration) {
            this.init((Configuration)data);
        }
    }

    public void init() throws InitializationException {
        ServletConfig conf = Turbine.getTurbineServletConfig();
        this.init(conf);
    }

    public void init(ServletConfig config) throws InitializationException {
        String props = config.getInitParameter("properties");
        if (props == null) {
            props = "/WEB-INF/conf/TurbineResources.properties";
        }
        props = Turbine.getRealPath(props);
        try {
            this.init((Configuration)new PropertiesConfiguration(props));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new InitializationException("Can't load file " + props);
        }
    }

    public static void setPropertiesFileName(String propertiesFileName) throws TurbineException {
        BaseConfiguration mappings = new BaseConfiguration();
        mappings.setProperty("ResourceService", (Object)(class$org$apache$turbine$services$resources$TurbineResourceService == null ? (class$org$apache$turbine$services$resources$TurbineResourceService = TurbineResourceService.class$("org.apache.turbine.services.resources.TurbineResourceService")) : class$org$apache$turbine$services$resources$TurbineResourceService).getName());
        TurbineServices services = (TurbineServices)TurbineServices.getInstance();
        services.initMapping((Configuration)mappings);
        services.initServices(new TurbineConfig(".", propertiesFileName), true);
    }

    public static void setProperties(Properties properties) throws TurbineException {
        BaseConfiguration mappings = new BaseConfiguration();
        mappings.setProperty("ResourceService", (Object)(class$org$apache$turbine$services$resources$TurbineResourceService == null ? (class$org$apache$turbine$services$resources$TurbineResourceService = TurbineResourceService.class$("org.apache.turbine.services.resources.TurbineResourceService")) : class$org$apache$turbine$services$resources$TurbineResourceService).getName());
        TurbineServices services = (TurbineServices)TurbineServices.getInstance();
        services.initMapping((Configuration)mappings);
        services.initServices(properties, true);
    }

    public void setProperty(String key, String value) {
        this.configuration.setProperty(key, (Object)value);
    }

    protected String interpolate(String base) {
        if (base == null) {
            return null;
        }
        ResourceService top = TurbineResources.getService();
        int begin = -1;
        int end = -1;
        int prec = 0 - END_TOKEN.length();
        String variable = null;
        StringBuffer result = new StringBuffer();
        while ((begin = base.indexOf(START_TOKEN, prec + END_TOKEN.length())) > -1 && (end = base.indexOf(END_TOKEN, begin)) > -1) {
            result.append(base.substring(prec + END_TOKEN.length(), begin));
            variable = base.substring(begin + START_TOKEN.length(), end);
            if (top.getString(variable) != null) {
                result.append(top.getString(variable));
            }
            prec = end;
        }
        result.append(base.substring(prec + END_TOKEN.length(), base.length()));
        return result.toString();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    private void init(Configuration configuration) {
        this.configuration = configuration;
        this.setInit(true);
    }

    private void init(Properties props) {
        Configuration configuration = ConfigurationConverter.getConfiguration((Properties)props);
        this.init(configuration);
    }

    public boolean getBoolean(String name) {
        return this.getConfiguration().getBoolean(name);
    }

    public boolean getBoolean(String name, boolean def) {
        return this.getConfiguration().getBoolean(name, def);
    }

    public double getDouble(String name) {
        return this.getConfiguration().getDouble(name);
    }

    public double getDouble(String name, double def) {
        return this.getConfiguration().getDouble(name, def);
    }

    public float getFloat(String name) {
        return this.getConfiguration().getFloat(name);
    }

    public float getFloat(String name, float def) {
        return this.getConfiguration().getFloat(name, def);
    }

    public int getInt(String name) {
        return this.getConfiguration().getInt(name);
    }

    public int getInt(String name, int def) {
        return this.getConfiguration().getInt(name, def);
    }

    public Iterator getKeys() {
        return this.getConfiguration().getKeys();
    }

    public Iterator getKeys(String prefix) {
        return this.getConfiguration().getKeys(prefix);
    }

    public long getLong(String name) {
        return this.getConfiguration().getLong(name);
    }

    public long getLong(String name, long def) {
        return this.getConfiguration().getLong(name, def);
    }

    public String getString(String name) {
        return this.interpolate(this.getConfiguration().getString(name));
    }

    public String getString(String name, String def) {
        return this.interpolate(this.getConfiguration().getString(name, def));
    }

    public String[] getStringArray(String name) {
        String[] std = this.getConfiguration().getStringArray(name);
        if (std != null) {
            int i = 0;
            while (i < std.length) {
                std[i] = this.interpolate(std[i]);
                ++i;
            }
        }
        return std;
    }

    public Vector getVector(String name) {
        Vector<String> std = this.getConfiguration().getVector(name);
        if (std != null) {
            Vector<String> newstd = new Vector<String>();
            Enumeration en = std.elements();
            while (en.hasMoreElements()) {
                newstd.addElement(this.interpolate((String)en.nextElement()));
            }
            std = newstd;
        }
        return std;
    }

    public Vector getVector(String name, Vector def) {
        Vector<String> std = this.getVector(name);
        if (std == null && def != null) {
            std = new Vector<String>();
            Enumeration en = def.elements();
            while (en.hasMoreElements()) {
                std.addElement(this.interpolate((String)en.nextElement()));
            }
        }
        return std;
    }

    public ResourceService getResources(String prefix) {
        Configuration config = this.getConfiguration().subset(prefix);
        if (config == null) {
            return null;
        }
        TurbineResourceService res = new TurbineResourceService();
        res.init(config);
        return res;
    }

    public Configuration getConfiguration(String prefix) {
        Configuration config = this.getConfiguration().subset(prefix);
        if (config == null) {
            return null;
        }
        return config;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

