/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.schedule;

import java.sql.Connection;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import org.apache.torque.om.BaseObject;
import org.apache.torque.om.NumberKey;
import org.apache.torque.util.Criteria;
import org.apache.turbine.services.schedule.JobEntryPeer;

public class JobEntry
extends BaseObject
implements Comparable {
    private int second = -1;
    private int minute = -1;
    private int hour = -1;
    private int weekday = -1;
    private int day_of_month = -1;
    private String task = null;
    private long runtime = 0L;
    private String email = "";
    private boolean jobIsActive = false;
    private static final int SECOND = 0;
    private static final int MINUTE = 1;
    private static final int WEEK_DAY = 2;
    private static final int DAY_OF_MONTH = 3;
    private static final int DAILY = 4;
    private Hashtable jobProp = null;

    public JobEntry() {
    }

    public JobEntry(int sec, int min, int hour, int wd, int day_mo, String task) throws Exception {
        if (task == null || task.length() == 0) {
            throw new Exception("Error in JobEntry. Bad Job parameter. Task not set.");
        }
        this.second = sec;
        this.minute = min;
        this.hour = hour;
        this.weekday = wd;
        this.day_of_month = day_mo;
        this.task = task;
        this.calcRunTime();
    }

    public void calcRunTime() throws Exception {
        Calendar schedrun = Calendar.getInstance();
        Calendar now = Calendar.getInstance();
        switch (this.evaluateJobType()) {
            case 0: {
                schedrun.add(13, this.second);
                this.runtime = schedrun.getTime().getTime();
                break;
            }
            case 1: {
                schedrun.add(13, this.second);
                schedrun.add(12, this.minute);
                this.runtime = schedrun.getTime().getTime();
                break;
            }
            case 2: {
                schedrun.add(13, this.second);
                schedrun.set(12, this.minute);
                schedrun.set(11, this.hour);
                schedrun.set(7, this.weekday);
                if (now.before(schedrun)) {
                    this.runtime = schedrun.getTime().getTime();
                    break;
                }
                schedrun.add(7, 7);
                this.runtime = schedrun.getTime().getTime();
                break;
            }
            case 3: {
                schedrun.add(13, this.second);
                schedrun.set(12, this.minute);
                schedrun.set(11, this.hour);
                schedrun.set(5, this.day_of_month);
                if (now.before(schedrun)) {
                    this.runtime = schedrun.getTime().getTime();
                    break;
                }
                schedrun.add(2, 1);
                this.runtime = schedrun.getTime().getTime();
                break;
            }
            case 4: {
                schedrun.add(13, this.second);
                schedrun.set(12, this.minute);
                schedrun.set(11, this.hour);
                if (now.before(schedrun)) {
                    this.runtime = schedrun.getTime().getTime();
                    break;
                }
                schedrun.add(11, 24);
                this.runtime = schedrun.getTime().getTime();
                break;
            }
        }
    }

    public long getNextRuntime() {
        return this.runtime;
    }

    public String getNextRunAsString() {
        return new Date(this.runtime).toString();
    }

    public void setEmail(String mail) {
        this.email = mail;
        this.setModified(true);
    }

    public String getEmail() {
        if (this.email == null || this.email.length() == 0) {
            return "not set";
        }
        return this.email;
    }

    public String getTask() {
        return this.task;
    }

    public void setTask(String task) {
        this.task = task;
        this.setModified(true);
    }

    public int getSecond() {
        return this.second;
    }

    public void setSecond(int v) {
        this.second = v;
        this.setModified(true);
    }

    public int getMinute() {
        return this.minute;
    }

    public void setMinute(int v) {
        this.minute = v;
        this.setModified(true);
    }

    public int getHour() {
        return this.hour;
    }

    public void setHour(int v) {
        this.hour = v;
        this.setModified(true);
    }

    public int getWeekday() {
        return this.weekday;
    }

    public void setWeekday(int v) {
        this.weekday = v;
        this.setModified(true);
    }

    public int getDay_of_month() {
        return this.day_of_month;
    }

    public void setDay_of_month(int v) {
        this.day_of_month = v;
        this.setModified(true);
    }

    public void save() throws Exception {
        Criteria criteria = new Criteria(9).add(JobEntryPeer.SECOND, this.getSecond()).add(JobEntryPeer.MINUTE, this.getMinute()).add(JobEntryPeer.HOUR, this.getHour()).add(JobEntryPeer.WEEKDAY, this.getWeekday()).add(JobEntryPeer.DAY_OF_MONTH, this.getDay_of_month()).add(JobEntryPeer.TASK, (Object)this.getTask()).add(JobEntryPeer.EMAIL, (Object)this.getEmail()).add(JobEntryPeer.PROPERTY, (Object)this.getProperty());
        NumberKey nk = (NumberKey)this.getPrimaryKey();
        long key = 0L;
        if (nk != null) {
            key = ((NumberKey)this.getPrimaryKey()).getBigDecimal().longValue();
        }
        if (this.isModified() && key > 0L) {
            criteria.add(JobEntryPeer.OID, (Object)this.getPrimaryKey());
            JobEntryPeer.doUpdate(criteria);
            this.setModified(false);
        } else {
            this.setPrimaryKey(JobEntryPeer.doInsert(criteria));
        }
    }

    public void save(Connection conn) throws Exception {
        throw new Exception("not implemented");
    }

    public void save(String dbname) throws Exception {
        throw new Exception("not implemented");
    }

    private int evaluateJobType() throws Exception {
        if (this.day_of_month < 0) {
            if (this.weekday < 0) {
                if (this.hour < 0) {
                    if (this.minute < 0) {
                        if (this.second < 0) {
                            throw new Exception("Error in JobEntry. Bad Job parameter.");
                        }
                        return 0;
                    }
                    if (this.minute < 0 || this.second < 0) {
                        throw new Exception("Error in JobEntry. Bad Job parameter.");
                    }
                    return 1;
                }
                if (this.minute < 0 || this.hour < 0 || this.second < 0) {
                    throw new Exception("Error in JobEntry. Bad Job parameter.");
                }
                return 4;
            }
            if (this.minute < 0 || this.hour < 0 || this.second < 0) {
                throw new Exception("Error in JobEntry. Bad Job parameter.");
            }
            return 2;
        }
        if (this.minute < 0 || this.hour < 0) {
            throw new Exception("Error in JobEntry. Bad Job parameter.");
        }
        return 3;
    }

    public int compareTo(Object je) {
        long obj2Time;
        long obj1Time = this.getNextRuntime();
        if (obj1Time > (obj2Time = ((JobEntry)je).getNextRuntime())) {
            return 1;
        }
        if (obj1Time < obj2Time) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object je) {
        if (!(je instanceof JobEntry)) {
            return false;
        }
        return ((JobEntry)je).getPrimaryKey().equals(this.getPrimaryKey());
    }

    public void setActive(boolean isActive) {
        this.jobIsActive = isActive;
    }

    public boolean isActive() {
        return this.jobIsActive;
    }

    public void setProperty(Hashtable prop) {
        this.jobProp = prop;
        this.setModified(true);
    }

    public Hashtable getProperty() {
        if (this.jobProp == null) {
            return new Hashtable(89);
        }
        return this.jobProp;
    }
}

