/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.turbine.util.RunData;

public class HttpUtils {
    private static SimpleDateFormat httpDateFormat = new SimpleDateFormat("EEE, dd MMM yyyyy HH:mm:ss z", Locale.US);

    public static String formatHttpDate(Date date) {
        SimpleDateFormat simpleDateFormat = httpDateFormat;
        synchronized (simpleDateFormat) {
            String string = httpDateFormat.format(date);
            return string;
        }
    }

    public static void setCacheHeaders(RunData data, int expiry) {
        if (expiry == 0) {
            data.getResponse().setHeader("Pragma", "no-cache");
            data.getResponse().setHeader("Cache-Control", "no-cache");
            data.getResponse().setHeader("Expires", HttpUtils.formatHttpDate(new Date()));
        } else {
            Date expiryDate = new Date(System.currentTimeMillis() + (long)expiry);
            data.getResponse().setHeader("Expires", HttpUtils.formatHttpDate(expiryDate));
        }
    }

    static {
        httpDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

