/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.lateral.socket.tcp;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCache;
import org.apache.jcs.auxiliary.lateral.LateralCache;
import org.apache.jcs.auxiliary.lateral.LateralCacheAbstractManager;
import org.apache.jcs.auxiliary.lateral.LateralCacheAttributes;
import org.apache.jcs.auxiliary.lateral.LateralCacheMonitor;
import org.apache.jcs.auxiliary.lateral.LateralCacheNoWait;
import org.apache.jcs.auxiliary.lateral.LateralCacheWatchRepairable;
import org.apache.jcs.auxiliary.lateral.ZombieLateralCacheService;
import org.apache.jcs.auxiliary.lateral.ZombieLateralCacheWatch;
import org.apache.jcs.auxiliary.lateral.behavior.ILateralCacheListener;
import org.apache.jcs.auxiliary.lateral.behavior.ILateralCacheManager;
import org.apache.jcs.auxiliary.lateral.behavior.ILateralCacheService;
import org.apache.jcs.auxiliary.lateral.socket.tcp.LateralTCPListener;
import org.apache.jcs.auxiliary.lateral.socket.tcp.LateralTCPService;
import org.apache.jcs.auxiliary.lateral.socket.tcp.behavior.ITCPLateralCacheAttributes;
import org.apache.jcs.engine.behavior.ICompositeCacheManager;

public class LateralTCPCacheManager
extends LateralCacheAbstractManager {
    private static final long serialVersionUID = -9213011856644392480L;
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$lateral$socket$tcp$LateralTCPCacheManager == null ? (class$org$apache$jcs$auxiliary$lateral$socket$tcp$LateralTCPCacheManager = LateralTCPCacheManager.class$("org.apache.jcs.auxiliary.lateral.socket.tcp.LateralTCPCacheManager")) : class$org$apache$jcs$auxiliary$lateral$socket$tcp$LateralTCPCacheManager));
    private static LateralCacheMonitor monitor;
    protected static Map instances;
    protected ITCPLateralCacheAttributes lca;
    private int clients;
    private ILateralCacheService lateralService;
    private LateralCacheWatchRepairable lateralWatch;
    private ICompositeCacheManager cacheMgr;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$lateral$socket$tcp$LateralTCPCacheManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LateralTCPCacheManager getInstance(ITCPLateralCacheAttributes lca, ICompositeCacheManager cacheMgr) {
        LateralTCPCacheManager ins = (LateralTCPCacheManager)instances.get(lca.toString());
        Map map = instances;
        synchronized (map) {
            if (ins == null) {
                log.info((Object)("Instance for [" + lca.toString() + "] is null, creating"));
                ins = (LateralTCPCacheManager)instances.get(lca.toString());
                if (ins == null) {
                    ins = new LateralTCPCacheManager(lca, cacheMgr);
                    instances.put(lca.toString(), ins);
                }
            }
            LateralTCPCacheManager.createMonitor(ins);
        }
        ++ins.clients;
        return ins;
    }

    private static synchronized void createMonitor(ILateralCacheManager instance) {
        if (monitor == null && (monitor = new LateralCacheMonitor(instance)) != null) {
            Thread t = new Thread(monitor);
            t.setDaemon(true);
            t.start();
        }
    }

    private LateralTCPCacheManager(ITCPLateralCacheAttributes lcaA, ICompositeCacheManager cacheMgr) {
        this.lca = lcaA;
        this.cacheMgr = cacheMgr;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating lateral cache service, lca = " + this.lca));
        }
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)("Creating TCP service, lca = " + this.lca));
            }
            this.lateralService = new LateralTCPService(this.lca);
            if (this.lateralService == null) {
                log.error((Object)"No service created, must zombie");
                throw new Exception("No service created for lateral cache.");
            }
            this.lateralWatch = new LateralCacheWatchRepairable();
            this.lateralWatch.setCacheWatch(new ZombieLateralCacheWatch());
        }
        catch (Exception ex) {
            log.error((Object)"Failure, lateral instance will use zombie service", (Throwable)ex);
            this.lateralService = new ZombieLateralCacheService();
            this.lateralWatch = new LateralCacheWatchRepairable();
            this.lateralWatch.setCacheWatch(new ZombieLateralCacheWatch());
            LateralTCPCacheManager.createMonitor(this);
            monitor.notifyError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLateralCacheListener(String cacheName, ILateralCacheListener listener) throws IOException {
        Map map = this.caches;
        synchronized (map) {
            this.lateralWatch.addCacheListener(cacheName, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuxiliaryCache getCache(String cacheName) {
        LateralCacheNoWait lateralNoWait = null;
        Map map = this.caches;
        synchronized (map) {
            lateralNoWait = (LateralCacheNoWait)this.caches.get(cacheName);
            if (lateralNoWait == null) {
                LateralCacheAttributes attr = (LateralCacheAttributes)this.lca.copy();
                attr.setCacheName(cacheName);
                LateralCache cache = new LateralCache(attr, this.lateralService, monitor);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Created cache for noWait, cache [" + cache + "]"));
                }
                lateralNoWait = new LateralCacheNoWait(cache);
                this.caches.put(cacheName, lateralNoWait);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Created LateralCacheNoWait for [" + this.lca + "] LateralCacheNoWait = [" + lateralNoWait + "]"));
                }
            }
        }
        if (this.lca.isReceive()) {
            try {
                this.addLateralCacheListener(cacheName, LateralTCPListener.getInstance(this.lca, this.cacheMgr));
            }
            catch (IOException ioe) {
                log.error((Object)"Problem creating lateral listener", (Throwable)ioe);
            }
            catch (Exception e) {
                log.error((Object)"Problem creating lateral listener", (Throwable)e);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Not creating a listener since we are not receiving.");
        }
        return lateralNoWait;
    }

    public Map getInstances() {
        return instances;
    }

    public Object fixService() throws IOException {
        LateralTCPService service = null;
        try {
            service = new LateralTCPService(this.lca);
        }
        catch (Exception ex) {
            log.error((Object)("Can't fix " + ex.getMessage()));
            throw new IOException("Can't fix " + ex.getMessage());
        }
        return service;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        instances = new HashMap();
    }
}

