/*
 * Decompiled with CFR 0.152.
 */
package org.josql.functions;

import com.gentlyweb.utils.Getter;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.josql.QueryExecutionException;
import org.josql.expressions.Expression;
import org.josql.functions.AbstractFunctionHandler;

public class MiscellaneousFunctions
extends AbstractFunctionHandler {
    public static final String HANDLER_ID = "_internal_misc";
    private Map accessorCache = new HashMap();
    private Random rand = new Random();

    public Date now(boolean zeroTime) {
        Date d = null;
        if (zeroTime) {
            Calendar c = Calendar.getInstance();
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
            d = c.getTime();
        } else {
            d = new Date();
        }
        return d;
    }

    public void cache(List allobjs, Getter get) throws QueryExecutionException {
        int s = allobjs.size();
        for (int i = 0; i < s; ++i) {
            Object o = allobjs.get(i);
            try {
                this.q.setSaveValue(o, get.getValue(o));
                continue;
            }
            catch (Exception e) {
                throw new QueryExecutionException("Unable to get value from accessor: " + get + " from object: " + i, e);
            }
        }
    }

    public void cache(List allobjs, Expression exp) throws QueryExecutionException {
        Object co = this.q.getCurrentObject();
        int s = allobjs.size();
        for (int i = 0; i < s; ++i) {
            Object o = allobjs.get(i);
            this.q.setCurrentObject(o);
            try {
                this.q.setSaveValue(o, exp.getValue(o, this.q));
                continue;
            }
            catch (Exception e) {
                throw new QueryExecutionException("Unable to get value from expression: " + exp + " from object: " + i, e);
            }
        }
        this.q.setCurrentObject(co);
    }

    public double abs(Number d) {
        return Math.abs(d.doubleValue());
    }

    public int random() {
        return this.rand.nextInt();
    }

    public int random(Number n) {
        return this.rand.nextInt(n.intValue());
    }

    public double randomDouble() {
        return this.rand.nextDouble();
    }

    public Object saveValue(Object saveValueName) {
        return this.q.getSaveValue(saveValueName);
    }

    public Object savevalue(Object saveValueName) {
        return this.q.getSaveValue(saveValueName);
    }

    public Object save_value(Object saveValueName) {
        return this.q.getSaveValue(saveValueName);
    }

    public String fileExtension(Object f) {
        if (f == null) {
            return null;
        }
        String n = null;
        if (f instanceof String) {
            n = (String)f;
        }
        if (f instanceof File) {
            File fi = (File)f;
            if (fi.isDirectory()) {
                return null;
            }
            n = ((File)f).getName();
        }
        return n.substring(n.lastIndexOf(".") + 1);
    }

    public Object accessor(Expression oExp, Expression accExp) throws Exception {
        Object o = null;
        try {
            o = oExp.getValue(this.q.getCurrentObject(), this.q);
        }
        catch (Exception e) {
            throw new QueryExecutionException("Unable to evaluate expression: " + oExp + " to get object.");
        }
        Object a = null;
        try {
            a = accExp.getValue(this.q.getCurrentObject(), this.q);
        }
        catch (Exception e) {
            throw new QueryExecutionException("Unable to evaluate expression: " + accExp + " to get accessor.");
        }
        if (a == null) {
            throw new QueryExecutionException("Accessor expression: " + accExp + " evaluates to null for object: " + o + " returned from expression: " + oExp);
        }
        return this.accessor(o, a.toString());
    }

    public Object accessor(Object o, String acc) throws Exception {
        if (o == null) {
            return null;
        }
        Getter g = (Getter)this.accessorCache.get(o.getClass().getName() + acc);
        if (g == null) {
            g = new Getter(acc, o.getClass());
            this.accessorCache.put(o.getClass().getName() + acc, g);
        }
        return g.getValue(o);
    }

    public Object ifThen(Expression ifcond, Expression thenVal) throws QueryExecutionException {
        if (ifcond.isTrue(this.q.getCurrentObject(), this.q)) {
            return thenVal.getValue(this.q.getCurrentObject(), this.q);
        }
        return null;
    }

    public Object ifThenElse(Expression ifcond, Expression thenVal, Expression elseVal) throws QueryExecutionException {
        Object i = this.ifThen(ifcond, thenVal);
        if (i == null) {
            return elseVal.getValue(this.q.getCurrentObject(), this.q);
        }
        return i;
    }

    public Object eval(Expression exp) throws QueryExecutionException {
        return exp.getValue(this.q.getCurrentObject(), this.q);
    }

    public Boolean instanceOf(Expression obj, Expression clazz) throws QueryExecutionException {
        return clazz.getValue(this.q.getCurrentObject(), this.q).getClass().isInstance(obj.getValue(this.q.getCurrentObject(), this.q));
    }
}

