/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.base.Equivalence;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.transform.TransformUpstreamDependencies;
import org.gradle.api.internal.artifacts.transform.TransformUpstreamDependenciesResolver;
import org.gradle.api.internal.artifacts.transform.Transformation;
import org.gradle.api.internal.artifacts.transform.TransformationNode;
import org.gradle.api.internal.artifacts.transform.TransformationNodeRegistry;
import org.gradle.api.internal.artifacts.transform.TransformationStep;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.operations.BuildOperationExecutor;

public class DefaultTransformationNodeRegistry
implements TransformationNodeRegistry {
    private final Map<ArtifactTransformKey, TransformationNode> transformations = Maps.newConcurrentMap();
    private final BuildOperationExecutor buildOperationExecutor;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;

    public DefaultTransformationNodeRegistry(BuildOperationExecutor buildOperationExecutor, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
    }

    @Override
    public Collection<TransformationNode> getOrCreate(ResolvedArtifactSet artifactSet, Transformation transformation, TransformUpstreamDependenciesResolver dependenciesResolver) {
        List<Equivalence.Wrapper<TransformationStep>> transformationChain = DefaultTransformationNodeRegistry.unpackTransformation(transformation);
        ImmutableList.Builder builder = ImmutableList.builder();
        artifactSet.visitLocalArtifacts(artifact -> {
            TransformationNode transformationNode = this.getOrCreateInternal(artifact, transformationChain, dependenciesResolver);
            builder.add((Object)transformationNode);
        });
        return builder.build();
    }

    private TransformationNode getOrCreateInternal(ResolvableArtifact artifact, List<Equivalence.Wrapper<TransformationStep>> transformationChain, TransformUpstreamDependenciesResolver dependenciesResolver) {
        ArtifactTransformKey key = new ArtifactTransformKey(artifact.getId(), transformationChain);
        TransformationNode transformationNode = this.transformations.get(key);
        if (transformationNode == null) {
            if (transformationChain.size() == 1) {
                TransformationStep transformationStep = (TransformationStep)transformationChain.get(0).get();
                TransformUpstreamDependencies upstreamDependencies = dependenciesResolver.dependenciesFor(transformationStep);
                transformationNode = TransformationNode.initial(transformationStep, artifact, upstreamDependencies, this.buildOperationExecutor, this.calculatedValueContainerFactory);
            } else {
                TransformationNode previous = this.getOrCreateInternal(artifact, transformationChain.subList(0, transformationChain.size() - 1), dependenciesResolver);
                TransformationStep transformationStep = (TransformationStep)transformationChain.get(transformationChain.size() - 1).get();
                TransformUpstreamDependencies upstreamDependencies = dependenciesResolver.dependenciesFor(transformationStep);
                transformationNode = TransformationNode.chained(transformationStep, previous, upstreamDependencies, this.buildOperationExecutor, this.calculatedValueContainerFactory);
            }
            this.transformations.put(key, transformationNode);
        }
        return transformationNode;
    }

    private static List<Equivalence.Wrapper<TransformationStep>> unpackTransformation(Transformation transformation) {
        ImmutableList.Builder builder = ImmutableList.builder();
        transformation.visitTransformationSteps((Action<? super TransformationStep>)((Action)transformation1 -> builder.add((Object)TransformationStep.FOR_SCHEDULING.wrap(transformation1))));
        return builder.build();
    }

    private static class ArtifactTransformKey {
        private final Object artifactSetId;
        private final List<Equivalence.Wrapper<TransformationStep>> transformations;

        private ArtifactTransformKey(Object artifactSetId, List<Equivalence.Wrapper<TransformationStep>> transformations) {
            this.artifactSetId = artifactSetId;
            this.transformations = transformations;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArtifactTransformKey that = (ArtifactTransformKey)o;
            if (!this.artifactSetId.equals(that.artifactSetId)) {
                return false;
            }
            return this.transformations.equals(that.transformations);
        }

        public int hashCode() {
            int result = this.artifactSetId.hashCode();
            result = 31 * result + this.transformations.hashCode();
            return result;
        }
    }
}

