/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.console;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.events.PromptOutputEvent;
import org.gradle.internal.logging.events.UserInputRequestEvent;
import org.gradle.internal.logging.events.UserInputResumeEvent;

public abstract class AbstractUserInputRenderer
implements OutputEventListener {
    final OutputEventListener delegate;
    private final List<OutputEvent> eventQueue = new ArrayList<OutputEvent>();
    private boolean paused;

    public AbstractUserInputRenderer(OutputEventListener delegate) {
        this.delegate = delegate;
    }

    @Override
    public void onOutput(OutputEvent event) {
        if (event instanceof UserInputRequestEvent) {
            this.handleUserInputRequestEvent();
            return;
        }
        if (event instanceof UserInputResumeEvent) {
            this.handleUserInputResumeEvent();
            return;
        }
        if (event instanceof PromptOutputEvent) {
            this.handlePrompt((PromptOutputEvent)event);
            return;
        }
        if (this.paused) {
            this.eventQueue.add(event);
            return;
        }
        this.delegate.onOutput(event);
    }

    private void handleUserInputRequestEvent() {
        this.startInput();
        this.paused = true;
    }

    private void handleUserInputResumeEvent() {
        if (!this.paused) {
            throw new IllegalStateException("Cannot resume user input if not paused yet");
        }
        this.paused = false;
        this.finishInput();
        this.replayEvents();
    }

    private void replayEvents() {
        ListIterator<OutputEvent> iterator = this.eventQueue.listIterator();
        while (iterator.hasNext()) {
            this.delegate.onOutput(iterator.next());
            iterator.remove();
        }
    }

    List<OutputEvent> getEventQueue() {
        return this.eventQueue;
    }

    abstract void startInput();

    abstract void handlePrompt(PromptOutputEvent var1);

    abstract void finishInput();
}

