/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.JsLoweredDeclarationOrigin;
import org.jetbrains.kotlin.ir.backend.js.lower.serialization.ir.JsManglerIr;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.BackingFieldSignature;
import org.jetbrains.kotlin.ir.backend.js.utils.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTable;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTablesKt;
import org.jetbrains.kotlin.ir.backend.js.utils.ParameterTypeBasedSignature;
import org.jetbrains.kotlin.ir.backend.js.utils.Signature;
import org.jetbrains.kotlin.ir.backend.js.utils.StableNameSignature;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrFunctionKt;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.InlineClassesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.naming.NameSuggestionKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0019\u0010\u0007\u001a\u00020\b\"\u0004\b\u0000\u0010\t2\u0006\u0010\u0005\u001a\u0002H\t\u00a2\u0006\u0002\u0010\n\u001a\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b\u001a\u0010\u0010\r\u001a\u00020\b*\b\u0012\u0004\u0012\u00020\u000f0\u000e\u001a\u0012\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u000f\u00a8\u0006\u0013"}, d2={"fieldSignature", "Lorg/jetbrains/kotlin/ir/backend/js/utils/Signature;", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "functionSignature", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "mapToKey", "", "T", "(Ljava/lang/Object;)Ljava/lang/String;", "sanitizeName", "name", "dump", "Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTable;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "isPublic", "", "Lorg/jetbrains/kotlin/ir/backend/js/lower/serialization/ir/JsManglerIr;", "backend.js"})
public final class NameTablesKt {
    @NotNull
    public static final <T> String mapToKey(T declaration2) {
        JsManglerIr jsManglerIr = JsManglerIr.INSTANCE;
        boolean bl = false;
        boolean bl2 = false;
        JsManglerIr $this$with = jsManglerIr;
        boolean bl3 = false;
        return declaration2 instanceof IrDeclaration && NameTablesKt.isPublic($this$with, (IrDeclaration)declaration2) ? String.valueOf($this$with.getHashedMangle((IrDeclaration)declaration2)) : (declaration2 instanceof Signature ? String.valueOf($this$with.getHashMangle(declaration2.toString())) : "key_have_not_generated");
    }

    public static final boolean isPublic(@NotNull JsManglerIr $this$isPublic, @NotNull IrDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)$this$isPublic, (String)"$this$isPublic");
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        return $this$isPublic.isExported(declaration2) && !(declaration2 instanceof IrScript) && !(declaration2 instanceof IrVariable) && !(declaration2 instanceof IrValueParameter);
    }

    @NotNull
    public static final String dump(@NotNull NameTable<IrDeclaration> $this$dump) {
        Intrinsics.checkNotNullParameter($this$dump, (String)"$this$dump");
        return "Names: \n" + CollectionsKt.joinToString$default((Iterable)MapsKt.toList($this$dump.getNames()), (CharSequence)"\n", null, null, (int)0, null, (Function1)dump.1.INSTANCE, (int)30, null);
    }

    @NotNull
    public static final Signature fieldSignature(@NotNull IrField field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        if (IrUtilsKt.isEffectivelyExternal(field)) {
            String string2 = field.getName().getIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"field.name.identifier");
            return new StableNameSignature(string2);
        }
        return new BackingFieldSignature(field);
    }

    @NotNull
    public static final Signature functionSignature(@NotNull IrFunction declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        boolean bl = !IrFunctionKt.isStaticMethodOfClass(declaration2);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        bl = declaration2.getDispatchReceiverParameter() != null;
        bl2 = false;
        bl3 = false;
        bl3 = false;
        bl4 = false;
        if (!bl) {
            boolean bl6 = false;
            String string3 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string3.toString());
        }
        String string4 = AnnotationUtilsKt.getJsNameOrKotlinName(declaration2).asString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"declaration.getJsNameOrKotlinName().asString()");
        String declarationName = string4;
        StableNameSignature stableName = new StableNameSignature(declarationName);
        if (Intrinsics.areEqual((Object)declaration2.getOrigin(), (Object)JsLoweredDeclarationOrigin.BRIDGE_TO_EXTERNAL_FUNCTION.INSTANCE)) {
            return stableName;
        }
        if (IrUtilsKt.isEffectivelyExternal(declaration2)) {
            return stableName;
        }
        if (AnnotationUtilsKt.getJsName(declaration2) != null) {
            return stableName;
        }
        if (declaration2 instanceof IrSimpleFunction && org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isMethodOfAny((IrSimpleFunction)declaration2)) {
            return stableName;
        }
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append(declarationName);
        Object $this$ifNotEmpty$iv = declaration2.getTypeParameters();
        boolean $i$f$ifNotEmpty = false;
        Collection collection = $this$ifNotEmpty$iv;
        boolean bl7 = false;
        if (!collection.isEmpty()) {
            List $this$ifNotEmpty = (List)$this$ifNotEmpty$iv;
            boolean bl8 = false;
            nameBuilder.append("_$t");
            StringBuilder cfr_ignored_0 = (StringBuilder)CollectionsKt.joinTo$default((Iterable)$this$ifNotEmpty, (Appendable)nameBuilder, (CharSequence)"", null, null, (int)0, null, (Function1)functionSignature.1.1.INSTANCE, (int)60, null);
        }
        IrValueParameter irValueParameter = declaration2.getExtensionReceiverParameter();
        if (irValueParameter != null) {
            $this$ifNotEmpty$iv = irValueParameter;
            $i$f$ifNotEmpty = false;
            boolean bl9 = false;
            Object it = $this$ifNotEmpty$iv;
            boolean bl10 = false;
            nameBuilder.append("_r$" + IrTypeUtilsKt.asString(((IrValueDeclaration)it).getType()));
        }
        $this$ifNotEmpty$iv = declaration2.getValueParameters();
        $i$f$ifNotEmpty = false;
        Object object = $this$ifNotEmpty$iv;
        boolean it = false;
        if (!object.isEmpty()) {
            List $this$ifNotEmpty = (List)$this$ifNotEmpty$iv;
            boolean bl11 = false;
            StringBuilder cfr_ignored_1 = (StringBuilder)CollectionsKt.joinTo$default((Iterable)$this$ifNotEmpty, (Appendable)nameBuilder, (CharSequence)"", null, null, (int)0, null, (Function1)functionSignature.3.1.INSTANCE, (int)60, null);
        }
        $this$ifNotEmpty$iv = declaration2.getReturnType();
        boolean bl12 = false;
        boolean bl13 = false;
        Object it2 = $this$ifNotEmpty$iv;
        boolean bl14 = false;
        if (InlineClassesKt.isInlined((IrType)it2) || IrTypePredicatesKt.isUnit((IrType)it2)) {
            nameBuilder.append("_ret$" + IrTypeUtilsKt.asString((IrType)it2));
        }
        String string5 = nameBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"nameBuilder.toString()");
        String signature2 = string5;
        return new ParameterTypeBasedSignature(signature2, declarationName);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String sanitizeName(@NotNull String name) {
        Collection<Character> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        CharSequence charSequence = name;
        char c = '\u0000';
        if (charSequence.length() == 0) {
            return "_";
        }
        c = StringsKt.first((CharSequence)name);
        boolean bl = false;
        boolean bl2 = false;
        char it = c;
        boolean bl3 = false;
        char first = NameSuggestionKt.isES5IdentifierStart(it) ? it : (char)'_';
        CharSequence charSequence2 = StringsKt.drop((String)name, (int)1);
        StringBuilder stringBuilder2 = new StringBuilder().append(String.valueOf(first));
        boolean $i$f$map = false;
        void var4_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length());
        boolean $i$f$mapTo = false;
        void var7_12 = $this$mapTo$iv$iv;
        for (int i = 0; i < var7_12.length(); ++i) {
            char it2;
            char item$iv$iv;
            char c2 = item$iv$iv = var7_12.charAt(i);
            collection = destination$iv$iv;
            boolean bl4 = false;
            Character c3 = Character.valueOf(NameSuggestionKt.isES5IdentifierPart(it2) ? it2 : (char)'_');
            collection.add(c3);
        }
        collection = (List)destination$iv$iv;
        return stringBuilder2.append(CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)"", null, null, (int)0, null, null, (int)62, null)).toString();
    }
}

