"""Switch to mautrix-python crypto

Revision ID: 4567a7c4de97
Revises: ab5435bd192e
Create Date: 2020-07-08 19:03:10.583277

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '4567a7c4de97'
down_revision = 'ab5435bd192e'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('nio_account')
    op.drop_table('nio_device_key')
    op.drop_table('nio_outgoing_key_request')
    op.drop_table('nio_olm_session')
    op.drop_table('nio_megolm_inbound_session')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('nio_megolm_inbound_session',
    sa.Column('session_id', sa.VARCHAR(length=255), autoincrement=False, nullable=False),
    sa.Column('sender_key', sa.VARCHAR(length=255), autoincrement=False, nullable=False),
    sa.Column('fp_key', sa.VARCHAR(length=255), autoincrement=False, nullable=False),
    sa.Column('room_id', sa.VARCHAR(length=255), autoincrement=False, nullable=False),
    sa.Column('session', postgresql.BYTEA(), autoincrement=False, nullable=False),
    sa.Column('forwarded_chains', postgresql.BYTEA(), autoincrement=False, nullable=False),
    sa.PrimaryKeyConstraint('session_id', name='nio_megolm_inbound_session_pkey')
    )
    op.create_table('nio_olm_session',
    sa.Column('session_id', sa.VARCHAR(length=255), autoincrement=False, nullable=False),
    sa.Column('sender_key', sa.VARCHAR(length=255), autoincrement=False, nullable=False),
    sa.Column('session', postgresql.BYTEA(), autoincrement=False, nullable=False),
    sa.Column('created_at', postgresql.TIMESTAMP(), autoincrement=False, nullable=False),
    sa.Column('last_used', postgresql.TIMESTAMP(), autoincrement=False, nullable=False),
    sa.PrimaryKeyConstraint('session_id', name='nio_olm_session_pkey')
    )
    op.create_table('nio_outgoing_key_request',
    sa.Column('request_id', sa.VARCHAR(length=255), autoincrement=False, nullable=False),
    sa.Column('session_id', sa.VARCHAR(length=255), autoincrement=False, nullable=False),
    sa.Column('room_id', sa.VARCHAR(length=255), autoincrement=False, nullable=False),
    sa.Column('algorithm', sa.VARCHAR(length=255), autoincrement=False, nullable=False),
    sa.PrimaryKeyConstraint('request_id', name='nio_outgoing_key_request_pkey')
    )
    op.create_table('nio_device_key',
    sa.Column('user_id', sa.VARCHAR(length=255), autoincrement=False, nullable=False),
    sa.Column('device_id', sa.VARCHAR(length=255), autoincrement=False, nullable=False),
    sa.Column('display_name', sa.VARCHAR(length=255), autoincrement=False, nullable=False),
    sa.Column('deleted', sa.BOOLEAN(), autoincrement=False, nullable=False),
    sa.Column('keys', postgresql.BYTEA(), autoincrement=False, nullable=False),
    sa.PrimaryKeyConstraint('user_id', 'device_id', name='nio_device_key_pkey')
    )
    op.create_table('nio_account',
    sa.Column('user_id', sa.VARCHAR(length=255), autoincrement=False, nullable=False),
    sa.Column('device_id', sa.VARCHAR(length=255), autoincrement=False, nullable=False),
    sa.Column('shared', sa.BOOLEAN(), autoincrement=False, nullable=False),
    sa.Column('sync_token', sa.TEXT(), autoincrement=False, nullable=False),
    sa.Column('account', postgresql.BYTEA(), autoincrement=False, nullable=False),
    sa.PrimaryKeyConstraint('user_id', 'device_id', name='nio_account_pkey')
    )
    # ### end Alembic commands ###
