/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.perspective.persist.xml;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import org.flexdock.perspective.persist.xml.ISerializer;
import org.flexdock.perspective.persist.xml.SerializerRegistry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RectangleSerializer
implements ISerializer {
    public Element serialize(Document document, Object object) {
        Rectangle rectangle = (Rectangle)object;
        Element rectangleElement = document.createElement("Rectangle");
        ISerializer pointSerializer = SerializerRegistry.getSerializer(Point.class);
        ISerializer dimensionSerializer = SerializerRegistry.getSerializer(Dimension.class);
        Element pointElement = pointSerializer.serialize(document, rectangle.getLocation());
        Element dimensionElement = dimensionSerializer.serialize(document, rectangle.getSize());
        rectangleElement.appendChild(pointElement);
        rectangleElement.appendChild(dimensionElement);
        return rectangleElement;
    }

    public Object deserialize(Element element) {
        NodeList pointNodeList;
        ISerializer pointSerializer = SerializerRegistry.getSerializer(Point.class);
        ISerializer dimensionSerializer = SerializerRegistry.getSerializer(Dimension.class);
        Rectangle rectangle = new Rectangle();
        NodeList dimenstionNodeList = element.getElementsByTagName("Dimension");
        if (dimenstionNodeList.getLength() > 0 && dimenstionNodeList.item(0) instanceof Element) {
            Element dimensionElement = (Element)dimenstionNodeList.item(0);
            Dimension dimension = (Dimension)dimensionSerializer.deserialize(dimensionElement);
            rectangle.setSize(dimension);
        }
        if ((pointNodeList = element.getElementsByTagName("Point")).getLength() > 0 && pointNodeList.item(0) instanceof Element) {
            Element pointElement = (Element)pointNodeList.item(0);
            Point point = (Point)pointSerializer.deserialize(pointElement);
            rectangle.setLocation(point);
        }
        return rectangle;
    }
}

