/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.parsers;

import gnu.xml.dom.DomDocumentBuilderFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class DocumentBuilderFactory {
    private boolean namespaceAware;
    private boolean validating;
    private boolean ignoringElementContentWhitespace;
    private boolean expandEntityReferences;
    private boolean ignoringComments;
    private boolean coalescing;
    private Schema schema;
    private boolean xIncludeAware;
    static /* synthetic */ Class class$javax$xml$parsers$DocumentBuilderFactory;

    public static DocumentBuilderFactory newInstance() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            Class clazz = class$javax$xml$parsers$DocumentBuilderFactory;
            if (clazz == null) {
                clazz = class$javax$xml$parsers$DocumentBuilderFactory = DocumentBuilderFactory.class("[Ljavax.xml.parsers.DocumentBuilderFactory;", false);
            }
            classLoader = clazz.getClassLoader();
        }
        String string = null;
        int n = 0;
        do {
            if ((string = DocumentBuilderFactory.getFactoryClassName(classLoader, n++)) == null) continue;
            try {
                Class clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
                return (DocumentBuilderFactory)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                string = null;
            }
            catch (Exception exception) {
                throw new FactoryConfigurationError(exception, "error instantiating class " + string);
            }
        } while (string == null && n < 3);
        return new DomDocumentBuilderFactory();
    }

    private static final String getFactoryClassName(ClassLoader classLoader, int n) {
        switch (n) {
            case 0: {
                return System.getProperty("javax.xml.parsers.DocumentBuilderFactory");
            }
            case 1: {
                try {
                    File file = new File(System.getProperty("java.home"));
                    file = new File(file, "lib");
                    file = new File(file, "jaxp.properties");
                    FileInputStream fileInputStream = new FileInputStream(file);
                    Properties properties = new Properties();
                    properties.load(fileInputStream);
                    ((InputStream)fileInputStream).close();
                    return properties.getProperty("javax.xml.parsers.DocumentBuilderFactory");
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            case 2: {
                try {
                    InputStream inputStream;
                    InputStream inputStream2;
                    String string = "/META-INF/services/javax.xml.parsers.DocumentBuilderFactory";
                    if (classLoader != null) {
                        inputStream2 = classLoader.getResourceAsStream(string);
                    } else {
                        Class clazz = class$javax$xml$parsers$DocumentBuilderFactory;
                        if (clazz == null) {
                            clazz = class$javax$xml$parsers$DocumentBuilderFactory = DocumentBuilderFactory.class("[Ljavax.xml.parsers.DocumentBuilderFactory;", false);
                        }
                        inputStream2 = inputStream = clazz.getResourceAsStream(string);
                    }
                    if (inputStream != null) {
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                        String string2 = bufferedReader.readLine();
                        bufferedReader.close();
                        return string2;
                    }
                }
                catch (IOException iOException) {}
                return null;
            }
        }
        return null;
    }

    public abstract DocumentBuilder newDocumentBuilder() throws ParserConfigurationException;

    public void setNamespaceAware(boolean bl) {
        this.namespaceAware = bl;
    }

    public void setValidating(boolean bl) {
        this.validating = bl;
    }

    public void setIgnoringElementContentWhitespace(boolean bl) {
        this.ignoringElementContentWhitespace = bl;
    }

    public void setExpandEntityReferences(boolean bl) {
        this.expandEntityReferences = bl;
    }

    public void setIgnoringComments(boolean bl) {
        this.ignoringComments = bl;
    }

    public void setCoalescing(boolean bl) {
        this.coalescing = bl;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public boolean isIgnoringElementContentWhitespace() {
        return this.ignoringElementContentWhitespace;
    }

    public boolean isExpandEntityReferences() {
        return this.expandEntityReferences;
    }

    public boolean isIgnoringComments() {
        return this.ignoringComments;
    }

    public boolean isCoalescing() {
        return this.coalescing;
    }

    public abstract void setAttribute(String var1, Object var2) throws IllegalArgumentException;

    public abstract Object getAttribute(String var1) throws IllegalArgumentException;

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public boolean isXIncludeAware() {
        return this.xIncludeAware;
    }

    public void setXIncludeAware(boolean bl) {
        this.xIncludeAware = bl;
    }

    public abstract void setFeature(String var1, boolean var2) throws ParserConfigurationException;

    public abstract boolean getFeature(String var1) throws ParserConfigurationException;

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.expandEntityReferences = true;
    }

    protected DocumentBuilderFactory() {
        this.this();
    }
}

