/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.WaitableResult;

public class ProxyLookup
extends Lookup {
    private ImmutableInternalData data;

    public ProxyLookup(Lookup ... lookups) {
        this.data = ImmutableInternalData.EMPTY.setLookupsNoFire(lookups, true);
    }

    protected ProxyLookup() {
        this.data = ImmutableInternalData.EMPTY;
    }

    public synchronized String toString() {
        return "ProxyLookup(class=" + this.getClass() + ")->" + Arrays.asList(this.getData().getLookups(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Lookup[] getLookups() {
        ProxyLookup proxyLookup = this;
        synchronized (proxyLookup) {
            return this.getData().getLookups(true);
        }
    }

    private Set<Lookup> identityHashSet(Collection<Lookup> current) {
        IdentityHashMap map = new IdentityHashMap();
        for (Lookup lookup : current) {
            map.put(lookup, null);
        }
        return map.keySet();
    }

    protected final void setLookups(Lookup ... lookups) {
        this.setLookups((Executor)null, lookups);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setLookups(Executor notifyIn, Lookup ... lookups) {
        Collection<Reference<R>> arr;
        IdentityHashMap<Lookup.Result, LookupListener> toRemove = new IdentityHashMap<Lookup.Result, LookupListener>();
        IdentityHashMap<Lookup.Result, LookupListener> toAdd = new IdentityHashMap<Lookup.Result, LookupListener>();
        ProxyLookup proxyLookup = this;
        synchronized (proxyLookup) {
            ImmutableInternalData orig = this.getData();
            ImmutableInternalData newData = this.getData().setLookupsNoFire(lookups, false);
            if (newData == this.getData()) {
                return;
            }
            arr = this.setData(newData, lookups, toAdd, toRemove);
        }
        for (Map.Entry e : toRemove.entrySet()) {
            ((Lookup.Result)e.getKey()).removeLookupListener((LookupListener)e.getValue());
        }
        for (Map.Entry e : toAdd.entrySet()) {
            ((Lookup.Result)e.getKey()).addLookupListener((LookupListener)e.getValue());
        }
        final ArrayList<Object> evAndListeners = new ArrayList<Object>();
        for (Reference<R> ref : arr) {
            R r = ref.get();
            if (r == null) continue;
            r.collectFires(evAndListeners);
        }
        class Notify
        implements Runnable {
            Notify() {
            }

            @Override
            public void run() {
                Iterator it = evAndListeners.iterator();
                while (it.hasNext()) {
                    LookupEvent ev = (LookupEvent)it.next();
                    LookupListener l = (LookupListener)it.next();
                    try {
                        l.resultChanged(ev);
                    }
                    catch (RuntimeException x) {
                        Logger.getLogger(ProxyLookup.class.getName()).log(Level.WARNING, null, x);
                    }
                }
            }
        }
        Notify n = new Notify();
        if (notifyIn == null) {
            n.run();
        } else {
            notifyIn.execute(n);
        }
    }

    protected void beforeLookup(Lookup.Template<?> template) {
    }

    void beforeLookup(boolean call, Lookup.Template<?> template) {
        if (call) {
            this.beforeLookup(template);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> T lookup(Class<T> clazz) {
        Lookup[] tmpLkps;
        this.beforeLookup(new Lookup.Template<T>(clazz));
        ProxyLookup proxyLookup = this;
        synchronized (proxyLookup) {
            tmpLkps = this.getData().getLookups(false);
        }
        for (int i = 0; i < tmpLkps.length; ++i) {
            T o = tmpLkps[i].lookup(clazz);
            if (o == null) continue;
            return o;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> Lookup.Item<T> lookupItem(Lookup.Template<T> template) {
        Lookup[] tmpLkps;
        this.beforeLookup(template);
        ProxyLookup proxyLookup = this;
        synchronized (proxyLookup) {
            tmpLkps = this.getData().getLookups(false);
        }
        for (int i = 0; i < tmpLkps.length; ++i) {
            Lookup.Item<T> o = tmpLkps[i].lookupItem(template);
            if (o == null) continue;
            return o;
        }
        return null;
    }

    private static <T> R<T> convertResult(R r) {
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
        ProxyLookup proxyLookup = this;
        synchronized (proxyLookup) {
            ImmutableInternalData[] res = new ImmutableInternalData[]{null};
            R<T> newR = this.getData().findResult(this, res, template);
            this.setData(res[0], this.getData().getLookups(false), null, null);
            return newR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void unregisterTemplate(Lookup.Template<?> template) {
        ProxyLookup proxyLookup = this;
        synchronized (proxyLookup) {
            ImmutableInternalData id = this.getData();
            if (id == null) {
                return;
            }
            this.setData(id.removeTemplate(this, template), this.getData().getLookups(false), null, null);
        }
    }

    private ImmutableInternalData getData() {
        assert (Thread.holdsLock(this));
        return this.data;
    }

    private Collection<Reference<R>> setData(ImmutableInternalData newData, Lookup[] current, Map<Lookup.Result, LookupListener> toAdd, Map<Lookup.Result, LookupListener> toRemove) {
        R r;
        assert (Thread.holdsLock(this));
        assert (newData != null);
        ImmutableInternalData previous = this.getData();
        if (previous == newData) {
            return Collections.emptyList();
        }
        if (newData.isEmpty()) {
            this.setData(newData);
            return Collections.emptyList();
        }
        Collection<Reference<R>> arr = newData.references();
        Set<Lookup> removed = this.identityHashSet(previous.getLookupsList());
        Set<Lookup> currentSet = this.identityHashSet(Arrays.asList(current));
        Set<Lookup> newL = this.identityHashSet(currentSet);
        removed.removeAll(currentSet);
        newL.removeAll(previous.getLookupsList());
        for (Reference<R> ref : arr) {
            r = ref.get();
            if (r == null) continue;
            r.lookupChange(newData, current, previous, newL, removed, toAdd, toRemove);
            if (this.getData() == previous) continue;
        }
        for (Reference<R> ref : arr) {
            r = ref.get();
            if (r == null) continue;
            r.data = newData;
        }
        this.setData(newData);
        return arr;
    }

    private void setData(ImmutableInternalData data) {
        this.data = data;
    }

    private static final class EmptyInternalData
    extends ImmutableInternalData {
        EmptyInternalData() {
        }

        @Override
        protected final boolean isEmpty() {
            return true;
        }

        @Override
        protected Map<Lookup.Template, Reference<R>> getResults() {
            return Collections.emptyMap();
        }

        @Override
        protected Object getRawLookups() {
            return EMPTY_ARR;
        }
    }

    static abstract class ImmutableInternalData {
        static final ImmutableInternalData EMPTY = new EmptyInternalData();
        static final Lookup[] EMPTY_ARR = new Lookup[0];

        protected ImmutableInternalData() {
        }

        public static ImmutableInternalData create(Object lkp, Map<Lookup.Template, Reference<R>> results) {
            if (results.size() == 0 && lkp == EMPTY_ARR) {
                return EMPTY;
            }
            if (results.size() == 1) {
                Map.Entry<Lookup.Template, Reference<R>> e = results.entrySet().iterator().next();
                return new SingleInternalData(lkp, e.getKey(), e.getValue());
            }
            return new RealInternalData(lkp, results);
        }

        protected abstract boolean isEmpty();

        protected abstract Map<Lookup.Template, Reference<R>> getResults();

        protected abstract Object getRawLookups();

        final Collection<Reference<R>> references() {
            return this.getResults().values();
        }

        final <T> ImmutableInternalData removeTemplate(ProxyLookup proxy, Lookup.Template<T> template) {
            if (this.getResults().containsKey(template)) {
                HashMap<Lookup.Template, Reference<R>> c = new HashMap<Lookup.Template, Reference<R>>(this.getResults());
                Reference<R> ref = c.remove(template);
                if (ref != null && ref.get() != null) {
                    return this;
                }
                return ImmutableInternalData.create(this.getRawLookups(), c);
            }
            return this;
        }

        <T> R<T> findResult(ProxyLookup proxy, ImmutableInternalData[] newData, Lookup.Template<T> template) {
            R r;
            assert (Thread.holdsLock(proxy));
            Map<Lookup.Template, Reference<R>> map = this.getResults();
            Reference<R> ref = map.get(template);
            R r2 = r = ref == null ? null : ref.get();
            if (r != null) {
                newData[0] = this;
                return ProxyLookup.convertResult(r);
            }
            HashMap<Lookup.Template, Reference<R>> res = new HashMap<Lookup.Template, Reference<R>>(map);
            R<T> newR = new R<T>(proxy, template);
            res.put(template, new SoftReference<R<T>>(newR));
            newData[0] = ImmutableInternalData.create(this.getRawLookups(), res);
            ((R)newR).data = newData[0];
            return newR;
        }

        final ImmutableInternalData setLookupsNoFire(Lookup[] lookups, boolean skipCheck) {
            Object l;
            if (!skipCheck) {
                Lookup[] previous = this.getLookups(false);
                if (previous == lookups) {
                    return this;
                }
                if (previous.length == lookups.length) {
                    int same = 0;
                    for (int i = 0; i < previous.length && lookups[i] == previous[i]; ++i) {
                        ++same;
                    }
                    if (same == previous.length) {
                        return this;
                    }
                }
            }
            if (lookups.length == 1) {
                l = lookups[0];
                assert (l != null) : "Cannot assign null delegate";
            } else {
                l = lookups.length == 0 ? EMPTY_ARR : lookups.clone();
            }
            if (this.isEmpty() && l == EMPTY_ARR) {
                return this;
            }
            return ImmutableInternalData.create(l, this.getResults());
        }

        final Lookup[] getLookups(boolean clone) {
            Object l = this.getRawLookups();
            if (l instanceof Lookup) {
                return new Lookup[]{(Lookup)l};
            }
            Lookup[] arr = (Lookup[])l;
            if (clone) {
                arr = (Lookup[])arr.clone();
            }
            return arr;
        }

        final List<Lookup> getLookupsList() {
            return Arrays.asList(this.getLookups(false));
        }
    }

    private static class LazyCollection
    implements Collection {
        private R result;
        private final Object[] cc;
        private final int indexToCache;
        private final boolean callBeforeLookup;
        private final Lookup.Result[] arr;
        private final Collection[] computed;
        private Collection delegate;

        public LazyCollection(R result, Object[] cc, int indexToCache, boolean callBeforeLookup, Lookup.Result[] arr) {
            this.result = result;
            this.indexToCache = indexToCache;
            this.cc = cc;
            this.callBeforeLookup = callBeforeLookup;
            this.arr = arr;
            this.computed = new Collection[arr.length];
        }

        final Collection delegate() {
            return this.delegate(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final Collection delegate(boolean computeIt) {
            Collection dlgt = null;
            while (true) {
                LazyCollection lazyCollection = this;
                synchronized (lazyCollection) {
                    if (dlgt != null && this.delegate == null) {
                        this.delegate = dlgt;
                        this.result = null;
                    }
                    if (this.delegate != null) {
                        return this.delegate;
                    }
                    if (!computeIt) {
                        return null;
                    }
                }
                dlgt = this.computeDelegate(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Collection computeDelegate(int[] firstNonEmpty) {
            int i;
            AbstractCollection compute = null;
            Collection ret = null;
            if (firstNonEmpty == null || firstNonEmpty[0] == 0) {
                if (this.indexToCache == 1) {
                    HashSet s = new HashSet();
                    compute = s;
                    ret = Collections.unmodifiableSet(s);
                } else {
                    ArrayList l = new ArrayList(this.arr.length * 2);
                    compute = l;
                    ret = Collections.unmodifiableList(l);
                }
            }
            int n = i = firstNonEmpty == null ? 0 : firstNonEmpty[0];
            while (i < this.arr.length) {
                Collection one;
                LazyCollection lazyCollection = this;
                synchronized (lazyCollection) {
                    one = this.getComputed()[i];
                }
                if (one == null) {
                    if (firstNonEmpty != null && this.callBeforeLookup && this.arr[i] instanceof WaitableResult) {
                        WaitableResult wr = (WaitableResult)this.arr[i];
                        wr.beforeLookup(this.result.template());
                    }
                    one = this.computeSingleResult(i);
                    assert (one != null);
                }
                boolean addAll = false;
                LazyCollection lazyCollection2 = this;
                synchronized (lazyCollection2) {
                    if (this.getComputed()[i] == null) {
                        this.getComputed()[i] = one;
                    }
                    ++i;
                    if (firstNonEmpty != null) {
                        firstNonEmpty[0] = i;
                        if (!one.isEmpty()) {
                            ret = one;
                            break;
                        }
                    } else {
                        addAll = true;
                    }
                }
                if (!addAll) continue;
                compute.addAll(one);
            }
            if (i == this.arr.length && compute != null) {
                R r = this.result;
                if (r != null) {
                    r.updateResultCache(this.cc, this.indexToCache, this.arr, ret);
                }
                this.result = null;
            }
            return ret;
        }

        @Override
        public int size() {
            return this.delegate().size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate().isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate().contains(o);
        }

        @Override
        public Iterator iterator() {
            Collection c = this.delegate(false);
            return c != null ? c.iterator() : this.lazyIterator();
        }

        @Override
        public Object[] toArray() {
            return this.delegate().toArray();
        }

        public Object[] toArray(Object[] a) {
            return this.delegate().toArray(a);
        }

        public String toString() {
            return this.delegate().toString();
        }

        @Override
        public int hashCode() {
            return ((Object)this.delegate()).hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return ((Object)this.delegate()).equals(obj);
        }

        public boolean add(Object e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean containsAll(Collection c) {
            return this.delegate().containsAll(c);
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        private Iterator lazyIterator() {
            return new Iterator(){
                private Iterator current;
                private int[] indx = new int[]{0};

                @Override
                public boolean hasNext() {
                    while (this.current == null || !this.current.hasNext()) {
                        if (this.indx[0] == LazyCollection.this.arr.length) {
                            return false;
                        }
                        Collection newIt = LazyCollection.this.computeDelegate(this.indx);
                        if (newIt != null) {
                            this.current = newIt.iterator();
                            continue;
                        }
                        assert (this.indx[0] == LazyCollection.this.arr.length);
                        this.current = null;
                    }
                    return true;
                }

                public Object next() {
                    if (this.hasNext()) {
                        return this.current.next();
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        private Collection computeSingleResult(int i) {
            Collection<Object> one = null;
            switch (this.indexToCache) {
                case 0: {
                    if (!this.callBeforeLookup && this.arr[i] instanceof WaitableResult) {
                        WaitableResult wr = (WaitableResult)this.arr[i];
                        one = wr.allInstances(this.callBeforeLookup);
                        break;
                    }
                    one = this.arr[i].allInstances();
                    break;
                }
                case 1: {
                    one = this.arr[i].allClasses();
                    break;
                }
                case 2: {
                    if (!this.callBeforeLookup && this.arr[i] instanceof WaitableResult) {
                        WaitableResult wr = (WaitableResult)this.arr[i];
                        one = wr.allItems(this.callBeforeLookup);
                        break;
                    }
                    one = this.arr[i].allItems();
                    break;
                }
                default: {
                    assert (false) : "Wrong index: " + this.indexToCache;
                    break;
                }
            }
            return one;
        }

        private Collection[] getComputed() {
            assert (Thread.holdsLock(this));
            return this.computed;
        }
    }

    private static final class LazyList
    extends LazyCollection
    implements List {
        public LazyList(R data, Object[] cc, int indexToCache, boolean callBeforeLookup, Lookup.Result[] arr) {
            super(data, cc, indexToCache, callBeforeLookup, arr);
        }

        final List delegateList() {
            return (List)this.delegate();
        }

        public Object get(int index) {
            return this.delegateList().get(index);
        }

        public List subList(int fromIndex, int toIndex) {
            return this.delegateList().subList(fromIndex, toIndex);
        }

        @Override
        public int indexOf(Object o) {
            return this.delegateList().indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.delegateList().lastIndexOf(o);
        }

        public ListIterator listIterator() {
            return this.delegateList().listIterator();
        }

        public ListIterator listIterator(int index) {
            return this.delegateList().listIterator(index);
        }

        public boolean addAll(int index, Collection c) {
            throw new UnsupportedOperationException();
        }

        public Object set(int index, Object element) {
            throw new UnsupportedOperationException();
        }

        public void add(int index, Object element) {
            throw new UnsupportedOperationException();
        }

        public Object remove(int index) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class LazySet
    extends LazyCollection
    implements Set {
        public LazySet(R data, Object[] cc, int indexToCache, boolean callBeforeLookup, Lookup.Result[] arr) {
            super(data, cc, indexToCache, callBeforeLookup, arr);
        }
    }

    private static final class R<T>
    extends WaitableResult<T> {
        private final WeakResult<T> weakL;
        private EventListenerList listeners;
        private Collection[] cache;
        private ImmutableInternalData data;
        private static final Collection[] NO_CACHE = new Collection[0];

        public R(ProxyLookup proxy, Lookup.Template<T> t) {
            this.weakL = new WeakResult<T>(proxy, this, t);
        }

        private ProxyLookup proxy() {
            return ((WeakResult)this.weakL).result.proxy;
        }

        private Lookup.Result<T>[] newResults(int len) {
            return new Lookup.Result[len];
        }

        protected void finalize() {
            ((WeakResult)this.weakL).result.run();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private Lookup.Result<T>[] initResults() {
            Lookup.Result[] arr;
            block4: while (true) {
                ProxyLookup proxyLookup = this.proxy();
                // MONITORENTER : proxyLookup
                if (((WeakResult)this.weakL).getResults() != null) {
                    // MONITOREXIT : proxyLookup
                    return ((WeakResult)this.weakL).getResults();
                }
                Lookup[] myLkps = this.data.getLookups(false);
                ImmutableInternalData current = this.data;
                // MONITOREXIT : proxyLookup
                arr = this.newResults(myLkps.length);
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = myLkps[i].lookup(this.template());
                }
                ProxyLookup i = this.proxy();
                // MONITORENTER : i
                if (current != this.data) {
                    // MONITOREXIT : i
                    continue;
                }
                Lookup[] currentLkps = this.data.getLookups(false);
                if (currentLkps.length != myLkps.length) {
                    // MONITOREXIT : i
                    continue;
                }
                for (int i2 = 0; i2 < currentLkps.length; ++i2) {
                    if (currentLkps[i2] == myLkps[i2]) continue;
                    // MONITOREXIT : i
                    continue block4;
                }
                break;
            }
            if (((WeakResult)this.weakL).getResults() != null) {
                // MONITOREXIT : i
                return ((WeakResult)this.weakL).getResults();
            }
            ((WeakResult)this.weakL).setResults(arr);
            // MONITOREXIT : i
            int i = 0;
            while (i < arr.length) {
                arr[i].addLookupListener(this.weakL);
                ++i;
            }
            return arr;
        }

        final void lookupChange(ImmutableInternalData newData, Lookup[] current, ImmutableInternalData oldData, Set<Lookup> added, Set<Lookup> removed, Map<Lookup.Result, LookupListener> toAdd, Map<Lookup.Result, LookupListener> toRemove) {
            if (((WeakResult)this.weakL).getResults() == null) {
                return;
            }
            Lookup[] old = oldData.getLookups(false);
            IdentityHashMap<Lookup, Lookup.Result> map = new IdentityHashMap<Lookup, Lookup.Result>(old.length * 2);
            for (int i = 0; i < old.length; ++i) {
                if (removed.contains(old[i])) {
                    if (toRemove == null) continue;
                    toRemove.put(((WeakResult)this.weakL).getResults()[i], this.weakL);
                    continue;
                }
                map.put(old[i], ((WeakResult)this.weakL).getResults()[i]);
            }
            Lookup.Result[] arr = this.newResults(current.length);
            for (int i = 0; i < current.length; ++i) {
                if (added.contains(current[i])) {
                    arr[i] = current[i].lookup(this.template());
                    if (toAdd == null) continue;
                    toAdd.put(arr[i], this.weakL);
                    continue;
                }
                arr[i] = (Lookup.Result)map.get(current[i]);
                if (arr[i] != null) continue;
                throw new IllegalStateException();
            }
            ((WeakResult)this.weakL).setResults(arr);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addLookupListener(LookupListener l) {
            ProxyLookup proxyLookup = this.proxy();
            synchronized (proxyLookup) {
                if (this.listeners == null) {
                    this.listeners = new EventListenerList();
                }
            }
            this.listeners.add(LookupListener.class, l);
            this.initResults();
        }

        @Override
        public void removeLookupListener(LookupListener l) {
            if (this.listeners != null) {
                this.listeners.remove(LookupListener.class, l);
            }
        }

        @Override
        public Collection<T> allInstances() {
            return this.allInstances(true);
        }

        @Override
        protected Collection<T> allInstances(boolean callBeforeLookup) {
            return this.computeResult(0, callBeforeLookup);
        }

        @Override
        public Set<Class<? extends T>> allClasses() {
            return (Set)this.computeResult(1, true);
        }

        @Override
        public Collection<? extends Lookup.Item<T>> allItems() {
            return this.allItems(true);
        }

        @Override
        public Collection<? extends Lookup.Item<T>> allItems(boolean callBeforeLookup) {
            return this.computeResult(2, callBeforeLookup);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Collection computeResult(int indexToCache, boolean callBeforeLookup) {
            Object[] cc;
            Collection cachedResult = null;
            ProxyLookup proxyLookup = this.proxy();
            synchronized (proxyLookup) {
                cc = this.getCache();
                if (cc != null && cc != NO_CACHE) {
                    cachedResult = cc[indexToCache];
                }
            }
            Lookup.Result[] arr = this.myBeforeLookup(callBeforeLookup, cachedResult != null);
            ProxyLookup proxyLookup2 = this.proxy();
            synchronized (proxyLookup2) {
                cc = this.getCache();
                if (cc != null && cc != NO_CACHE) {
                    cachedResult = cc[indexToCache];
                }
            }
            if (cachedResult != null) {
                return cachedResult;
            }
            if (indexToCache == 1) {
                return new LazySet(this, cc, indexToCache, callBeforeLookup, arr);
            }
            return new LazyList(this, cc, indexToCache, callBeforeLookup, arr);
        }

        public void resultChanged(LookupEvent ev) {
            this.collectFires(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        protected void collectFires(Collection<Object> evAndListeners) {
            Collection<Lookup.Item<T>> newItems;
            Object oldItems;
            Collection[] cc;
            boolean modified;
            block31: {
                modified = true;
                try {
                    ProxyLookup proxyLookup = this.proxy();
                    // MONITORENTER : proxyLookup
                    cc = this.getCache();
                    if (cc != NO_CACHE) break block31;
                    // MONITOREXIT : proxyLookup
                    ProxyLookup proxyLookup2 = this.proxy();
                }
                catch (Throwable throwable) {
                    ProxyLookup proxyLookup = this.proxy();
                    // MONITORENTER : proxyLookup
                    if (this.getCache() == NO_CACHE) {
                        this.setCache(null);
                    }
                    // MONITOREXIT : proxyLookup
                    throw throwable;
                }
                if (this.getCache() == NO_CACHE) {
                    this.setCache(null);
                }
                // MONITOREXIT : proxyLookup2
                return;
            }
            Collection oldInstances = cc == null ? null : cc[0];
            Object object = oldItems = cc == null ? null : cc[2];
            if (this.listeners == null || this.listeners.getListenerCount() == 0) {
                this.setCache(new Collection[3]);
                // MONITOREXIT : proxyLookup
                ProxyLookup proxyLookup = this.proxy();
                // MONITORENTER : proxyLookup
                if (this.getCache() == NO_CACHE) {
                    this.setCache(null);
                }
                // MONITOREXIT : proxyLookup
                return;
            }
            Object[] ll = this.listeners.getListenerList();
            assert (ll != null);
            this.setCache(NO_CACHE);
            // MONITOREXIT : proxyLookup
            if (oldItems != null) {
                newItems = this.allItems(false);
                if (oldItems.equals(newItems)) {
                    modified = false;
                }
            } else if (oldInstances != null) {
                Collection<T> newInstances = this.allInstances(false);
                if (((Object)oldInstances).equals(newInstances)) {
                    modified = false;
                }
            } else {
                newItems = this.allItems(false);
                if (newItems.isEmpty()) {
                    modified = false;
                }
                ProxyLookup proxyLookup = this.proxy();
                // MONITORENTER : proxyLookup
                if (this.getCache() == NO_CACHE) {
                    this.setCache(new Collection[3]);
                }
                // MONITOREXIT : proxyLookup
            }
            oldItems = this.proxy();
            if (this.getCache() == NO_CACHE) {
                this.setCache(null);
            }
            // MONITOREXIT : oldItems
            if (!modified) return;
            LookupEvent ev = new LookupEvent(this);
            AbstractLookup.notifyListeners(ll, ev, evAndListeners);
        }

        private Lookup.Result<T>[] myBeforeLookup(boolean callBeforeLookup, boolean callBeforeOnWait) {
            Lookup.Template<T> template = this.template();
            this.proxy().beforeLookup(callBeforeLookup, template);
            Lookup.Result<T>[] arr = this.initResults();
            if (callBeforeOnWait) {
                for (int i = 0; i < arr.length; ++i) {
                    if (!(arr[i] instanceof WaitableResult)) continue;
                    WaitableResult w = (WaitableResult)arr[i];
                    w.beforeLookup(template);
                }
            }
            return arr;
        }

        @Override
        protected void beforeLookup(Lookup.Template t) {
            if (t.getType() == this.template().getType()) {
                this.myBeforeLookup(true, true);
            }
        }

        private Collection[] getCache() {
            return this.cache;
        }

        private void setCache(Collection[] cache) {
            assert (Thread.holdsLock(this.proxy()));
            this.cache = cache;
        }

        private Lookup.Template<T> template() {
            return ((WeakResult)this.weakL).result.template;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateResultCache(Object[] oldCC, int indexToCache, Lookup.Result[] arr, Collection<Object> ret) {
            ProxyLookup proxyLookup = this.proxy();
            synchronized (proxyLookup) {
                Collection[] cc = this.getCache();
                if (cc != oldCC) {
                    return;
                }
                if (cc == null || cc == NO_CACHE) {
                    cc = new Collection[3];
                    this.setCache(cc);
                }
                if (arr == ((WeakResult)this.weakL).getResults()) {
                    cc[indexToCache] = ret;
                }
            }
        }
    }

    private static final class RealInternalData
    extends ImmutableInternalData {
        private final Object lookups;
        private final Map<Lookup.Template, Reference<R>> results;
        private static Class<?> unmodifiableClass;

        public RealInternalData(Object lookups, Map<Lookup.Template, Reference<R>> results) {
            this.results = results;
            this.lookups = lookups;
        }

        @Override
        protected final boolean isEmpty() {
            return false;
        }

        @Override
        protected Map<Lookup.Template, Reference<R>> getResults() {
            boolean needsStrict = false;
            if (!$assertionsDisabled) {
                needsStrict = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            return needsStrict && !RealInternalData.isUnmodifiable(this.results) ? RealInternalData.unmodifiableMap(this.results) : this.results;
        }

        @Override
        protected Object getRawLookups() {
            return this.lookups;
        }

        private static boolean isUnmodifiable(Map<?, ?> map) {
            return map.getClass() == unmodifiableClass;
        }

        private static <K, V> Map<K, V> unmodifiableMap(Map<K, V> map) {
            Map<K, V> res = Collections.unmodifiableMap(map);
            if (unmodifiableClass == null) {
                unmodifiableClass = res.getClass();
            }
            return res;
        }
    }

    private static final class SingleInternalData
    extends ImmutableInternalData {
        private final Object lookups;
        private final Lookup.Template template;
        private final Reference<R> result;

        public SingleInternalData(Object lookups, Lookup.Template<?> template, Reference<R> result) {
            this.lookups = lookups;
            this.template = template;
            this.result = result;
        }

        @Override
        protected final boolean isEmpty() {
            return false;
        }

        @Override
        protected Map<Lookup.Template, Reference<R>> getResults() {
            return Collections.singletonMap(this.template, this.result);
        }

        @Override
        protected Object getRawLookups() {
            return this.lookups;
        }
    }

    private static final class WeakRef<T>
    extends WeakReference<R>
    implements Runnable {
        final WeakResult<T> result;
        final ProxyLookup proxy;
        final Lookup.Template<T> template;

        public WeakRef(R r, WeakResult<T> result, ProxyLookup proxy, Lookup.Template<T> template) {
            super(r);
            this.result = result;
            this.template = template;
            this.proxy = proxy;
        }

        @Override
        public void run() {
            this.result.removeListeners();
            this.proxy.unregisterTemplate(this.template);
        }
    }

    private static final class WeakResult<T>
    extends WaitableResult<T>
    implements LookupListener,
    Runnable {
        private Lookup.Result<T>[] results;
        private final WeakRef<T> result;

        public WeakResult(ProxyLookup proxy, R r, Lookup.Template<T> t) {
            this.result = new WeakRef<T>(r, this, proxy, t);
        }

        final void removeListeners() {
            Lookup.Result<T>[] arr = this.getResults();
            if (arr == null) {
                return;
            }
            for (int i = 0; i < arr.length; ++i) {
                arr[i].removeLookupListener(this);
            }
        }

        @Override
        protected void beforeLookup(Lookup.Template t) {
            R r = (R)this.result.get();
            if (r != null) {
                r.beforeLookup(t);
            } else {
                this.removeListeners();
            }
        }

        @Override
        protected void collectFires(Collection<Object> evAndListeners) {
            R r = (R)this.result.get();
            if (r != null) {
                r.collectFires(evAndListeners);
            } else {
                this.removeListeners();
            }
        }

        @Override
        public void addLookupListener(LookupListener l) {
            assert (false);
        }

        @Override
        public void removeLookupListener(LookupListener l) {
            assert (false);
        }

        @Override
        public Collection<T> allInstances() {
            assert (false);
            return null;
        }

        @Override
        public void resultChanged(LookupEvent ev) {
            R r = (R)this.result.get();
            if (r != null) {
                r.resultChanged(ev);
            } else {
                this.removeListeners();
            }
        }

        @Override
        public Collection<? extends Lookup.Item<T>> allItems() {
            assert (false);
            return null;
        }

        @Override
        public Set<Class<? extends T>> allClasses() {
            assert (false);
            return null;
        }

        @Override
        public void run() {
            this.removeListeners();
        }

        private Lookup.Result<T>[] getResults() {
            return this.results;
        }

        private void setResults(Lookup.Result<T>[] results) {
            this.results = results;
        }

        @Override
        protected Collection<? extends Object> allInstances(boolean callBeforeLookup) {
            return this.allInstances();
        }

        @Override
        protected Collection<? extends Lookup.Item<T>> allItems(boolean callBeforeLookup) {
            return this.allItems();
        }
    }
}

