/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractSequentialList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AWTUtilities {
    static WeakHashMap visibleChildrenCache = new WeakHashMap();
    static /* synthetic */ Class class$java$awt$Window;

    public static List getVisibleChildren(Container c) {
        Component[] children = c.getComponents();
        Object o = visibleChildrenCache.get(children);
        VisibleComponentList visibleChildren = null;
        if (o == null) {
            visibleChildren = new VisibleComponentList(children);
            visibleChildrenCache.put(children, visibleChildren);
        } else {
            visibleChildren = (VisibleComponentList)o;
        }
        return visibleChildren;
    }

    public static Rectangle calculateInsetArea(Rectangle base, Insets insets, Rectangle ret) {
        if (ret == null) {
            ret = new Rectangle();
        }
        ret.setBounds(base.x + insets.left, base.y + insets.top, base.width - (insets.left + insets.right), base.height - (insets.top + insets.bottom));
        return ret;
    }

    public static Rectangle getLocalBounds(Component aComponent) {
        Rectangle bounds = aComponent.getBounds();
        return new Rectangle(0, 0, bounds.width, bounds.height);
    }

    public static FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public static Container getAncestorNamed(String name, Component comp) {
        while (comp != null && comp.getName() != name) {
            comp = comp.getParent();
        }
        return (Container)comp;
    }

    public static Container getAncestorOfClass(Class c, Component comp) {
        while (comp != null && !c.isInstance(comp)) {
            comp = comp.getParent();
        }
        return (Container)comp;
    }

    public static Window windowForComponent(Component comp) {
        Class clazz = class$java$awt$Window;
        if (clazz == null) {
            clazz = class$java$awt$Window = AWTUtilities.class("[Ljava.awt.Window;", false);
        }
        return (Window)AWTUtilities.getAncestorOfClass(clazz, comp);
    }

    public static Component getRoot(Component comp) {
        Applet app = null;
        Window win = null;
        while (comp != null) {
            if (win == null && comp instanceof Window) {
                win = (Window)comp;
            } else if (comp instanceof Applet) {
                app = (Applet)comp;
            }
            comp = comp.getParent();
        }
        if (win != null) {
            return win;
        }
        return app;
    }

    public static boolean isDescendingFrom(Component a, Component b) {
        while (a != null && b != null) {
            if (a == b) {
                return true;
            }
            a = a.getParent();
        }
        return false;
    }

    public static Component getDeepestComponentAt(Component parent, int x, int y) {
        if (parent == null || !parent.contains(x, y)) {
            return null;
        }
        if (!(parent instanceof Container)) {
            return parent;
        }
        Container c = (Container)parent;
        return c.findComponentAt(x, y);
    }

    public static void convertPointToScreen(Point p, Component c) {
        Point c0 = c.getLocationOnScreen();
        p.translate(c0.x, c0.y);
    }

    public static void convertPointFromScreen(Point p, Component c) {
        Point c0 = c.getLocationOnScreen();
        p.translate(-c0.x, -c0.y);
    }

    public static Point convertPoint(Component source, int x, int y, Component destination) {
        Point pt = new Point(x, y);
        if (source == null && destination == null) {
            return pt;
        }
        if (source == null) {
            source = AWTUtilities.getRoot(destination);
        }
        if (destination == null) {
            destination = AWTUtilities.getRoot(source);
        }
        if (source.isShowing() && destination.isShowing()) {
            AWTUtilities.convertPointToScreen(pt, source);
            AWTUtilities.convertPointFromScreen(pt, destination);
        }
        return pt;
    }

    public static Rectangle convertRectangle(Component source, Rectangle rect, Component destination) {
        Point pt = AWTUtilities.convertPoint(source, rect.x, rect.y, destination);
        return new Rectangle(pt.x, pt.y, rect.width, rect.height);
    }

    public static MouseEvent convertMouseEvent(Component source, MouseEvent sourceEvent, Component destination) {
        Point newpt = AWTUtilities.convertPoint(source, sourceEvent.getX(), sourceEvent.getY(), destination);
        return new MouseEvent(destination, sourceEvent.getID(), sourceEvent.getWhen(), sourceEvent.getModifiers(), newpt.x, newpt.y, sourceEvent.getClickCount(), sourceEvent.isPopupTrigger(), sourceEvent.getButton());
    }

    public static void invokeLater(Runnable doRun) {
        EventQueue.invokeLater(doRun);
    }

    public static void invokeAndWait(Runnable doRun) throws InterruptedException, InvocationTargetException {
        EventQueue.invokeAndWait(doRun);
    }

    public static boolean isEventDispatchThread() {
        return EventQueue.isDispatchThread();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static class VisibleComponentList
    extends AbstractSequentialList {
        Component[] components;

        public ListIterator listIterator(int index) {
            return new VisibleComponentIterator(index);
        }

        public int size() {
            int visibleComponents = 0;
            int i = 0;
            while (i < this.components.length) {
                if (this.components[i].isVisible()) {
                    ++visibleComponents;
                }
                ++i;
            }
            return visibleComponents;
        }

        VisibleComponentList(Component[] c) {
            this.components = c;
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        class VisibleComponentIterator
        implements ListIterator {
            int index;
            int listIndex;

            public boolean hasNext() {
                boolean hasNext = false;
                int i = this.index;
                while (i < VisibleComponentList.this.components.length) {
                    if (VisibleComponentList.this.components[i].isVisible()) {
                        hasNext = true;
                        break;
                    }
                    ++i;
                }
                return hasNext;
            }

            public Object next() {
                Component o = null;
                while (this.index < VisibleComponentList.this.components.length) {
                    if (VisibleComponentList.this.components[this.index].isVisible()) {
                        o = VisibleComponentList.this.components[this.index];
                        break;
                    }
                    ++this.index;
                }
                if (o != null) {
                    ++this.index;
                    ++this.listIndex;
                    return o;
                }
                throw new NoSuchElementException();
            }

            public boolean hasPrevious() {
                boolean hasPrevious = false;
                int i = this.index - 1;
                while (i >= 0) {
                    if (VisibleComponentList.this.components[i].isVisible()) {
                        hasPrevious = true;
                        break;
                    }
                    --i;
                }
                return hasPrevious;
            }

            public Object previous() {
                Component o = null;
                --this.index;
                while (this.index >= 0) {
                    if (VisibleComponentList.this.components[this.index].isVisible()) {
                        o = VisibleComponentList.this.components[this.index];
                        break;
                    }
                    --this.index;
                }
                if (o != null) {
                    --this.listIndex;
                    return o;
                }
                throw new NoSuchElementException();
            }

            public int nextIndex() {
                return this.listIndex + 1;
            }

            public int previousIndex() {
                return this.listIndex - 1;
            }

            public void remove() {
                throw new UnsupportedOperationException("VisibleComponentList is immutable");
            }

            public void set(Object o) {
                throw new UnsupportedOperationException("VisibleComponentList is immutable");
            }

            public void add(Object o) {
                throw new UnsupportedOperationException("VisibleComponentList is immutable");
            }

            VisibleComponentIterator(int listIndex) {
                this.listIndex = listIndex;
                int visibleComponentsFound = 0;
                this.index = 0;
                while (visibleComponentsFound != listIndex) {
                    if (VisibleComponentList.this.components[this.index].isVisible()) {
                        ++visibleComponentsFound;
                    }
                    ++this.index;
                }
            }
        }
    }
}

