/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.go.swing;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import org.igoweb.go.Game;
import org.igoweb.go.Loc;
import org.igoweb.go.sgf.Tree;
import org.igoweb.go.swing.GobanWidget;
import org.igoweb.go.swing.StonePrinter;
import org.igoweb.go.swing.StoneWidget;
import org.igoweb.go.swing.Updater;

public class GobanPrinter
implements Printable,
Pageable {
    private final Tree tree;

    public GobanPrinter(Tree tree) {
        this.tree = tree;
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
        if (pageIndex != 0) {
            return 1;
        }
        double size = pageFormat.getImageableWidth();
        if (pageFormat.getImageableHeight() < size) {
            size = pageFormat.getImageableHeight();
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        Game game = new Game(this.tree.root.findProp(0).getRules());
        GobanWidget gobanWidget = new GobanWidget(game);
        new Updater(gobanWidget, this.tree, false, null, null);
        GobanPrinter.print(g2d, gobanWidget, size);
        return 0;
    }

    public static void print(Graphics2D g, GobanWidget widget, double size) {
        widget.syncWithGame();
        int boardSize = widget.getGame().size;
        double stoneSize = size / (double)boardSize;
        g.setFont(new Font("SansSerif", 0, 1).deriveFont((float)(stoneSize * 0.5)));
        StonePrinter stonePrinter = new StonePrinter(stoneSize);
        for (int y = 0; y < boardSize; ++y) {
            for (int x = 0; x < boardSize; ++x) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.translate((double)x * stoneSize, (double)y * stoneSize);
                StoneWidget sw = widget.getStoneWidget(Loc.get(x, y));
                if (sw.getColor() != 2 || (sw.getMark() & 2) == 0) {
                    stonePrinter.paintGrid(g2, sw.loc, boardSize);
                }
                stonePrinter.paintStone(g2, sw.getColor(), sw.getMark() & 0xFFFFF9FE, StonePrinter.whiteImageId(0), sw.getLabel(), 0);
                g2.dispose();
            }
        }
    }

    @Override
    public int getNumberOfPages() {
        return 1;
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        if (pageIndex != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        if (pageIndex != 0) {
            throw new IndexOutOfBoundsException();
        }
        return new PageFormat();
    }
}

