/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.enterprise.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.api.problems.internal.Problem;
import org.gradle.internal.enterprise.GradleEnterprisePluginBuildState;
import org.gradle.internal.enterprise.GradleEnterprisePluginConfig;
import org.gradle.internal.enterprise.GradleEnterprisePluginEndOfBuildListener;
import org.gradle.internal.enterprise.GradleEnterprisePluginService;
import org.gradle.internal.enterprise.GradleEnterprisePluginServiceFactory;
import org.gradle.internal.enterprise.GradleEnterprisePluginServiceRef;
import org.gradle.internal.enterprise.core.GradleEnterprisePluginAdapter;
import org.gradle.internal.enterprise.impl.DefaultGradleEnterprisePluginRequiredServices;
import org.gradle.internal.enterprise.impl.DefaultGradleEnterprisePluginServiceRef;
import org.gradle.internal.exceptions.MultiCauseException;
import org.gradle.internal.operations.notify.BuildOperationNotificationListenerRegistrar;

public class DefaultGradleEnterprisePluginAdapter
implements GradleEnterprisePluginAdapter {
    private final GradleEnterprisePluginServiceFactory pluginServiceFactory;
    private final GradleEnterprisePluginConfig config;
    private final DefaultGradleEnterprisePluginRequiredServices requiredServices;
    private final GradleEnterprisePluginBuildState buildState;
    private final DefaultGradleEnterprisePluginServiceRef pluginServiceRef;
    private final BuildOperationNotificationListenerRegistrar buildOperationNotificationListenerRegistrar;
    private final Multimap<Throwable, Problem> problems;
    private transient GradleEnterprisePluginService pluginService;

    public DefaultGradleEnterprisePluginAdapter(GradleEnterprisePluginServiceFactory pluginServiceFactory, GradleEnterprisePluginConfig config, DefaultGradleEnterprisePluginRequiredServices requiredServices, GradleEnterprisePluginBuildState buildState, DefaultGradleEnterprisePluginServiceRef pluginServiceRef, BuildOperationNotificationListenerRegistrar buildOperationNotificationListenerRegistrar, InternalProblems problems) {
        this.pluginServiceFactory = pluginServiceFactory;
        this.config = config;
        this.requiredServices = requiredServices;
        this.buildState = buildState;
        this.pluginServiceRef = pluginServiceRef;
        this.buildOperationNotificationListenerRegistrar = buildOperationNotificationListenerRegistrar;
        this.problems = problems.getProblemsForThrowables();
        this.createPluginService();
    }

    public GradleEnterprisePluginServiceRef getPluginServiceRef() {
        return this.pluginServiceRef;
    }

    public boolean shouldSaveToConfigurationCache() {
        return true;
    }

    public void onLoadFromConfigurationCache() {
        this.createPluginService();
    }

    public void buildFinished(@Nullable Throwable buildFailure) {
        this.requiredServices.getBackgroundJobExecutors().stop();
        if (this.pluginService != null) {
            this.pluginService.getEndOfBuildListener().buildFinished(new DefaultDevelocityPluginResult(buildFailure));
        }
    }

    private void createPluginService() {
        this.pluginService = this.pluginServiceFactory.create(this.config, this.requiredServices, this.buildState);
        this.pluginServiceRef.set(this.pluginService);
        this.buildOperationNotificationListenerRegistrar.register(this.pluginService.getBuildOperationNotificationListener());
    }

    private class DefaultDevelocityPluginResult
    implements GradleEnterprisePluginEndOfBuildListener.BuildResult {
        private final Throwable buildFailure;

        public DefaultDevelocityPluginResult(Throwable buildFailure) {
            this.buildFailure = buildFailure;
        }

        @Override
        @Nullable
        public Throwable getFailure() {
            return this.buildFailure;
        }

        @Override
        public Collection<Problem> getProblems() {
            return this.getProblems(this.buildFailure);
        }

        @Override
        public Collection<Problem> getProblemsFor(Throwable failure) {
            return DefaultGradleEnterprisePluginAdapter.this.problems.get((Object)this.buildFailure);
        }

        @Nonnull
        private Collection<Problem> getProblems(@Nullable Throwable buildFailure) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            this.getProblems(buildFailure, (ImmutableSet.Builder<Problem>)builder);
            return builder.build();
        }

        private void getProblems(@Nullable Throwable buildFailure, ImmutableSet.Builder<Problem> builder) {
            while (buildFailure != null) {
                if (buildFailure instanceof MultiCauseException) {
                    MultiCauseException multiCauseException = (MultiCauseException)buildFailure;
                    for (Throwable cause : multiCauseException.getCauses()) {
                        this.getProblems(cause, builder);
                    }
                }
                builder.addAll((Iterable)DefaultGradleEnterprisePluginAdapter.this.problems.get((Object)buildFailure));
                buildFailure = buildFailure.getCause();
            }
        }
    }
}

